/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.publication.maven.internal.action;

import java.io.File;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.gradle.api.GradleException;
import org.gradle.api.publication.maven.internal.action.LoggingMavenTransferListener;
import org.gradle.api.publication.maven.internal.action.MavenPublishAction;
import org.gradle.api.publish.maven.internal.publisher.MavenProjectIdentity;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.impldep.org.apache.maven.repository.internal.MavenRepositorySystemSession;
import org.gradle.internal.impldep.org.apache.maven.repository.internal.SnapshotMetadataGeneratorFactory;
import org.gradle.internal.impldep.org.apache.maven.repository.internal.VersionsMetadataGeneratorFactory;
import org.gradle.internal.impldep.org.codehaus.plexus.DefaultContainerConfiguration;
import org.gradle.internal.impldep.org.codehaus.plexus.DefaultPlexusContainer;
import org.gradle.internal.impldep.org.codehaus.plexus.PlexusContainer;
import org.gradle.internal.impldep.org.codehaus.plexus.PlexusContainerException;
import org.gradle.internal.impldep.org.codehaus.plexus.classworlds.ClassWorld;
import org.gradle.internal.impldep.org.codehaus.plexus.classworlds.realm.ClassRealm;
import org.gradle.internal.impldep.org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.gradle.internal.impldep.org.sonatype.aether.RepositoryException;
import org.gradle.internal.impldep.org.sonatype.aether.RepositorySystem;
import org.gradle.internal.impldep.org.sonatype.aether.RepositorySystemSession;
import org.gradle.internal.impldep.org.sonatype.aether.artifact.Artifact;
import org.gradle.internal.impldep.org.sonatype.aether.artifact.ArtifactType;
import org.gradle.internal.impldep.org.sonatype.aether.impl.Deployer;
import org.gradle.internal.impldep.org.sonatype.aether.impl.internal.DefaultDeployer;
import org.gradle.internal.impldep.org.sonatype.aether.impl.internal.SimpleLocalRepositoryManager;
import org.gradle.internal.impldep.org.sonatype.aether.util.DefaultRepositorySystemSession;
import org.gradle.internal.impldep.org.sonatype.aether.util.artifact.DefaultArtifact;
import org.gradle.internal.operations.BuildOperationRef;
import org.gradle.internal.operations.CurrentBuildOperationRef;
import org.gradle.internal.resource.UriTextResource;

abstract class AbstractMavenPublishAction
implements MavenPublishAction {
    private final PlexusContainer container;
    private final DefaultRepositorySystemSession session;
    private final MavenProjectIdentity projectIdentity;
    private final List<Artifact> attached = new ArrayList<Artifact>();
    private Artifact pomArtifact;
    private Artifact mainArtifact;

    protected AbstractMavenPublishAction(String packaging, MavenProjectIdentity projectIdentity, List<File> wagonJars) {
        this.container = this.newPlexusContainer(wagonJars);
        this.session = new MavenRepositorySystemSession();
        this.projectIdentity = projectIdentity;
        CurrentBuildOperationRef currentBuildOperationRef = CurrentBuildOperationRef.instance();
        BuildOperationRef currentBuildOperation = currentBuildOperationRef.get();
        this.session.getConfigProperties().put("aether.connector.userAgent", UriTextResource.getUserAgentString());
        this.session.setTransferListener(new LoggingMavenTransferListener(currentBuildOperationRef, currentBuildOperation));
        this.pomArtifact = new DefaultArtifact(projectIdentity.getGroupId().get(), projectIdentity.getArtifactId().get(), "pom", projectIdentity.getVersion().get());
        this.mainArtifact = this.createTypedArtifact(packaging, null);
    }

    public void setLocalMavenRepositoryLocation(File localMavenRepository) {
        this.session.setLocalRepositoryManager(new SimpleLocalRepositoryManager(localMavenRepository));
    }

    @Override
    public void setPomArtifact(File file) {
        this.pomArtifact = this.pomArtifact.setFile(file);
    }

    @Override
    public void setMainArtifact(File file) {
        this.mainArtifact = this.mainArtifact.setFile(file);
    }

    @Override
    public void addAdditionalArtifact(File file, String type, String classifier) {
        this.attached.add(this.createTypedArtifact(type, classifier).setFile(file));
    }

    @Override
    public void publish() {
        ArrayList<Artifact> artifacts2 = new ArrayList<Artifact>();
        if (this.mainArtifact.getFile() != null) {
            artifacts2.add(this.mainArtifact);
        }
        artifacts2.add(this.pomArtifact);
        for (Artifact artifact : this.attached) {
            File file = artifact.getFile();
            if (file == null || !file.isFile()) continue;
            artifacts2.add(artifact);
        }
        try {
            this.publishArtifacts(artifacts2, this.newRepositorySystem(), this.session);
        }
        catch (RepositoryException e) {
            throw new GradleException(e.getMessage(), e);
        }
    }

    protected abstract void publishArtifacts(Collection<Artifact> var1, RepositorySystem var2, RepositorySystemSession var3) throws RepositoryException;

    protected PlexusContainer getContainer() {
        return this.container;
    }

    private PlexusContainer newPlexusContainer(List<File> wagonJars) {
        try {
            ClassWorld world = new ClassWorld("plexus.core", ClassWorld.class.getClassLoader());
            ClassRealm classRealm = new ClassRealm(world, "plexus.core", ClassWorld.class.getClassLoader());
            if (wagonJars != null) {
                for (File jar : wagonJars) {
                    classRealm.addURL(jar.toURI().toURL());
                }
            }
            return new DefaultPlexusContainer(new DefaultContainerConfiguration().setRealm(classRealm));
        }
        catch (MalformedURLException | PlexusContainerException e) {
            throw UncheckedException.throwAsUncheckedException(e);
        }
    }

    private RepositorySystem newRepositorySystem() {
        try {
            DefaultDeployer deployer = (DefaultDeployer)this.getContainer().lookup(Deployer.class);
            deployer.setMetadataFactories(null);
            deployer.addMetadataGeneratorFactory(new VersionsMetadataGeneratorFactory());
            deployer.addMetadataGeneratorFactory(new SnapshotMetadataGeneratorFactory());
            return this.container.lookup(RepositorySystem.class);
        }
        catch (ComponentLookupException e) {
            throw UncheckedException.throwAsUncheckedException(e);
        }
    }

    private Artifact createTypedArtifact(String type, String classifier) {
        String extension = type;
        ArtifactType stereotype = this.session.getArtifactTypeRegistry().get(type);
        if (stereotype != null) {
            extension = stereotype.getExtension();
            if (classifier == null) {
                classifier = stereotype.getClassifier();
            }
        }
        return new DefaultArtifact(this.projectIdentity.getGroupId().get(), this.projectIdentity.getArtifactId().get(), classifier, extension, this.projectIdentity.getVersion().get());
    }
}

