/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.publication.maven.internal.deployer;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.maven.MavenDeployer;
import org.gradle.api.artifacts.maven.PomFilterContainer;
import org.gradle.api.internal.artifacts.mvnsettings.LocalMavenRepositoryLocator;
import org.gradle.api.internal.artifacts.mvnsettings.MavenSettingsProvider;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.publication.maven.internal.ArtifactPomContainer;
import org.gradle.api.publication.maven.internal.action.MavenPublishAction;
import org.gradle.api.publication.maven.internal.action.MavenWagonDeployAction;
import org.gradle.api.publication.maven.internal.deployer.AbstractMavenResolver;
import org.gradle.api.publish.maven.internal.publisher.MavenProjectIdentity;
import org.gradle.internal.impldep.org.apache.maven.artifact.ant.RemoteRepository;
import org.gradle.internal.logging.LoggingManagerInternal;

public class BaseMavenDeployer
extends AbstractMavenResolver
implements MavenDeployer {
    private RemoteRepository remoteRepository;
    private RemoteRepository remoteSnapshotRepository;
    private Configuration configuration;
    private List<File> protocolProviderJars = new ArrayList<File>();

    public BaseMavenDeployer(PomFilterContainer pomFilterContainer, ArtifactPomContainer artifactPomContainer, LoggingManagerInternal loggingManager, MavenSettingsProvider mavenSettingsProvider, LocalMavenRepositoryLocator mavenRepositoryLocator, ObjectFactory objectFactory) {
        super(pomFilterContainer, artifactPomContainer, loggingManager, mavenSettingsProvider, mavenRepositoryLocator, objectFactory);
    }

    @Override
    protected MavenPublishAction createPublishAction(String packaging, MavenProjectIdentity projectIdentity, LocalMavenRepositoryLocator mavenRepositoryLocator) {
        MavenWagonDeployAction deployAction = new MavenWagonDeployAction(packaging, projectIdentity, this.getJars());
        deployAction.setLocalMavenRepositoryLocation(mavenRepositoryLocator.getLocalMavenRepository());
        deployAction.setRepositories(this.remoteRepository, this.remoteSnapshotRepository);
        return deployAction;
    }

    private List<File> getJars() {
        return this.configuration != null ? new ArrayList<File>(this.configuration.resolve()) : this.protocolProviderJars;
    }

    @Override
    public RemoteRepository getRepository() {
        return this.remoteRepository;
    }

    @Override
    public void setRepository(Object remoteRepository) {
        this.remoteRepository = (RemoteRepository)remoteRepository;
    }

    @Override
    public RemoteRepository getSnapshotRepository() {
        return this.remoteSnapshotRepository;
    }

    @Override
    public void setSnapshotRepository(Object remoteSnapshotRepository) {
        this.remoteSnapshotRepository = (RemoteRepository)remoteSnapshotRepository;
    }

    @Override
    public void addProtocolProviderJars(Collection<File> jars) {
        this.protocolProviderJars.addAll(jars);
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }
}

