/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.publication.maven.internal.pom;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nullable;
import org.gradle.api.NamedDomainObjectSet;
import org.gradle.api.Project;
import org.gradle.api.artifacts.ProjectDependency;
import org.gradle.api.artifacts.maven.MavenDeployer;
import org.gradle.api.artifacts.maven.MavenResolver;
import org.gradle.api.artifacts.repositories.ArtifactRepository;
import org.gradle.api.plugins.BasePluginConvention;
import org.gradle.api.tasks.Upload;
import org.gradle.internal.impldep.com.google.common.collect.Lists;
import org.gradle.internal.impldep.com.google.common.collect.Sets;

class ProjectDependencyArtifactIdExtractorHack {
    private final Project project;

    public ProjectDependencyArtifactIdExtractorHack(ProjectDependency dependency) {
        this.project = dependency.getDependencyProject();
    }

    public String extract() {
        String artifactId;
        NamedDomainObjectSet tasks = this.project.getTasks().withType(Upload.class);
        Collection<ArtifactRepository> repositories = this.getRepositories(tasks);
        if (!this.onlyContainsMavenResolvers(repositories)) {
            return this.project.getName();
        }
        Collection<MavenDeployer> deployers = this.getMavenDeployers(repositories);
        Set<String> artifactIds = this.getArtifactIds(deployers);
        if (artifactIds.size() == 1 && (artifactId = artifactIds.iterator().next()) != null && !artifactId.equals("empty-project")) {
            return artifactId;
        }
        String baseName = this.getArchivesBaseName();
        return baseName != null ? baseName : this.project.getName();
    }

    private Collection<ArtifactRepository> getRepositories(Collection<Upload> tasks) {
        ArrayList<ArtifactRepository> result = Lists.newArrayList();
        for (Upload task : tasks) {
            result.addAll(task.getRepositories());
        }
        return result;
    }

    private boolean onlyContainsMavenResolvers(Collection<ArtifactRepository> repositories) {
        for (ArtifactRepository repository : repositories) {
            if (repository instanceof MavenResolver) continue;
            return false;
        }
        return true;
    }

    private Collection<MavenDeployer> getMavenDeployers(Collection<ArtifactRepository> repositories) {
        ArrayList<MavenDeployer> result = Lists.newArrayList();
        for (ArtifactRepository repository : repositories) {
            if (!(repository instanceof MavenDeployer)) continue;
            result.add((MavenDeployer)repository);
        }
        return result;
    }

    private Set<String> getArtifactIds(Collection<MavenDeployer> deployers) {
        HashSet<String> result = Sets.newHashSet();
        for (MavenDeployer deployer : deployers) {
            result.add(deployer.getPom().getArtifactId());
        }
        return result;
    }

    @Nullable
    private String getArchivesBaseName() {
        BasePluginConvention convention = this.project.getConvention().findPlugin(BasePluginConvention.class);
        return convention != null ? convention.getArchivesBaseName() : null;
    }
}

