/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.publish.maven.tasks;

import java.io.File;
import javax.inject.Inject;
import org.gradle.api.DefaultTask;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.api.publication.maven.internal.VersionRangeMapper;
import org.gradle.api.publish.maven.MavenDependency;
import org.gradle.api.publish.maven.MavenPom;
import org.gradle.api.publish.maven.internal.dependencies.MavenDependencyInternal;
import org.gradle.api.publish.maven.internal.publication.MavenPomInternal;
import org.gradle.api.publish.maven.internal.tasks.MavenPomFileGenerator;
import org.gradle.api.specs.Specs;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskAction;
import org.gradle.internal.serialization.Cached;
import org.gradle.internal.serialization.Transient;

public class GenerateMavenPom
extends DefaultTask {
    private final Transient.Var<MavenPom> pom = Transient.varOf();
    private final Transient.Var<ImmutableAttributes> compileScopeAttributes = Transient.varOf(ImmutableAttributes.EMPTY);
    private final Transient.Var<ImmutableAttributes> runtimeScopeAttributes = Transient.varOf(ImmutableAttributes.EMPTY);
    private Object destination;
    private final Cached<MavenPomFileGenerator.MavenPomSpec> mavenPomSpec = Cached.of(this::computeMavenPomSpec);

    public GenerateMavenPom() {
        this.getOutputs().upToDateWhen(Specs.satisfyNone());
    }

    @Inject
    protected FileResolver getFileResolver() {
        throw new UnsupportedOperationException();
    }

    @Inject
    protected VersionRangeMapper getVersionRangeMapper() {
        throw new UnsupportedOperationException();
    }

    public GenerateMavenPom withCompileScopeAttributes(ImmutableAttributes compileScopeAttributes) {
        this.compileScopeAttributes.set(compileScopeAttributes);
        return this;
    }

    public GenerateMavenPom withRuntimeScopeAttributes(ImmutableAttributes runtimeScopeAttributes) {
        this.runtimeScopeAttributes.set(runtimeScopeAttributes);
        return this;
    }

    @Internal
    public MavenPom getPom() {
        return (MavenPom)this.pom.get();
    }

    public void setPom(MavenPom pom) {
        this.pom.set(pom);
    }

    @OutputFile
    public File getDestination() {
        return this.destination == null ? null : this.getFileResolver().resolve(this.destination);
    }

    public void setDestination(File destination) {
        this.destination = destination;
    }

    public void setDestination(Object destination) {
        this.destination = destination;
    }

    @TaskAction
    public void doGenerate() {
        this.mavenPomSpec().writeTo(this.getDestination());
    }

    private MavenPomFileGenerator.MavenPomSpec mavenPomSpec() {
        return this.mavenPomSpec.get();
    }

    private MavenPomFileGenerator.MavenPomSpec computeMavenPomSpec() {
        MavenPomInternal pomInternal = (MavenPomInternal)this.getPom();
        MavenPomFileGenerator pomGenerator = new MavenPomFileGenerator(pomInternal.getProjectIdentity(), this.getVersionRangeMapper(), pomInternal.getVersionMappingStrategy(), (ImmutableAttributes)this.compileScopeAttributes.get(), (ImmutableAttributes)this.runtimeScopeAttributes.get(), pomInternal.writeGradleMetadataMarker());
        pomGenerator.configureFrom(pomInternal);
        for (MavenDependency mavenDependency : pomInternal.getApiDependencyManagement()) {
            pomGenerator.addApiDependencyManagement(mavenDependency);
        }
        for (MavenDependency mavenDependency : pomInternal.getRuntimeDependencyManagement()) {
            pomGenerator.addRuntimeDependencyManagement(mavenDependency);
        }
        for (MavenDependency mavenDependency : pomInternal.getImportDependencyManagement()) {
            pomGenerator.addImportDependencyManagement(mavenDependency);
        }
        for (MavenDependencyInternal runtimeDependency : pomInternal.getApiDependencies()) {
            pomGenerator.addApiDependency(runtimeDependency);
        }
        for (MavenDependencyInternal runtimeDependency : pomInternal.getRuntimeDependencies()) {
            pomGenerator.addRuntimeDependency(runtimeDependency);
        }
        for (MavenDependencyInternal optionalDependency : pomInternal.getOptionalDependencies()) {
            pomGenerator.addOptionalDependency(optionalDependency);
        }
        pomGenerator.withXml(pomInternal.getXmlAction());
        return pomGenerator.toSpec();
    }
}

