/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.tasks.compile;

import java.io.File;
import java.util.List;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.gradle.api.Incubating;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.JavaVersion;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileTree;
import org.gradle.api.file.ProjectLayout;
import org.gradle.api.internal.FeaturePreviews;
import org.gradle.api.internal.file.FileOperations;
import org.gradle.api.internal.file.FileTreeInternal;
import org.gradle.api.internal.file.TemporaryFileProvider;
import org.gradle.api.internal.tasks.JavaToolChainFactory;
import org.gradle.api.internal.tasks.compile.CleaningJavaCompiler;
import org.gradle.api.internal.tasks.compile.CompilationSourceDirs;
import org.gradle.api.internal.tasks.compile.CompilerForkUtils;
import org.gradle.api.internal.tasks.compile.DefaultGroovyJavaJointCompileSpec;
import org.gradle.api.internal.tasks.compile.DefaultGroovyJavaJointCompileSpecFactory;
import org.gradle.api.internal.tasks.compile.GroovyCompilerFactory;
import org.gradle.api.internal.tasks.compile.GroovyJavaJointCompileSpec;
import org.gradle.api.internal.tasks.compile.HasCompileOptions;
import org.gradle.api.internal.tasks.compile.SourceClassesMappingFileAccessor;
import org.gradle.api.internal.tasks.compile.incremental.IncrementalCompilerFactory;
import org.gradle.api.internal.tasks.compile.incremental.recomp.DefaultSourceFileClassNameConverter;
import org.gradle.api.internal.tasks.compile.incremental.recomp.GroovyRecompilationSpecProvider;
import org.gradle.api.internal.tasks.compile.incremental.recomp.IncrementalCompilationResult;
import org.gradle.api.internal.tasks.compile.incremental.recomp.RecompilationSpecProvider;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.model.ReplacedBy;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Classpath;
import org.gradle.api.tasks.CompileClasspath;
import org.gradle.api.tasks.IgnoreEmptyDirectories;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.LocalState;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.SkipWhenEmpty;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.WorkResult;
import org.gradle.api.tasks.compile.AbstractCompile;
import org.gradle.api.tasks.compile.CompileOptions;
import org.gradle.api.tasks.compile.ForkOptions;
import org.gradle.api.tasks.compile.GroovyCompileOptions;
import org.gradle.internal.file.Deleter;
import org.gradle.internal.impldep.com.google.common.base.Preconditions;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableList;
import org.gradle.internal.impldep.com.google.common.collect.Lists;
import org.gradle.internal.impldep.com.google.common.collect.Multimap;
import org.gradle.internal.jvm.Jvm;
import org.gradle.jvm.toolchain.JavaInstallationMetadata;
import org.gradle.jvm.toolchain.JavaLauncher;
import org.gradle.jvm.toolchain.JavaToolChain;
import org.gradle.language.base.internal.compile.Compiler;
import org.gradle.util.GFileUtils;
import org.gradle.util.IncubationLogger;
import org.gradle.work.Incremental;
import org.gradle.work.InputChanges;

@CacheableTask
public class GroovyCompile
extends AbstractCompile
implements HasCompileOptions {
    private FileCollection groovyClasspath;
    private final ConfigurableFileCollection astTransformationClasspath;
    private final CompileOptions compileOptions;
    private final GroovyCompileOptions groovyCompileOptions = new GroovyCompileOptions();
    private final FileCollection stableSources = this.getProject().files(this::getSource);
    private final Property<JavaLauncher> javaLauncher;
    private File sourceClassesMappingFile;

    public GroovyCompile() {
        ObjectFactory objectFactory = this.getObjectFactory();
        CompileOptions compileOptions = objectFactory.newInstance(CompileOptions.class, new Object[0]);
        compileOptions.setIncremental(false);
        this.compileOptions = compileOptions;
        this.astTransformationClasspath = objectFactory.fileCollection();
        this.javaLauncher = objectFactory.property(JavaLauncher.class);
        if (!this.experimentalCompilationAvoidanceEnabled()) {
            this.astTransformationClasspath.from(this::getClasspath);
        }
        CompilerForkUtils.doNotCacheIfForkingViaExecutable(compileOptions, this.getOutputs());
    }

    @Override
    @CompileClasspath
    @Incremental
    public FileCollection getClasspath() {
        return super.getClasspath();
    }

    @Classpath
    @Incubating
    public ConfigurableFileCollection getAstTransformationClasspath() {
        return this.astTransformationClasspath;
    }

    private boolean experimentalCompilationAvoidanceEnabled() {
        return this.getFeaturePreviews().isFeatureEnabled(FeaturePreviews.Feature.GROOVY_COMPILATION_AVOIDANCE);
    }

    @TaskAction
    protected void compile(InputChanges inputChanges) {
        this.checkGroovyClasspathIsNonEmpty();
        this.warnIfCompileAvoidanceEnabled();
        GroovyJavaJointCompileSpec spec = this.createSpec();
        if (inputChanges != null && spec.incrementalCompilationEnabled()) {
            this.doIncrementalCompile(spec, inputChanges);
        } else {
            this.doCompile(spec, inputChanges, null);
        }
    }

    private void doIncrementalCompile(GroovyJavaJointCompileSpec spec, InputChanges inputChanges) {
        Multimap<String, String> oldMappings = SourceClassesMappingFileAccessor.readSourceClassesMappingFile(this.getSourceClassesMappingFile());
        this.getSourceClassesMappingFile().delete();
        WorkResult result = this.doCompile(spec, inputChanges, oldMappings);
        if (result instanceof IncrementalCompilationResult) {
            SourceClassesMappingFileAccessor.mergeIncrementalMappingsIntoOldMappings(this.getSourceClassesMappingFile(), this.getStableSources(), inputChanges, oldMappings);
        }
    }

    private WorkResult doCompile(GroovyJavaJointCompileSpec spec, InputChanges inputChanges, Multimap<String, String> sourceClassesMapping) {
        WorkResult result = this.getCompiler(spec, inputChanges, sourceClassesMapping).execute(spec);
        this.setDidWork(result.getDidWork());
        return result;
    }

    @LocalState
    @Incubating
    protected File getSourceClassesMappingFile() {
        if (this.sourceClassesMappingFile == null) {
            File tmpDir = this.getServices().get(TemporaryFileProvider.class).newTemporaryFile(this.getName());
            this.sourceClassesMappingFile = new File(tmpDir, "source-classes-mapping.txt");
        }
        return this.sourceClassesMappingFile;
    }

    private void warnIfCompileAvoidanceEnabled() {
        if (this.experimentalCompilationAvoidanceEnabled()) {
            IncubationLogger.incubatingFeatureUsed("Groovy compilation avoidance");
        }
    }

    private Compiler<GroovyJavaJointCompileSpec> getCompiler(GroovyJavaJointCompileSpec spec, InputChanges inputChanges, Multimap<String, String> sourceClassesMapping) {
        GroovyCompilerFactory groovyCompilerFactory = this.getGroovyCompilerFactory();
        Compiler<GroovyJavaJointCompileSpec> delegatingCompiler = groovyCompilerFactory.newCompiler(spec);
        CleaningJavaCompiler<GroovyJavaJointCompileSpec> cleaningGroovyCompiler = new CleaningJavaCompiler<GroovyJavaJointCompileSpec>(delegatingCompiler, this.getOutputs(), this.getDeleter());
        if (spec.incrementalCompilationEnabled()) {
            IncrementalCompilerFactory factory = this.getIncrementalCompilerFactory();
            return factory.makeIncremental(cleaningGroovyCompiler, this.getPath(), this.getStableSources().getAsFileTree(), this.createRecompilationSpecProvider(inputChanges, sourceClassesMapping));
        }
        return cleaningGroovyCompiler;
    }

    @Inject
    protected GroovyCompilerFactory getGroovyCompilerFactory() {
        throw new UnsupportedOperationException();
    }

    private RecompilationSpecProvider createRecompilationSpecProvider(InputChanges inputChanges, Multimap<String, String> sourceClassesMapping) {
        FileCollection stableSources = this.getStableSources();
        return new GroovyRecompilationSpecProvider(this.getDeleter(), this.getServices().get(FileOperations.class), stableSources.getAsFileTree(), inputChanges.isIncremental(), () -> inputChanges.getFileChanges(stableSources).iterator(), new DefaultSourceFileClassNameConverter(sourceClassesMapping));
    }

    @Incubating
    @SkipWhenEmpty
    @IgnoreEmptyDirectories
    @PathSensitive(value=PathSensitivity.RELATIVE)
    @InputFiles
    protected FileCollection getStableSources() {
        return this.stableSources;
    }

    @Inject
    protected IncrementalCompilerFactory getIncrementalCompilerFactory() {
        throw new UnsupportedOperationException();
    }

    @Inject
    protected Deleter getDeleter() {
        throw new UnsupportedOperationException("Decorator takes care of injection");
    }

    @Inject
    protected ProjectLayout getProjectLayout() {
        throw new UnsupportedOperationException();
    }

    @Inject
    protected ObjectFactory getObjectFactory() {
        throw new UnsupportedOperationException();
    }

    private FileCollection determineGroovyCompileClasspath() {
        if (this.experimentalCompilationAvoidanceEnabled()) {
            return this.astTransformationClasspath.plus(this.getClasspath());
        }
        return this.getClasspath();
    }

    private static void validateIncrementalCompilationOptions(List<File> sourceRoots, boolean annotationProcessingConfigured) {
        if (sourceRoots.isEmpty()) {
            throw new InvalidUserDataException("Unable to infer source roots. Incremental Groovy compilation requires the source roots. Change the configuration of your sources or disable incremental Groovy compilation.");
        }
        if (annotationProcessingConfigured) {
            throw new InvalidUserDataException("Enabling incremental compilation and configuring Java annotation processors for Groovy compilation is not allowed. Disable incremental Groovy compilation or remove the Java annotation processor configuration.");
        }
    }

    @Nullable
    private JavaInstallationMetadata getToolchain() {
        return this.javaLauncher.map(JavaLauncher::getMetadata).getOrNull();
    }

    private GroovyJavaJointCompileSpec createSpec() {
        this.validateConfiguration();
        DefaultGroovyJavaJointCompileSpec spec = (DefaultGroovyJavaJointCompileSpec)new DefaultGroovyJavaJointCompileSpecFactory(this.compileOptions, this.getToolchain()).create();
        assert (spec != null);
        FileTreeInternal stableSourcesAsFileTree = (FileTreeInternal)this.getStableSources().getAsFileTree();
        List<File> sourceRoots = CompilationSourceDirs.inferSourceRoots(stableSourcesAsFileTree);
        spec.setSourcesRoots(sourceRoots);
        spec.setSourceFiles(stableSourcesAsFileTree);
        spec.setDestinationDir(this.getDestinationDirectory().getAsFile().get());
        spec.setWorkingDir(this.getProjectLayout().getProjectDirectory().getAsFile());
        spec.setTempDir(this.getTemporaryDir());
        spec.setCompileClasspath(ImmutableList.copyOf(this.determineGroovyCompileClasspath()));
        this.configureCompatibilityOptions(spec);
        spec.setAnnotationProcessorPath(Lists.newArrayList(this.compileOptions.getAnnotationProcessorPath() == null ? this.getProjectLayout().files(new Object[0]) : this.compileOptions.getAnnotationProcessorPath()));
        spec.setGroovyClasspath(Lists.newArrayList(this.getGroovyClasspath()));
        spec.setCompileOptions(this.compileOptions);
        spec.setGroovyCompileOptions(this.groovyCompileOptions);
        if (this.getOptions().isIncremental()) {
            GroovyCompile.validateIncrementalCompilationOptions(sourceRoots, spec.annotationProcessingConfigured());
            spec.setCompilationMappingFile(this.getSourceClassesMappingFile());
        }
        if (spec.getGroovyCompileOptions().getStubDir() == null) {
            File dir2 = new File(this.getTemporaryDir(), "groovy-java-stubs");
            GFileUtils.mkdirs(dir2);
            spec.getGroovyCompileOptions().setStubDir(dir2);
        }
        this.configureExecutable(spec.getCompileOptions().getForkOptions());
        return spec;
    }

    private void configureCompatibilityOptions(DefaultGroovyJavaJointCompileSpec spec) {
        JavaInstallationMetadata toolchain = this.getToolchain();
        if (toolchain != null) {
            boolean isSourceOrTargetConfigured = false;
            if (super.getSourceCompatibility() != null) {
                spec.setSourceCompatibility(this.getSourceCompatibility());
                isSourceOrTargetConfigured = true;
            }
            if (super.getTargetCompatibility() != null) {
                spec.setTargetCompatibility(this.getTargetCompatibility());
                isSourceOrTargetConfigured = true;
            }
            if (!isSourceOrTargetConfigured) {
                String languageVersion = toolchain.getLanguageVersion().toString();
                spec.setSourceCompatibility(languageVersion);
                spec.setTargetCompatibility(languageVersion);
            }
        } else {
            spec.setSourceCompatibility(this.getSourceCompatibility());
            spec.setTargetCompatibility(this.getTargetCompatibility());
        }
    }

    private void configureExecutable(ForkOptions forkOptions) {
        if (this.javaLauncher.isPresent()) {
            forkOptions.setExecutable(((JavaLauncher)this.javaLauncher.get()).getExecutablePath().getAsFile().getAbsolutePath());
        } else {
            forkOptions.setExecutable(Jvm.current().getJavaExecutable().getAbsolutePath());
        }
    }

    private void validateConfiguration() {
        if (this.javaLauncher.isPresent()) {
            Preconditions.checkState(this.getOptions().getForkOptions().getJavaHome() == null, "Must not use `javaHome` property on `ForkOptions` together with `javaLauncher` property");
            Preconditions.checkState(this.getOptions().getForkOptions().getExecutable() == null, "Must not use `executable` property on `ForkOptions` together with `javaLauncher` property");
        }
    }

    private void checkGroovyClasspathIsNonEmpty() {
        if (this.getGroovyClasspath().isEmpty()) {
            throw new InvalidUserDataException("'" + this.getName() + ".groovyClasspath' must not be empty. If a Groovy compile dependency is provided, the 'groovy-base' plugin will attempt to configure 'groovyClasspath' automatically. Alternatively, you may configure 'groovyClasspath' explicitly.");
        }
    }

    @Input
    protected String getGroovyCompilerJvmVersion() {
        if (this.javaLauncher.isPresent()) {
            return ((JavaLauncher)this.javaLauncher.get()).getMetadata().getLanguageVersion().toString();
        }
        return JavaVersion.current().getMajorVersion();
    }

    @Nested
    @Deprecated
    protected JavaToolChain getJavaToolChain() {
        return this.getJavaToolChainFactory().forCompileOptions(this.getOptions());
    }

    @Override
    @ReplacedBy(value="stableSources")
    public FileTree getSource() {
        return super.getSource();
    }

    @Nested
    public GroovyCompileOptions getGroovyOptions() {
        return this.groovyCompileOptions;
    }

    @Override
    @Nested
    public CompileOptions getOptions() {
        return this.compileOptions;
    }

    @Classpath
    public FileCollection getGroovyClasspath() {
        return this.groovyClasspath;
    }

    public void setGroovyClasspath(FileCollection groovyClasspath) {
        this.groovyClasspath = groovyClasspath;
    }

    @Incubating
    @Nested
    @Optional
    public Property<JavaLauncher> getJavaLauncher() {
        return this.javaLauncher;
    }

    @Inject
    protected JavaToolChainFactory getJavaToolChainFactory() {
        throw new UnsupportedOperationException();
    }

    @Inject
    protected FeaturePreviews getFeaturePreviews() {
        throw new UnsupportedOperationException();
    }
}

