/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.tasks.diagnostics.internal;

import java.util.Comparator;
import java.util.Set;
import javax.annotation.Nullable;
import org.gradle.api.tasks.diagnostics.internal.TaskDetails;
import org.gradle.api.tasks.diagnostics.internal.TaskReportModel;
import org.gradle.internal.impldep.com.google.common.collect.SetMultimap;
import org.gradle.internal.impldep.com.google.common.collect.TreeMultimap;
import org.gradle.util.GUtil;
import org.gradle.util.Path;

public class DefaultGroupTaskReportModel
implements TaskReportModel {
    public static final String OTHER_GROUP = "other";
    private static final Comparator<String> STRING_COMPARATOR = GUtil.caseInsensitive();
    private final SetMultimap<String, TaskDetails> groups;

    public static DefaultGroupTaskReportModel of(TaskReportModel model) {
        Comparator<String> keyComparator = GUtil.last(GUtil.last(STRING_COMPARATOR, OTHER_GROUP), "");
        Comparator taskComparator = (task1, task2) -> {
            int diff = STRING_COMPARATOR.compare(task1.getPath().getName(), task2.getPath().getName());
            if (diff != 0) {
                return diff;
            }
            Path parent1 = task1.getPath().getParent();
            Path parent2 = task2.getPath().getParent();
            if (parent1 == null && parent2 != null) {
                return -1;
            }
            if (parent1 != null && parent2 == null) {
                return 1;
            }
            if (parent1 == null) {
                return 0;
            }
            return parent1.compareTo(parent2);
        };
        TreeMultimap<String, TaskDetails> groups = TreeMultimap.create(keyComparator, taskComparator);
        for (String group : model.getGroups()) {
            groups.putAll(group, model.getTasksForGroup(group));
        }
        String otherGroupName = DefaultGroupTaskReportModel.findOtherGroup(groups.keySet());
        if (otherGroupName != null && groups.keySet().contains("")) {
            groups.putAll(otherGroupName, groups.removeAll(""));
        }
        if (groups.keySet().contains("") && groups.keySet().size() > 1) {
            groups.putAll(OTHER_GROUP, groups.removeAll(""));
        }
        return new DefaultGroupTaskReportModel(groups);
    }

    private DefaultGroupTaskReportModel(SetMultimap<String, TaskDetails> groups) {
        this.groups = groups;
    }

    @Nullable
    private static String findOtherGroup(Set<String> groupNames) {
        for (String groupName : groupNames) {
            if (!groupName.equalsIgnoreCase(OTHER_GROUP)) continue;
            return groupName;
        }
        return null;
    }

    @Override
    public Set<String> getGroups() {
        return this.groups.keySet();
    }

    @Override
    public Set<TaskDetails> getTasksForGroup(String group) {
        return this.groups.get(group);
    }
}

