/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.tasks.diagnostics.internal;

import java.util.Collection;
import java.util.Comparator;
import java.util.Set;
import org.gradle.api.Task;
import org.gradle.api.tasks.diagnostics.internal.TaskDetails;
import org.gradle.api.tasks.diagnostics.internal.TaskDetailsFactory;
import org.gradle.api.tasks.diagnostics.internal.TaskReportModel;
import org.gradle.internal.impldep.com.google.common.collect.SetMultimap;
import org.gradle.internal.impldep.com.google.common.collect.TreeMultimap;
import org.gradle.util.GUtil;

public class SingleProjectTaskReportModel
implements TaskReportModel {
    private final SetMultimap<String, TaskDetails> groups;

    public static SingleProjectTaskReportModel forTasks(Collection<? extends Task> tasks, TaskDetailsFactory factory) {
        TreeMultimap<String, TaskDetails> groups = TreeMultimap.create(String::compareToIgnoreCase, Comparator.comparing(TaskDetails::getPath));
        for (Task task : tasks) {
            String group = GUtil.isTrue(task.getGroup()) ? task.getGroup() : "";
            groups.put(group, factory.create(task));
        }
        return new SingleProjectTaskReportModel(groups);
    }

    private SingleProjectTaskReportModel(SetMultimap<String, TaskDetails> groups) {
        this.groups = groups;
    }

    @Override
    public Set<String> getGroups() {
        return this.groups.keySet();
    }

    @Override
    public Set<TaskDetails> getTasksForGroup(String group) {
        if (!this.groups.containsKey(group)) {
            throw new IllegalArgumentException(String.format("Unknown group '%s'", group));
        }
        return this.groups.get(group);
    }
}

