/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.buildinit.plugins.internal.maven;

import java.io.File;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.gradle.buildinit.plugins.internal.maven.MavenConversionException;
import org.gradle.internal.SystemProperties;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableList;
import org.gradle.internal.impldep.org.apache.maven.execution.DefaultMavenExecutionRequest;
import org.gradle.internal.impldep.org.apache.maven.execution.DefaultMavenExecutionResult;
import org.gradle.internal.impldep.org.apache.maven.execution.MavenExecutionRequestPopulationException;
import org.gradle.internal.impldep.org.apache.maven.execution.MavenExecutionRequestPopulator;
import org.gradle.internal.impldep.org.apache.maven.execution.MavenSession;
import org.gradle.internal.impldep.org.apache.maven.project.MavenProject;
import org.gradle.internal.impldep.org.apache.maven.project.ProjectBuilder;
import org.gradle.internal.impldep.org.apache.maven.project.ProjectBuildingException;
import org.gradle.internal.impldep.org.apache.maven.project.ProjectBuildingRequest;
import org.gradle.internal.impldep.org.apache.maven.project.ProjectBuildingResult;
import org.gradle.internal.impldep.org.apache.maven.settings.Settings;
import org.gradle.internal.impldep.org.codehaus.plexus.ContainerConfiguration;
import org.gradle.internal.impldep.org.codehaus.plexus.DefaultContainerConfiguration;
import org.gradle.internal.impldep.org.codehaus.plexus.DefaultPlexusContainer;
import org.gradle.internal.impldep.org.codehaus.plexus.PlexusContainer;
import org.gradle.internal.impldep.org.codehaus.plexus.PlexusContainerException;
import org.gradle.internal.impldep.org.codehaus.plexus.classworlds.ClassWorld;
import org.gradle.internal.impldep.org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.gradle.internal.impldep.org.sonatype.aether.util.DefaultRepositorySystemSession;
import org.gradle.util.CollectionUtils;

public class MavenProjectsCreator {
    public Set<MavenProject> create(Settings mavenSettings, File pomFile) {
        if (!pomFile.exists()) {
            throw new MavenConversionException(String.format("Unable to create Maven project model. The POM file %s does not exist.", pomFile));
        }
        try {
            return this.createNow(mavenSettings, pomFile);
        }
        catch (Exception e) {
            throw new MavenConversionException(String.format("Unable to create Maven project model using POM %s.", pomFile), e);
        }
    }

    private Set<MavenProject> createNow(Settings settings, File pomFile) throws PlexusContainerException, ComponentLookupException, MavenExecutionRequestPopulationException, ProjectBuildingException {
        ContainerConfiguration containerConfiguration = new DefaultContainerConfiguration().setClassWorld(new ClassWorld("plexus.core", ClassWorld.class.getClassLoader())).setName("mavenCore");
        DefaultPlexusContainer container = new DefaultPlexusContainer(containerConfiguration);
        ProjectBuilder builder = container.lookup(ProjectBuilder.class);
        DefaultMavenExecutionRequest executionRequest = new DefaultMavenExecutionRequest();
        Properties properties = SystemProperties.getInstance().withSystemProperties(() -> {
            Properties currentProperties = new Properties();
            currentProperties.putAll((Map<?, ?>)System.getProperties());
            return currentProperties;
        });
        executionRequest.setSystemProperties(properties);
        MavenExecutionRequestPopulator populator = container.lookup(MavenExecutionRequestPopulator.class);
        populator.populateFromSettings(executionRequest, settings);
        populator.populateDefaults(executionRequest);
        ProjectBuildingRequest buildingRequest = executionRequest.getProjectBuildingRequest();
        buildingRequest.getRemoteRepositories().forEach(repository -> {
            if (repository.getId().equals("central")) {
                repository.setUrl("https://repo.maven.apache.org/maven2/");
            }
        });
        buildingRequest.setProcessPlugins(false);
        MavenProject mavenProject = builder.build(pomFile, buildingRequest).getProject();
        LinkedHashSet<MavenProject> reactorProjects = new LinkedHashSet<MavenProject>();
        reactorProjects.add(mavenProject);
        List<ProjectBuildingResult> allProjects = builder.build(ImmutableList.of(pomFile), true, buildingRequest);
        CollectionUtils.collect(allProjects, reactorProjects, ProjectBuildingResult::getProject);
        DefaultMavenExecutionResult result = new DefaultMavenExecutionResult();
        result.setProject(mavenProject);
        DefaultRepositorySystemSession repoSession = new DefaultRepositorySystemSession();
        MavenSession session = new MavenSession((PlexusContainer)container, repoSession, executionRequest, result);
        session.setCurrentProject(mavenProject);
        return reactorProjects;
    }
}

