/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.cache.internal;

import java.util.function.Function;
import org.gradle.cache.Cache;
import org.gradle.internal.concurrent.Synchronizer;

public class CacheAccessSerializer<K, V>
implements Cache<K, V> {
    private final Synchronizer synchronizer = new Synchronizer();
    private final Cache<K, V> cache;

    public CacheAccessSerializer(Cache<K, V> cache2) {
        this.cache = cache2;
    }

    @Override
    public V get(K key, Function<? super K, ? extends V> factory) {
        return (V)this.synchronizer.synchronize(() -> this.cache.get(key, factory));
    }

    @Override
    public V getIfPresent(K key) {
        return (V)this.synchronizer.synchronize(() -> this.cache.getIfPresent(key));
    }

    @Override
    public void put(K key, V value) {
        this.synchronizer.synchronize(() -> this.cache.put(key, value));
    }
}

