/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.cache.internal;

import java.util.function.Function;
import org.gradle.cache.Cache;
import org.gradle.cache.PersistentIndexedCache;

public class MinimalPersistentCache<K, V>
implements Cache<K, V> {
    private final PersistentIndexedCache<K, V> cache;

    public MinimalPersistentCache(PersistentIndexedCache<K, V> cache2) {
        this.cache = cache2;
    }

    @Override
    public V get(K key, Function<? super K, ? extends V> factory) {
        V cached = this.cache.getIfPresent(key);
        if (cached != null) {
            return cached;
        }
        V value = factory.apply(key);
        this.cache.put(key, value);
        return value;
    }

    @Override
    public V getIfPresent(K value) {
        return this.cache.getIfPresent(value);
    }

    @Override
    public void put(K key, V value) {
        this.cache.put(key, value);
    }
}

