/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.cache.internal;

import java.io.File;
import java.io.FileFilter;
import java.util.ArrayDeque;
import java.util.Collections;
import java.util.Deque;
import java.util.Iterator;
import javax.annotation.Nonnull;
import org.gradle.cache.internal.FilesFinder;
import org.gradle.internal.impldep.com.google.common.base.Preconditions;
import org.gradle.internal.impldep.com.google.common.collect.AbstractIterator;
import org.gradle.internal.impldep.com.google.common.collect.Iterators;

public class SingleDepthFilesFinder
implements FilesFinder {
    private final int depth;

    public SingleDepthFilesFinder(int depth) {
        Preconditions.checkArgument(depth > 0, "depth must be > 0: %s", depth);
        this.depth = depth;
    }

    @Override
    public Iterable<File> find(final File baseDir, final FileFilter filter) {
        return new Iterable<File>(){

            @Override
            @Nonnull
            public Iterator<File> iterator() {
                return new SingleDepthFileIterator(baseDir, filter);
            }
        };
    }

    private class SingleDepthFileIterator
    extends AbstractIterator<File> {
        private final Deque<Iterator<File>> stack = new ArrayDeque<Iterator<File>>();
        private final int targetSize;
        private final FileFilter filter;

        SingleDepthFileIterator(File baseDir, FileFilter filter) {
            this.stack.push(Iterators.singletonIterator(baseDir));
            this.filter = filter;
            this.targetSize = SingleDepthFilesFinder.this.depth + 1;
        }

        @Override
        protected File computeNext() {
            this.advanceIfNecessary();
            if (this.stack.isEmpty()) {
                return (File)this.endOfData();
            }
            return this.stack.getLast().next();
        }

        private void advanceIfNecessary() {
            while (!this.stack.isEmpty() && !this.hasNextWithCorrectDepth()) {
                if (this.stack.getLast().hasNext()) {
                    File next = this.stack.getLast().next();
                    this.stack.addLast(this.listFiles(next));
                    continue;
                }
                this.stack.removeLast();
            }
        }

        private boolean hasNextWithCorrectDepth() {
            return this.stack.size() == this.targetSize && this.stack.getLast().hasNext();
        }

        private Iterator<File> listFiles(File baseDir) {
            File[] files = baseDir.listFiles(this.filter);
            return files == null ? Collections.emptyIterator() : Iterators.forArray(files);
        }
    }
}

