/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.cache.internal;

import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.SortedSet;
import javax.annotation.Nullable;
import org.gradle.cache.internal.VersionSpecificCacheDirectory;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableSortedSet;
import org.gradle.internal.impldep.org.apache.commons.io.filefilter.FileFilterUtils;
import org.gradle.internal.impldep.org.apache.commons.io.filefilter.IOFileFilter;
import org.gradle.internal.impldep.org.apache.commons.io.filefilter.RegexFileFilter;
import org.gradle.util.GradleVersion;

public class VersionSpecificCacheDirectoryScanner {
    private final File baseDir;

    public VersionSpecificCacheDirectoryScanner(File baseDir) {
        this.baseDir = baseDir;
    }

    public File getBaseDir() {
        return this.baseDir;
    }

    public File getDirectory(GradleVersion gradleVersion) {
        return new File(this.baseDir, gradleVersion.getVersion());
    }

    public SortedSet<VersionSpecificCacheDirectory> getExistingDirectories() {
        ImmutableSortedSet.Builder builder = ImmutableSortedSet.naturalOrder();
        for (File subDir : this.listVersionSpecificCacheDirs()) {
            GradleVersion version = this.tryParseGradleVersion(subDir);
            if (version == null) continue;
            builder.add(new VersionSpecificCacheDirectory(subDir, version));
        }
        return builder.build();
    }

    private Collection<File> listVersionSpecificCacheDirs() {
        IOFileFilter combinedFilter = FileFilterUtils.and(FileFilterUtils.directoryFileFilter(), new RegexFileFilter("^\\d.*"));
        File[] result = this.baseDir.listFiles(combinedFilter);
        return result == null ? Collections.emptySet() : Arrays.asList(result);
    }

    @Nullable
    private GradleVersion tryParseGradleVersion(File dir2) {
        try {
            return GradleVersion.version(dir2.getName());
        }
        catch (Exception e) {
            return null;
        }
    }
}

