/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.caching.local.internal;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.annotation.Nonnull;
import org.gradle.api.Action;
import org.gradle.api.UncheckedIOException;
import org.gradle.cache.PersistentCache;
import org.gradle.caching.BuildCacheEntryReader;
import org.gradle.caching.BuildCacheEntryWriter;
import org.gradle.caching.BuildCacheException;
import org.gradle.caching.BuildCacheKey;
import org.gradle.caching.BuildCacheService;
import org.gradle.caching.local.internal.BuildCacheTempFileStore;
import org.gradle.caching.local.internal.LocalBuildCacheService;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.file.FileAccessTracker;
import org.gradle.internal.impldep.com.google.common.io.Closer;
import org.gradle.internal.resource.local.LocallyAvailableResource;
import org.gradle.internal.resource.local.PathKeyFileStore;
import org.gradle.util.GFileUtils;

public class DirectoryBuildCacheService
implements LocalBuildCacheService,
BuildCacheService {
    private final PathKeyFileStore fileStore;
    private final PersistentCache persistentCache;
    private final BuildCacheTempFileStore tempFileStore;
    private final FileAccessTracker fileAccessTracker;
    private final String failedFileSuffix;
    private final ReadWriteLock lock = new ReentrantReadWriteLock();

    public DirectoryBuildCacheService(PathKeyFileStore fileStore, PersistentCache persistentCache, BuildCacheTempFileStore tempFileStore, FileAccessTracker fileAccessTracker2, String failedFileSuffix) {
        this.fileStore = fileStore;
        this.persistentCache = persistentCache;
        this.tempFileStore = tempFileStore;
        this.fileAccessTracker = fileAccessTracker2;
        this.failedFileSuffix = failedFileSuffix;
    }

    @Override
    public boolean load(BuildCacheKey key, BuildCacheEntryReader reader) throws BuildCacheException {
        LoadAction loadAction = new LoadAction(reader);
        this.loadLocally(key, loadAction);
        return loadAction.loaded;
    }

    @Override
    public void loadLocally(final BuildCacheKey key, final Action<? super File> reader) {
        this.persistentCache.withFileLock(new Runnable(){

            @Override
            public void run() {
                DirectoryBuildCacheService.this.lock.readLock().lock();
                try {
                    DirectoryBuildCacheService.this.loadInsideLock(key, reader);
                }
                finally {
                    DirectoryBuildCacheService.this.lock.readLock().unlock();
                }
            }
        });
    }

    private void loadInsideLock(BuildCacheKey key, Action<? super File> reader) {
        LocallyAvailableResource resource = this.fileStore.get(key.getHashCode());
        if (resource == null) {
            return;
        }
        File file = resource.getFile();
        this.fileAccessTracker.markAccessed(file);
        try {
            reader.execute(file);
        }
        catch (Exception e) {
            File failedFile = new File(file.getAbsolutePath() + this.failedFileSuffix);
            GFileUtils.deleteQuietly(failedFile);
            file.renameTo(failedFile);
            throw UncheckedException.throwAsUncheckedException(e);
        }
    }

    @Override
    public void store(final BuildCacheKey key, final BuildCacheEntryWriter result) throws BuildCacheException {
        this.tempFileStore.withTempFile(key, (Action<? super File>)new Action<File>(){

            @Override
            public void execute(@Nonnull File file) {
                try (Closer closer = Closer.create();){
                    result.writeTo(closer.register(new FileOutputStream(file)));
                }
                catch (IOException ex) {
                    throw UncheckedException.throwAsUncheckedException(ex);
                }
                DirectoryBuildCacheService.this.storeLocally(key, file);
            }
        });
    }

    @Override
    public void storeLocally(final BuildCacheKey key, final File file) {
        this.persistentCache.withFileLock(new Runnable(){

            @Override
            public void run() {
                DirectoryBuildCacheService.this.lock.writeLock().lock();
                try {
                    DirectoryBuildCacheService.this.storeInsideLock(key, file);
                }
                finally {
                    DirectoryBuildCacheService.this.lock.writeLock().unlock();
                }
            }
        });
    }

    private void storeInsideLock(BuildCacheKey key, File file) {
        LocallyAvailableResource resource = this.fileStore.move(key.getHashCode(), file);
        this.fileAccessTracker.markAccessed(resource.getFile());
    }

    @Override
    public void withTempFile(final BuildCacheKey key, final Action<? super File> action) {
        this.persistentCache.withFileLock(new Runnable(){

            @Override
            public void run() {
                DirectoryBuildCacheService.this.tempFileStore.withTempFile(key, action);
            }
        });
    }

    @Override
    public void close() {
        this.persistentCache.close();
    }

    private static class LoadAction
    implements Action<File> {
        private final BuildCacheEntryReader reader;
        boolean loaded;

        private LoadAction(BuildCacheEntryReader reader) {
            this.reader = reader;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void execute(@Nonnull File file) {
            try {
                Closer closer = Closer.create();
                FileInputStream stream = closer.register(new FileInputStream(file));
                try {
                    this.reader.readFrom(stream);
                    this.loaded = true;
                }
                finally {
                    closer.close();
                }
            }
            catch (IOException ex) {
                throw new UncheckedIOException(ex);
            }
        }
    }
}

