/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.composite.internal;

import java.io.File;
import org.gradle.StartParameter;
import org.gradle.api.Transformer;
import org.gradle.api.artifacts.component.BuildIdentifier;
import org.gradle.api.internal.BuildDefinition;
import org.gradle.api.internal.GradleInternal;
import org.gradle.api.internal.SettingsInternal;
import org.gradle.api.internal.artifacts.DefaultBuildIdentifier;
import org.gradle.composite.internal.AbstractCompositeParticipantBuildState;
import org.gradle.initialization.GradleLauncher;
import org.gradle.initialization.GradleLauncherFactory;
import org.gradle.initialization.IncludedBuildSpec;
import org.gradle.initialization.NestedBuildFactory;
import org.gradle.initialization.RootBuildLifecycleListener;
import org.gradle.internal.build.RootBuildState;
import org.gradle.internal.buildtree.BuildTreeState;
import org.gradle.internal.concurrent.Stoppable;
import org.gradle.internal.event.ListenerManager;
import org.gradle.internal.invocation.BuildController;
import org.gradle.internal.invocation.GradleBuildController;
import org.gradle.util.Path;

class DefaultRootBuildState
extends AbstractCompositeParticipantBuildState
implements RootBuildState,
Stoppable {
    private final ListenerManager listenerManager;
    private final GradleLauncher gradleLauncher;

    DefaultRootBuildState(BuildDefinition buildDefinition, GradleLauncherFactory gradleLauncherFactory, ListenerManager listenerManager, BuildTreeState owner) {
        this.listenerManager = listenerManager;
        this.gradleLauncher = gradleLauncherFactory.newInstance(buildDefinition, this, owner);
    }

    @Override
    public BuildIdentifier getBuildIdentifier() {
        return DefaultBuildIdentifier.ROOT;
    }

    @Override
    public Path getIdentityPath() {
        return Path.ROOT;
    }

    @Override
    public boolean isImplicitBuild() {
        return false;
    }

    @Override
    public void assertCanAdd(IncludedBuildSpec includedBuildSpec) {
    }

    @Override
    public File getBuildRootDir() {
        return this.gradleLauncher.getBuildRootDir();
    }

    @Override
    public void stop() {
        this.gradleLauncher.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T run(Transformer<T, ? super BuildController> buildAction) {
        GradleBuildController buildController = new GradleBuildController(this.gradleLauncher);
        RootBuildLifecycleListener buildLifecycleListener = this.listenerManager.getBroadcaster(RootBuildLifecycleListener.class);
        GradleInternal gradle = buildController.getGradle();
        buildLifecycleListener.afterStart(gradle);
        try {
            T t = buildAction.transform(buildController);
            return t;
        }
        finally {
            buildLifecycleListener.beforeComplete(gradle);
        }
    }

    @Override
    public StartParameter getStartParameter() {
        return this.gradleLauncher.getGradle().getStartParameter();
    }

    @Override
    public SettingsInternal getLoadedSettings() {
        return this.gradleLauncher.getGradle().getSettings();
    }

    @Override
    public NestedBuildFactory getNestedBuildFactory() {
        return this.gradleLauncher.getGradle().getServices().get(NestedBuildFactory.class);
    }

    @Override
    public Path getCurrentPrefixForProjectsInChildBuilds() {
        return Path.ROOT;
    }

    @Override
    public Path getIdentityPathForProject(Path path) {
        return path;
    }

    @Override
    public GradleInternal getBuild() {
        return this.gradleLauncher.getGradle();
    }
}

