/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.composite.internal;

import org.gradle.api.artifacts.component.ComponentSelector;
import org.gradle.api.capabilities.Capability;
import org.gradle.api.internal.artifacts.ivyservice.dependencysubstitution.DefaultDependencySubstitutions;
import org.gradle.api.internal.artifacts.ivyservice.dependencysubstitution.DependencySubstitutionsInternal;
import org.gradle.api.internal.attributes.ImmutableAttributesFactory;
import org.gradle.api.internal.composite.CompositeBuildContext;
import org.gradle.api.model.ObjectFactory;
import org.gradle.internal.build.CompositeBuildParticipantBuildState;
import org.gradle.internal.build.IncludedBuildState;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.internal.typeconversion.NotationParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IncludedBuildDependencySubstitutionsBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(IncludedBuildDependencySubstitutionsBuilder.class);
    private final CompositeBuildContext context;
    private final Instantiator instantiator;
    private final ObjectFactory objectFactory;
    private final ImmutableAttributesFactory attributesFactory;
    private final NotationParser<Object, ComponentSelector> moduleSelectorNotationParser;
    private final NotationParser<Object, Capability> capabilitiesParser;

    public IncludedBuildDependencySubstitutionsBuilder(CompositeBuildContext context, Instantiator instantiator, ObjectFactory objectFactory, ImmutableAttributesFactory attributesFactory, NotationParser<Object, ComponentSelector> moduleSelectorNotationParser, NotationParser<Object, Capability> capabilitiesParser) {
        this.context = context;
        this.instantiator = instantiator;
        this.objectFactory = objectFactory;
        this.attributesFactory = attributesFactory;
        this.moduleSelectorNotationParser = moduleSelectorNotationParser;
        this.capabilitiesParser = capabilitiesParser;
    }

    public void build(IncludedBuildState build) {
        DependencySubstitutionsInternal substitutions = this.resolveDependencySubstitutions(build);
        if (!substitutions.rulesMayAddProjectDependency()) {
            LOGGER.info("[composite-build] Configuring build: " + build.getRootDirectory());
            this.context.addAvailableModules(build.getAvailableModules());
        } else {
            this.context.registerSubstitution(substitutions.getRuleAction());
        }
    }

    public void build(CompositeBuildParticipantBuildState rootBuildState) {
        this.context.addAvailableModules(rootBuildState.getAvailableModules());
    }

    private DependencySubstitutionsInternal resolveDependencySubstitutions(IncludedBuildState build) {
        DefaultDependencySubstitutions dependencySubstitutions = DefaultDependencySubstitutions.forIncludedBuild(build, this.instantiator, this.objectFactory, this.attributesFactory, this.moduleSelectorNotationParser, this.capabilitiesParser);
        build.getRegisteredDependencySubstitutions().execute(dependencySubstitutions);
        return dependencySubstitutions;
    }
}

