/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.execution.plan;

import java.io.File;
import java.io.StringWriter;
import java.util.AbstractCollection;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.gradle.api.BuildCancelledException;
import org.gradle.api.CircularReferenceException;
import org.gradle.api.GradleException;
import org.gradle.api.NonNullApi;
import org.gradle.api.Task;
import org.gradle.api.internal.GradleInternal;
import org.gradle.api.specs.Spec;
import org.gradle.api.specs.Specs;
import org.gradle.execution.plan.ExecutionPlan;
import org.gradle.execution.plan.FailureCollector;
import org.gradle.execution.plan.LocalTaskNode;
import org.gradle.execution.plan.MutationInfo;
import org.gradle.execution.plan.Node;
import org.gradle.execution.plan.TaskDependencyResolver;
import org.gradle.execution.plan.TaskInAnotherBuild;
import org.gradle.execution.plan.TaskNode;
import org.gradle.execution.plan.TaskNodeFactory;
import org.gradle.internal.Pair;
import org.gradle.internal.graph.CachingDirectedGraphWalker;
import org.gradle.internal.graph.DirectedGraphRenderer;
import org.gradle.internal.impldep.com.google.common.base.Function;
import org.gradle.internal.impldep.com.google.common.collect.HashMultimap;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableList;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableSet;
import org.gradle.internal.impldep.com.google.common.collect.Iterables;
import org.gradle.internal.impldep.com.google.common.collect.Lists;
import org.gradle.internal.impldep.com.google.common.collect.Maps;
import org.gradle.internal.impldep.com.google.common.collect.Sets;
import org.gradle.internal.logging.text.StyledTextOutput;
import org.gradle.internal.resources.ResourceLock;
import org.gradle.internal.resources.ResourceLockState;
import org.gradle.internal.work.WorkerLeaseRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonNullApi
public class DefaultExecutionPlan
implements ExecutionPlan {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultExecutionPlan.class);
    private final Set<Node> entryNodes = new LinkedHashSet<Node>();
    private final NodeMapping nodeMapping = new NodeMapping();
    private final List<Node> executionQueue = new LinkedList<Node>();
    private final Set<ResourceLock> projectLocks = new HashSet<ResourceLock>();
    private final FailureCollector failureCollector = new FailureCollector();
    private final TaskNodeFactory taskNodeFactory;
    private final TaskDependencyResolver dependencyResolver;
    private Spec<? super Task> filter = Specs.satisfyAll();
    private boolean continueOnFailure;
    private final Set<Node> runningNodes = Sets.newIdentityHashSet();
    private final Set<Node> filteredNodes = Sets.newIdentityHashSet();
    private final Set<Node> producedButNotYetConsumed = Sets.newIdentityHashSet();
    private final Map<Pair<Node, Node>, Boolean> reachableCache = new HashMap<Pair<Node, Node>, Boolean>();
    private final List<Node> dependenciesWhichRequireMonitoring = new ArrayList<Node>();
    private boolean maybeNodesReady;
    private final GradleInternal gradle;
    private boolean buildCancelled;

    public DefaultExecutionPlan(GradleInternal gradle, TaskNodeFactory taskNodeFactory, TaskDependencyResolver dependencyResolver) {
        this.gradle = gradle;
        this.taskNodeFactory = taskNodeFactory;
        this.dependencyResolver = dependencyResolver;
    }

    @Override
    public String getDisplayName() {
        return this.gradle.getIdentityPath().toString();
    }

    @Override
    public TaskNode getNode(Task task) {
        return this.nodeMapping.get(task);
    }

    public void addNodes(Collection<? extends Node> nodes) {
        ArrayDeque<Node> queue = new ArrayDeque<Node>(nodes);
        for (Node node : nodes) {
            assert (node.getDependenciesProcessed() || node instanceof TaskInAnotherBuild);
            assert (node.isInKnownState());
            if (!node.isRequired()) continue;
            this.entryNodes.add(node);
        }
        this.doAddNodes(queue);
    }

    public void addEntryTasks(Collection<? extends Task> tasks) {
        ArrayDeque<Node> queue = new ArrayDeque<Node>();
        for (Task task : this.sorted(tasks)) {
            TaskNode node = this.taskNodeFactory.getOrCreateNode(task);
            if (node.isMustNotRun()) {
                this.requireWithDependencies(node);
            } else if (this.filter.isSatisfiedBy(task)) {
                node.require();
            }
            this.entryNodes.add(node);
            queue.add(node);
        }
        this.doAddNodes(queue);
    }

    private List<Task> sorted(Collection<? extends Task> tasks) {
        ArrayList<Task> sortedTasks = new ArrayList<Task>(tasks);
        Collections.sort(sortedTasks);
        return sortedTasks;
    }

    private void doAddNodes(Deque<Node> queue) {
        LinkedHashSet<Node> nodesInUnknownState = Sets.newLinkedHashSet();
        HashSet<Node> visiting = new HashSet<Node>();
        while (!queue.isEmpty()) {
            boolean filtered;
            Node node = queue.getFirst();
            if (node.getDependenciesProcessed()) {
                queue.removeFirst();
                continue;
            }
            boolean bl = filtered = !this.nodeSatisfiesTaskFilter(node);
            if (filtered) {
                queue.removeFirst();
                node.dependenciesProcessed();
                node.doNotRequire();
                this.filteredNodes.add(node);
                continue;
            }
            if (visiting.add(node)) {
                node.prepareForExecution();
                node.resolveDependencies(this.dependencyResolver, targetNode -> {
                    if (!visiting.contains(targetNode)) {
                        queue.addFirst((Node)targetNode);
                    }
                });
                if (node.isRequired()) {
                    for (Node successor : node.getDependencySuccessors()) {
                        if (!this.nodeSatisfiesTaskFilter(successor)) continue;
                        successor.require();
                    }
                    continue;
                }
                nodesInUnknownState.add(node);
                continue;
            }
            queue.removeFirst();
            visiting.remove(node);
            node.dependenciesProcessed();
        }
        this.resolveNodesInUnknownState(nodesInUnknownState);
    }

    private boolean nodeSatisfiesTaskFilter(Node successor) {
        if (successor instanceof LocalTaskNode) {
            return this.filter.isSatisfiedBy(((LocalTaskNode)successor).getTask());
        }
        return true;
    }

    private void resolveNodesInUnknownState(Set<Node> nodesInUnknownState) {
        ArrayDeque<Node> queue = new ArrayDeque<Node>(nodesInUnknownState);
        HashSet<Node> visiting = new HashSet<Node>();
        block0: while (!queue.isEmpty()) {
            Node node = (Node)queue.peekFirst();
            if (node.isInKnownState()) {
                queue.removeFirst();
                continue;
            }
            if (visiting.add(node)) {
                for (Node hardPredecessor : node.getDependencyPredecessors()) {
                    if (visiting.contains(hardPredecessor)) continue;
                    queue.addFirst(hardPredecessor);
                }
                continue;
            }
            queue.removeFirst();
            visiting.remove(node);
            node.mustNotRun();
            for (Node predecessor : node.getDependencyPredecessors()) {
                assert (predecessor.isRequired() || predecessor.isMustNotRun());
                if (!predecessor.isRequired()) continue;
                node.require();
                continue block0;
            }
        }
    }

    private void requireWithDependencies(Node node) {
        if (node.isMustNotRun() && this.nodeSatisfiesTaskFilter(node)) {
            node.require();
            for (Node dependency : node.getDependencySuccessors()) {
                this.requireWithDependencies(dependency);
            }
        }
    }

    public void determineExecutionPlan() {
        LinkedList<NodeInVisitingSegment> nodeQueue = Lists.newLinkedList(Iterables.transform(this.entryNodes, new Function<Node, NodeInVisitingSegment>(){
            private int index;

            @Override
            public NodeInVisitingSegment apply(Node node) {
                return new NodeInVisitingSegment(node, this.index++);
            }
        }));
        int visitingSegmentCounter = nodeQueue.size();
        HashSet<Node> dependenciesWhichRequireMonitoring = new HashSet<Node>();
        HashMultimap<Node, Integer> visitingNodes = HashMultimap.create();
        ArrayDeque<GraphEdge> walkedShouldRunAfterEdges = new ArrayDeque<GraphEdge>();
        ArrayDeque<Node> path = new ArrayDeque<Node>();
        HashMap<Node, Integer> planBeforeVisiting = new HashMap<Node, Integer>();
        while (!nodeQueue.isEmpty()) {
            NodeInVisitingSegment nodeInVisitingSegment = nodeQueue.peekFirst();
            int currentSegment = nodeInVisitingSegment.visitingSegment;
            Node node = nodeInVisitingSegment.node;
            if (!node.isIncludeInGraph() || this.nodeMapping.contains(node)) {
                nodeQueue.removeFirst();
                visitingNodes.remove(node, currentSegment);
                this.maybeRemoveProcessedShouldRunAfterEdge(walkedShouldRunAfterEdges, node);
                if (!node.requiresMonitoring()) continue;
                dependenciesWhichRequireMonitoring.add(node);
                continue;
            }
            boolean alreadyVisited = visitingNodes.containsKey(node);
            visitingNodes.put((Object)node, (Object)currentSegment);
            if (!alreadyVisited) {
                this.recordEdgeIfArrivedViaShouldRunAfter(walkedShouldRunAfterEdges, path, node);
                this.removeShouldRunAfterSuccessorsIfTheyImposeACycle(visitingNodes, nodeInVisitingSegment);
                this.takePlanSnapshotIfCanBeRestoredToCurrentTask(planBeforeVisiting, node);
                for (Node successor : node.getAllSuccessorsInReverseOrder()) {
                    if (visitingNodes.containsEntry(successor, currentSegment)) {
                        if (!walkedShouldRunAfterEdges.isEmpty()) {
                            GraphEdge toBeRemoved = (GraphEdge)walkedShouldRunAfterEdges.pop();
                            TaskNode sourceTask = (TaskNode)toBeRemoved.from;
                            TaskNode targetTask = (TaskNode)toBeRemoved.to;
                            sourceTask.removeShouldSuccessor(targetTask);
                            this.restorePath(path, toBeRemoved);
                            this.restoreQueue(nodeQueue, visitingNodes, toBeRemoved);
                            this.restoreExecutionPlan(planBeforeVisiting, toBeRemoved);
                            break;
                        }
                        this.onOrderingCycle(successor, node);
                    }
                    nodeQueue.addFirst(new NodeInVisitingSegment(successor, currentSegment));
                }
                path.push(node);
                continue;
            }
            nodeQueue.removeFirst();
            this.maybeRemoveProcessedShouldRunAfterEdge(walkedShouldRunAfterEdges, node);
            visitingNodes.remove(node, currentSegment);
            path.pop();
            this.nodeMapping.add(node);
            if (node.requiresMonitoring()) {
                dependenciesWhichRequireMonitoring.add(node);
            }
            for (Node dependency : node.getDependencySuccessors()) {
                dependency.getMutationInfo().consumingNodes.add(node);
            }
            ResourceLock projectLock = node.getProjectToLock();
            if (projectLock != null) {
                this.projectLocks.add(projectLock);
            }
            for (Node finalizer : node.getFinalizers()) {
                if (visitingNodes.containsKey(finalizer)) continue;
                int position = this.finalizerTaskPosition(finalizer, nodeQueue);
                nodeQueue.add(position, new NodeInVisitingSegment(finalizer, visitingSegmentCounter++));
            }
        }
        this.executionQueue.clear();
        this.dependencyResolver.clear();
        this.nodeMapping.removeIf(Node::requiresMonitoring);
        this.executionQueue.addAll(this.nodeMapping);
        for (Node node : this.executionQueue) {
            this.maybeNodesReady |= node.updateAllDependenciesComplete() && node.isReady();
        }
        this.dependenciesWhichRequireMonitoring.addAll(dependenciesWhichRequireMonitoring);
    }

    private void maybeRemoveProcessedShouldRunAfterEdge(Deque<GraphEdge> walkedShouldRunAfterEdges, Node node) {
        GraphEdge edge = walkedShouldRunAfterEdges.peek();
        if (edge != null && edge.to.equals(node)) {
            walkedShouldRunAfterEdges.pop();
        }
    }

    private void restoreExecutionPlan(Map<Node, Integer> planBeforeVisiting, GraphEdge toBeRemoved) {
        int count = planBeforeVisiting.get(toBeRemoved.from);
        this.nodeMapping.retainFirst(count);
    }

    private void restoreQueue(Deque<NodeInVisitingSegment> nodeQueue, HashMultimap<Node, Integer> visitingNodes, GraphEdge toBeRemoved) {
        NodeInVisitingSegment nextInQueue = null;
        while (nextInQueue == null || !toBeRemoved.from.equals(nextInQueue.node)) {
            nextInQueue = nodeQueue.peekFirst();
            visitingNodes.remove(nextInQueue.node, nextInQueue.visitingSegment);
            if (toBeRemoved.from.equals(nextInQueue.node)) continue;
            nodeQueue.removeFirst();
        }
    }

    private void restorePath(Deque<Node> path, GraphEdge toBeRemoved) {
        Node removedFromPath = null;
        while (!toBeRemoved.from.equals(removedFromPath)) {
            removedFromPath = path.pop();
        }
    }

    private void removeShouldRunAfterSuccessorsIfTheyImposeACycle(HashMultimap<Node, Integer> visitingNodes, NodeInVisitingSegment nodeWithVisitingSegment) {
        Node node = nodeWithVisitingSegment.node;
        if (!(node instanceof TaskNode)) {
            return;
        }
        Iterables.removeIf(((TaskNode)node).getShouldSuccessors(), input -> visitingNodes.containsEntry(input, nodeWithVisitingSegment.visitingSegment));
    }

    private void takePlanSnapshotIfCanBeRestoredToCurrentTask(Map<Node, Integer> planBeforeVisiting, Node node) {
        if (node instanceof TaskNode && !((TaskNode)node).getShouldSuccessors().isEmpty()) {
            planBeforeVisiting.put(node, this.nodeMapping.size());
        }
    }

    private void recordEdgeIfArrivedViaShouldRunAfter(Deque<GraphEdge> walkedShouldRunAfterEdges, Deque<Node> path, Node node) {
        if (!(node instanceof TaskNode)) {
            return;
        }
        Node previous = path.peek();
        if (previous instanceof TaskNode && ((TaskNode)previous).getShouldSuccessors().contains(node)) {
            walkedShouldRunAfterEdges.push(new GraphEdge(previous, node));
        }
    }

    private int finalizerTaskPosition(Node finalizer, Deque<NodeInVisitingSegment> nodeQueue) {
        if (nodeQueue.size() == 0) {
            return 0;
        }
        Set<Node> precedingTasks = this.getAllPrecedingNodes(finalizer);
        int maxPrecedingTaskIndex = precedingTasks.stream().mapToInt(dependsOnTask -> Iterables.indexOf(nodeQueue, nodeInVisitingSegment -> ((NodeInVisitingSegment)nodeInVisitingSegment).node.equals(dependsOnTask))).max().orElseThrow(IllegalStateException::new);
        return maxPrecedingTaskIndex + 1;
    }

    private Set<Node> getAllPrecedingNodes(Node finalizer) {
        HashSet<Node> precedingNodes = new HashSet<Node>();
        ArrayDeque<Node> candidateNodes = new ArrayDeque<Node>();
        Iterables.addAll(candidateNodes, finalizer.getAllSuccessors());
        while (!candidateNodes.isEmpty()) {
            Node precedingNode = (Node)candidateNodes.pop();
            if (!precedingNodes.add(precedingNode) || !(precedingNode instanceof TaskNode)) continue;
            candidateNodes.addAll(((TaskNode)precedingNode).getMustSuccessors());
            candidateNodes.addAll(((TaskNode)precedingNode).getFinalizingSuccessors());
        }
        return precedingNodes;
    }

    private void onOrderingCycle(Node successor, Node currentNode) {
        CachingDirectedGraphWalker graphWalker = new CachingDirectedGraphWalker((node, values, connectedNodes) -> {
            connectedNodes.addAll(node.getDependencySuccessors());
            if (node instanceof TaskNode) {
                TaskNode taskNode = (TaskNode)node;
                connectedNodes.addAll(taskNode.getMustSuccessors());
                connectedNodes.addAll(taskNode.getFinalizingSuccessors());
            }
        });
        graphWalker.add((Node[])new Node[]{successor});
        List<Set<Node>> cycles = graphWalker.findCycles();
        if (cycles.isEmpty()) {
            throw new GradleException("Misdetected cycle between " + currentNode + " and " + successor + ". Help us by reporting this to https://github.com/gradle/gradle/issues/2293");
        }
        ArrayList firstCycle = new ArrayList(cycles.get(0));
        Collections.sort(firstCycle);
        DirectedGraphRenderer<Node> graphRenderer = new DirectedGraphRenderer<Node>((it, output) -> output.withStyle(StyledTextOutput.Style.Identifier).text(it), (it, values, connectedNodes) -> {
            for (Node dependency : firstCycle) {
                if (!it.hasHardSuccessor(dependency)) continue;
                connectedNodes.add(dependency);
            }
        });
        StringWriter writer = new StringWriter();
        graphRenderer.renderTo((Node)firstCycle.get(0), writer);
        throw new CircularReferenceException(String.format("Circular dependency between the following tasks:%n%s", writer.toString()));
    }

    public void clear() {
        this.taskNodeFactory.clear();
        this.dependencyResolver.clear();
        this.entryNodes.clear();
        this.nodeMapping.clear();
        this.executionQueue.clear();
        this.projectLocks.clear();
        this.failureCollector.clearFailures();
        this.producedButNotYetConsumed.clear();
        this.reachableCache.clear();
        this.dependenciesWhichRequireMonitoring.clear();
        this.runningNodes.clear();
    }

    @Override
    public Set<Task> getTasks() {
        return this.nodeMapping.getTasks();
    }

    public List<Node> getScheduledNodes() {
        return ImmutableList.copyOf(this.nodeMapping.nodes);
    }

    public List<Node> getScheduledNodesPlusDependencies() {
        Set nodes = this.nodeMapping.nodes;
        ImmutableList.Builder builder = ImmutableList.builder();
        for (Node node : this.dependenciesWhichRequireMonitoring) {
            if (nodes.contains(node)) continue;
            builder.add(node);
        }
        return ((ImmutableList.Builder)builder.addAll((Iterable)nodes)).build();
    }

    @Override
    public Set<Task> getFilteredTasks() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (Node filteredNode : this.filteredNodes) {
            if (!(filteredNode instanceof LocalTaskNode)) continue;
            builder.add(((LocalTaskNode)filteredNode).getTask());
        }
        return builder.build();
    }

    public void useFilter(Spec<? super Task> filter) {
        this.filter = filter;
    }

    public void setContinueOnFailure(boolean continueOnFailure) {
        this.continueOnFailure = continueOnFailure;
    }

    @Override
    @Nullable
    public Node selectNext(WorkerLeaseRegistry.WorkerLease workerLease, ResourceLockState resourceLockState) {
        if (this.allProjectsLocked()) {
            return null;
        }
        Iterator<Node> iterator = this.dependenciesWhichRequireMonitoring.iterator();
        while (iterator.hasNext()) {
            Node node = iterator.next();
            if (!node.isComplete()) continue;
            LOGGER.debug("Monitored node {} completed", (Object)node);
            this.updateAllDependenciesCompleteForPredecessors(node);
            iterator.remove();
        }
        if (!this.maybeNodesReady) {
            return null;
        }
        iterator = this.executionQueue.iterator();
        boolean foundReadyNode = false;
        while (iterator.hasNext()) {
            Node node = iterator.next();
            if (!node.isReady() || !node.allDependenciesComplete()) continue;
            foundReadyNode = true;
            MutationInfo mutations = this.getResolvedMutationInfo(node);
            if (!this.tryAcquireLocksForNode(node, workerLease, mutations)) {
                resourceLockState.releaseLocks();
                continue;
            }
            if (node.allDependenciesSuccessful()) {
                node.startExecution(this::recordNodeExecutionStarted);
            } else {
                node.skipExecution(this::recordNodeCompleted);
            }
            iterator.remove();
            return node;
        }
        LOGGER.debug("No node could be selected, nodes ready: {}", (Object)foundReadyNode);
        this.maybeNodesReady = foundReadyNode;
        return null;
    }

    private boolean tryAcquireLocksForNode(Node node, WorkerLeaseRegistry.WorkerLease workerLease, MutationInfo mutations) {
        if (!this.tryLockProjectFor(node)) {
            LOGGER.debug("Cannot acquire project lock for node {}", (Object)node);
            return false;
        }
        if (!this.tryLockSharedResourceFor(node)) {
            LOGGER.debug("Cannot acquire shared resource lock for node {}", (Object)node);
            return false;
        }
        if (!workerLease.tryLock()) {
            LOGGER.debug("Cannot acquire worker lease lock for node {}", (Object)node);
            return false;
        }
        if (!this.canRunWithCurrentlyExecutedNodes(node, mutations)) {
            LOGGER.debug("Node {} cannot run with currently running nodes {}", (Object)node, (Object)this.runningNodes);
            return false;
        }
        return true;
    }

    private void updateAllDependenciesCompleteForPredecessors(Node node) {
        for (Node predecessor : node.getAllPredecessors()) {
            this.maybeNodesReady |= predecessor.updateAllDependenciesComplete() && predecessor.isReady();
        }
    }

    private boolean tryLockProjectFor(Node node) {
        ResourceLock toLock = node.getProjectToLock();
        if (toLock != null) {
            return toLock.tryLock();
        }
        return true;
    }

    private void unlockProjectFor(Node node) {
        ResourceLock toUnlock = node.getProjectToLock();
        if (toUnlock != null) {
            toUnlock.unlock();
        }
    }

    private boolean tryLockSharedResourceFor(Node node) {
        return node.getResourcesToLock().stream().allMatch(ResourceLock::tryLock);
    }

    private void unlockSharedResourcesFor(Node node) {
        node.getResourcesToLock().forEach(ResourceLock::unlock);
    }

    private MutationInfo getResolvedMutationInfo(Node node) {
        MutationInfo mutations = node.getMutationInfo();
        if (!mutations.resolved) {
            node.resolveMutations();
        }
        return mutations;
    }

    private boolean allProjectsLocked() {
        for (ResourceLock lock : this.projectLocks) {
            if (lock.isLocked()) continue;
            return false;
        }
        return !this.projectLocks.isEmpty();
    }

    private boolean canRunWithCurrentlyExecutedNodes(Node node, MutationInfo mutations) {
        Set<String> candidateNodeDestroyables = mutations.destroyablePaths;
        if (!this.runningNodes.isEmpty()) {
            Set<String> candidateMutations;
            Set<String> candidateNodeOutputs = mutations.outputPaths;
            Set<String> set2 = candidateMutations = !candidateNodeOutputs.isEmpty() ? candidateNodeOutputs : candidateNodeDestroyables;
            if (this.hasNodeWithOverlappingMutations(candidateMutations)) {
                return false;
            }
        }
        return !this.doesDestroyNotYetConsumedOutputOfAnotherNode(node, candidateNodeDestroyables);
    }

    private boolean hasNodeWithOverlappingMutations(Set<String> candidateMutationPaths) {
        if (!candidateMutationPaths.isEmpty()) {
            for (Node runningNode : this.runningNodes) {
                MutationInfo runningMutations = runningNode.getMutationInfo();
                Iterable<String> runningMutationPaths = Iterables.concat(runningMutations.outputPaths, runningMutations.destroyablePaths);
                if (!DefaultExecutionPlan.hasOverlap(candidateMutationPaths, runningMutationPaths)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean doesDestroyNotYetConsumedOutputOfAnotherNode(Node destroyer, Set<String> destroyablePaths) {
        if (!destroyablePaths.isEmpty()) {
            for (Node producingNode : this.producedButNotYetConsumed) {
                MutationInfo producingNodeMutations = producingNode.getMutationInfo();
                assert (!producingNodeMutations.consumingNodes.isEmpty());
                if (!DefaultExecutionPlan.hasOverlap(destroyablePaths, producingNodeMutations.outputPaths)) continue;
                for (Node consumer : producingNodeMutations.consumingNodes) {
                    if (this.doesConsumerDependOnDestroyer(consumer, destroyer)) continue;
                    LOGGER.debug("Node {} destroys output of consumer {}", (Object)destroyer, (Object)consumer);
                    return true;
                }
            }
        }
        return false;
    }

    private boolean doesConsumerDependOnDestroyer(Node consumer, Node destroyer) {
        if (consumer == destroyer) {
            return true;
        }
        Pair<Node, Node> nodePair = Pair.of(consumer, destroyer);
        if (this.reachableCache.get(nodePair) != null) {
            return this.reachableCache.get(nodePair);
        }
        boolean reachable = false;
        for (Node dependency : consumer.getAllSuccessors()) {
            if (dependency.isComplete() || !this.doesConsumerDependOnDestroyer(dependency, destroyer)) continue;
            reachable = true;
        }
        this.reachableCache.put(nodePair, reachable);
        return reachable;
    }

    private static boolean hasOverlap(Iterable<String> paths1, Iterable<String> paths2) {
        for (String path1 : paths1) {
            for (String path2 : paths2) {
                String overLappedPath = DefaultExecutionPlan.getOverLappedPath(path1, path2);
                if (overLappedPath == null) continue;
                return true;
            }
        }
        return false;
    }

    @Nullable
    private static String getOverLappedPath(String firstPath, String secondPath) {
        boolean isOverlapping;
        String longer;
        String shorter;
        if (firstPath.equals(secondPath)) {
            return firstPath;
        }
        if (firstPath.length() == secondPath.length()) {
            return null;
        }
        if (firstPath.length() > secondPath.length()) {
            shorter = secondPath;
            longer = firstPath;
        } else {
            shorter = firstPath;
            longer = secondPath;
        }
        boolean bl = isOverlapping = longer.startsWith(shorter) && longer.charAt(shorter.length()) == File.separatorChar;
        if (isOverlapping) {
            return shorter;
        }
        return null;
    }

    private void recordNodeExecutionStarted(Node node) {
        this.runningNodes.add(node);
    }

    private void recordNodeCompleted(Node node) {
        LOGGER.debug("Node {} completed, executed: {}", (Object)node, (Object)node.isExecuted());
        MutationInfo mutations = node.getMutationInfo();
        for (Node producer : node.getDependencySuccessors()) {
            MutationInfo producerMutations = producer.getMutationInfo();
            if (!producerMutations.consumingNodes.remove(node) || !producerMutations.consumingNodes.isEmpty()) continue;
            this.producedButNotYetConsumed.remove(producer);
        }
        if (!mutations.consumingNodes.isEmpty() && !mutations.outputPaths.isEmpty()) {
            this.producedButNotYetConsumed.add(node);
        }
        this.updateAllDependenciesCompleteForPredecessors(node);
    }

    @Override
    public void finishedExecuting(Node node) {
        try {
            if (!node.isComplete()) {
                DefaultExecutionPlan.enforceFinalizers(node);
                this.maybeNodesReady = true;
                if (node.isFailed()) {
                    LOGGER.debug("Node {} failed", (Object)node);
                    this.handleFailure(node);
                } else {
                    LOGGER.debug("Node {} finished executing", (Object)node);
                }
                this.runningNodes.remove(node);
                node.finishExecution(this::recordNodeCompleted);
            } else {
                LOGGER.debug("Already completed node {} reported as finished executing", (Object)node);
            }
        }
        finally {
            this.unlockProjectFor(node);
            this.unlockSharedResourcesFor(node);
        }
    }

    private static void enforceFinalizers(Node node) {
        for (Node finalizerNode : node.getFinalizers()) {
            if (!finalizerNode.isRequired() && !finalizerNode.isMustNotRun()) continue;
            DefaultExecutionPlan.enforceWithDependencies(finalizerNode);
        }
    }

    private static void enforceWithDependencies(Node node) {
        HashSet<Node> enforcedNodes = new HashSet<Node>();
        ArrayDeque<Node> candidates = new ArrayDeque<Node>();
        candidates.add(node);
        while (!candidates.isEmpty()) {
            Node candidate = (Node)candidates.pop();
            if (enforcedNodes.contains(candidate)) continue;
            enforcedNodes.add(candidate);
            candidates.addAll(candidate.getDependencySuccessors());
            if (!candidate.isMustNotRun() && !candidate.isRequired()) continue;
            candidate.enforceRun();
            for (Node predecessor : candidate.getAllPredecessors()) {
                predecessor.forceAllDependenciesCompleteUpdate();
            }
        }
    }

    @Override
    public void abortAllAndFail(Throwable t) {
        this.abortExecution(true);
        this.failureCollector.addFailure(t);
    }

    private void handleFailure(Node node) {
        Throwable executionFailure = node.getExecutionFailure();
        if (executionFailure != null) {
            this.abortExecution();
            this.failureCollector.addFailure(executionFailure);
            return;
        }
        try {
            if (!this.continueOnFailure) {
                node.rethrowNodeFailure();
            }
            this.failureCollector.addFailure(node.getNodeFailure());
        }
        catch (Exception e) {
            this.abortExecution();
            this.failureCollector.addFailure(e);
        }
    }

    private boolean abortExecution() {
        return this.abortExecution(false);
    }

    @Override
    public void cancelExecution() {
        this.buildCancelled = this.abortExecution() || this.buildCancelled;
    }

    private boolean abortExecution(boolean abortAll) {
        boolean aborted = false;
        for (Node node : this.nodeMapping) {
            if (node.isRequired()) {
                node.skipExecution(this::recordNodeCompleted);
                aborted = true;
            }
            if (!abortAll || !node.isReady()) continue;
            node.abortExecution(this::recordNodeCompleted);
            aborted = true;
        }
        return aborted;
    }

    @Override
    public void collectFailures(Collection<? super Throwable> failures) {
        List<Throwable> collectedFailures = this.failureCollector.getFailures();
        failures.addAll(collectedFailures);
        if (this.buildCancelled && collectedFailures.isEmpty()) {
            failures.add(new BuildCancelledException());
        }
    }

    @Override
    public boolean allNodesComplete() {
        for (Node node : this.nodeMapping) {
            if (node.isComplete()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean hasNodesRemaining() {
        for (Node node : this.executionQueue) {
            if (node.isComplete()) continue;
            return true;
        }
        return !this.runningNodes.isEmpty();
    }

    @Override
    public int size() {
        return this.nodeMapping.getNumberOfPublicNodes();
    }

    private static class NodeMapping
    extends AbstractCollection<Node> {
        private final Map<Task, LocalTaskNode> taskMapping = Maps.newLinkedHashMap();
        private final Set<Node> nodes = Sets.newLinkedHashSet();

        private NodeMapping() {
        }

        @Override
        public boolean contains(Object o) {
            return this.nodes.contains(o);
        }

        @Override
        public boolean add(Node node) {
            if (!this.nodes.add(node)) {
                return false;
            }
            if (node instanceof LocalTaskNode) {
                LocalTaskNode taskNode = (LocalTaskNode)node;
                this.taskMapping.put(taskNode.getTask(), taskNode);
            }
            return true;
        }

        public TaskNode get(Task task) {
            TaskNode taskNode = this.taskMapping.get(task);
            if (taskNode == null) {
                throw new IllegalStateException("Task is not part of the execution plan, no dependency information is available.");
            }
            return taskNode;
        }

        public Set<Task> getTasks() {
            return this.taskMapping.keySet();
        }

        @Override
        public Iterator<Node> iterator() {
            return this.nodes.iterator();
        }

        @Override
        public void clear() {
            this.nodes.clear();
            this.taskMapping.clear();
        }

        @Override
        public int size() {
            return this.nodes.size();
        }

        public int getNumberOfPublicNodes() {
            int publicNodes = 0;
            for (Node node : this) {
                if (!node.isPublicNode()) continue;
                ++publicNodes;
            }
            return publicNodes;
        }

        public void retainFirst(int count) {
            Iterator<Node> executionPlanIterator = this.nodes.iterator();
            for (int i = 0; i < count; ++i) {
                executionPlanIterator.next();
            }
            while (executionPlanIterator.hasNext()) {
                Node removedNode = executionPlanIterator.next();
                executionPlanIterator.remove();
                if (!(removedNode instanceof LocalTaskNode)) continue;
                this.taskMapping.remove(((LocalTaskNode)removedNode).getTask());
            }
        }
    }

    private static class NodeInVisitingSegment {
        private final Node node;
        private final int visitingSegment;

        private NodeInVisitingSegment(Node node, int visitingSegment) {
            this.node = node;
            this.visitingSegment = visitingSegment;
        }
    }

    private static class GraphEdge {
        private final Node from;
        private final Node to;

        private GraphEdge(Node from, Node to) {
            this.from = from;
            this.to = to;
        }
    }
}

