/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.ide.visualstudio.tasks.internal;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import org.gradle.api.Transformer;
import org.gradle.internal.impldep.com.google.common.base.Joiner;

public class RelativeFileNameTransformer
implements Transformer<String, File> {
    private final File rootDir;
    private final File currentDir;

    private RelativeFileNameTransformer(File rootDir, File currentDir) {
        this.rootDir = rootDir;
        this.currentDir = currentDir;
    }

    public static Transformer<String, File> forFile(File rootDir, File relativeFile) {
        return new RelativeFileNameTransformer(rootDir, relativeFile.getParentFile());
    }

    public static Transformer<String, File> forDirectory(File rootDir, File currentDirectory) {
        return new RelativeFileNameTransformer(rootDir, currentDirectory);
    }

    public static Transformer<String, File> from(File file) {
        if (file.isFile()) {
            File parentFile = file.getParentFile();
            return new RelativeFileNameTransformer(parentFile, parentFile);
        }
        return new RelativeFileNameTransformer(file, file);
    }

    @Override
    public String transform(File file) {
        String canonicalTo;
        String canonicalFrom;
        String canonicalRoot;
        try {
            canonicalRoot = this.rootDir.getCanonicalPath();
            canonicalFrom = this.currentDir.getCanonicalPath();
            canonicalTo = file.getCanonicalPath();
        }
        catch (IOException e) {
            return file.getAbsolutePath();
        }
        return this.findRelativePathInRoot(canonicalRoot, canonicalFrom, canonicalTo);
    }

    private String findRelativePathInRoot(String root, String from, String to) {
        if (!from.contains(root) || !to.contains(root)) {
            return to;
        }
        String relativePath = this.findRelativePath(from, to);
        return relativePath.length() == 0 ? "." : relativePath;
    }

    private String findRelativePath(String from, String to) {
        LinkedList<String> fromPath = this.splitPath(from);
        LinkedList<String> toPath = this.splitPath(to);
        ArrayList<String> relativePath = new ArrayList<String>();
        while (!fromPath.isEmpty() && !toPath.isEmpty() && fromPath.get(0).equals(toPath.get(0))) {
            fromPath.removeFirst();
            toPath.removeFirst();
        }
        for (String ignored : fromPath) {
            relativePath.add("..");
        }
        relativePath.addAll(toPath);
        return Joiner.on(File.separatorChar).join(relativePath);
    }

    private LinkedList<String> splitPath(String path) {
        LinkedList<String> split = new LinkedList<String>();
        for (File pathFile = new File(path); pathFile != null; pathFile = pathFile.getParentFile()) {
            split.add(0, pathFile.getName());
        }
        return split;
    }
}

