/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.ide.xcode.internal.xcodeproj;

import java.util.List;
import javax.annotation.concurrent.NotThreadSafe;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.ide.xcode.internal.xcodeproj.GidGenerator;
import org.gradle.ide.xcode.internal.xcodeproj.PBXObject;
import org.gradle.ide.xcode.internal.xcodeproj.PBXProject;
import org.gradle.internal.impldep.com.dd.plist.NSArray;
import org.gradle.internal.impldep.com.dd.plist.NSDictionary;
import org.gradle.internal.impldep.com.dd.plist.NSObject;
import org.gradle.internal.impldep.com.dd.plist.NSString;

@NotThreadSafe
public class XcodeprojSerializer {
    private static final Logger LOG = Logging.getLogger(XcodeprojSerializer.class);
    private final PBXProject rootObject;
    private final NSDictionary objects;
    private final GidGenerator gidGenerator;
    private NSDictionary currentObject;

    public XcodeprojSerializer(GidGenerator gidGenerator, PBXProject project) {
        this.rootObject = project;
        this.objects = new NSDictionary();
        this.gidGenerator = gidGenerator;
    }

    public NSDictionary toPlist() {
        this.serializeObject(this.rootObject);
        NSDictionary root = new NSDictionary();
        root.put("archiveVersion", (Object)"1");
        root.put("classes", new NSDictionary());
        root.put("objectVersion", (Object)"46");
        root.put("objects", this.objects);
        root.put("rootObject", (Object)this.rootObject.getGlobalID());
        return root;
    }

    private String serializeObject(PBXObject obj) {
        if (obj.getGlobalID() == null) {
            obj.setGlobalID(obj.generateGid(this.gidGenerator));
            LOG.trace("Set new object GID: {}", (Object)obj);
        } else {
            NSObject object = this.objects.get(obj.getGlobalID());
            if (object != null) {
                LOG.trace("Object {} found, returning existing object {}", (Object)obj, (Object)object);
                return obj.getGlobalID();
            }
            LOG.trace("Object already had GID set: {}", (Object)obj);
        }
        NSDictionary stack = this.currentObject;
        this.currentObject = new NSDictionary();
        this.currentObject.put("isa", (Object)obj.isa());
        obj.serializeInto(this);
        this.objects.put(obj.getGlobalID(), this.currentObject);
        this.currentObject = stack;
        return obj.getGlobalID();
    }

    public void addField(String name, PBXObject obj) {
        if (obj != null) {
            String gid = this.serializeObject(obj);
            this.currentObject.put(name, (Object)gid);
        }
    }

    public void addField(String name, int val) {
        this.currentObject.put(name, (Object)val);
    }

    public void addField(String name, String val) {
        if (val != null) {
            this.currentObject.put(name, (Object)val);
        }
    }

    public void addField(String name, boolean val) {
        this.currentObject.put(name, (Object)val);
    }

    public void addField(String name, List<? extends PBXObject> objectList) {
        NSArray array = new NSArray(objectList.size());
        for (int i = 0; i < objectList.size(); ++i) {
            String gid = this.serializeObject(objectList.get(i));
            array.setValue(i, new NSString(gid));
        }
        this.currentObject.put(name, array);
    }

    public void addField(String name, NSObject v) {
        if (v != null) {
            this.currentObject.put(name, v);
        }
    }
}

