/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.initialization;

import groovy.lang.GroovyObject;
import groovy.lang.GroovySystem;
import groovy.lang.MetaClass;
import groovy.lang.MetaClassRegistry;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.gradle.initialization.LegacyTypesSupport;
import org.gradle.internal.classloader.TransformingClassLoader;
import org.gradle.internal.classloader.VisitableURLClassLoader;
import org.gradle.internal.classpath.ClassPath;
import org.gradle.internal.impldep.org.apache.commons.lang.StringUtils;
import org.gradle.internal.impldep.org.objectweb.asm.ClassReader;
import org.gradle.internal.impldep.org.objectweb.asm.ClassVisitor;
import org.gradle.internal.impldep.org.objectweb.asm.ClassWriter;
import org.gradle.internal.impldep.org.objectweb.asm.FieldVisitor;
import org.gradle.internal.impldep.org.objectweb.asm.Label;
import org.gradle.internal.impldep.org.objectweb.asm.MethodVisitor;
import org.gradle.internal.impldep.org.objectweb.asm.Type;
import org.gradle.internal.reflect.PropertyAccessorType;

public class MixInLegacyTypesClassLoader
extends TransformingClassLoader {
    private static final Type GROOVY_OBJECT_TYPE = Type.getType(GroovyObject.class);
    private static final Type META_CLASS_REGISTRY_TYPE = Type.getType(MetaClassRegistry.class);
    private static final Type GROOVY_SYSTEM_TYPE = Type.getType(GroovySystem.class);
    private static final Type META_CLASS_TYPE = Type.getType(MetaClass.class);
    private static final Type OBJECT_TYPE = Type.getType(Object.class);
    private static final Type CLASS_TYPE = Type.getType(Class.class);
    private static final Type STRING_TYPE = Type.getType(String.class);
    private static final String RETURN_OBJECT_FROM_OBJECT_STRING_OBJECT = Type.getMethodDescriptor(OBJECT_TYPE, OBJECT_TYPE, STRING_TYPE, OBJECT_TYPE);
    private static final String RETURN_OBJECT_FROM_STRING_OBJECT = Type.getMethodDescriptor(OBJECT_TYPE, STRING_TYPE, OBJECT_TYPE);
    private static final String RETURN_OBJECT_FROM_STRING = Type.getMethodDescriptor(OBJECT_TYPE, STRING_TYPE);
    private static final String RETURN_OBJECT_FROM_OBJECT_STRING = Type.getMethodDescriptor(OBJECT_TYPE, OBJECT_TYPE, STRING_TYPE);
    private static final String RETURN_VOID_FROM_OBJECT_STRING_OBJECT = Type.getMethodDescriptor(Type.VOID_TYPE, OBJECT_TYPE, STRING_TYPE, OBJECT_TYPE);
    private static final String RETURN_VOID_FROM_STRING_OBJECT = Type.getMethodDescriptor(Type.VOID_TYPE, STRING_TYPE, OBJECT_TYPE);
    private static final String RETURN_META_CLASS_REGISTRY = Type.getMethodDescriptor(META_CLASS_REGISTRY_TYPE, new Type[0]);
    private static final String RETURN_META_CLASS_FROM_CLASS = Type.getMethodDescriptor(META_CLASS_TYPE, CLASS_TYPE);
    private static final String RETURN_META_CLASS = Type.getMethodDescriptor(META_CLASS_TYPE, new Type[0]);
    private static final String RETURN_CLASS = Type.getMethodDescriptor(CLASS_TYPE, new Type[0]);
    private static final String META_CLASS_FIELD = "__meta_class__";
    private LegacyTypesSupport legacyTypesSupport;

    public MixInLegacyTypesClassLoader(ClassLoader parent, ClassPath classPath, LegacyTypesSupport legacyTypesSupport) {
        super("legacy-mixin-loader", parent, classPath);
        this.legacyTypesSupport = legacyTypesSupport;
    }

    public MixInLegacyTypesClassLoader(ClassLoader parent, Collection<URL> urls, LegacyTypesSupport legacyTypesSupport) {
        super("legacy-mixin-loader", parent, urls);
        this.legacyTypesSupport = legacyTypesSupport;
    }

    @Override
    @Nullable
    protected byte[] generateMissingClass(String name) {
        if (!this.legacyTypesSupport.getSyntheticClasses().contains(name)) {
            return null;
        }
        return this.legacyTypesSupport.generateSyntheticClass(name);
    }

    @Override
    protected boolean shouldTransform(String className) {
        return this.legacyTypesSupport.getClassesToMixInGroovyObject().contains(className) || this.legacyTypesSupport.getSyntheticClasses().contains(className);
    }

    @Override
    protected byte[] transform(String className, byte[] bytes) {
        ClassReader classReader = new ClassReader(bytes);
        ClassWriter classWriter = new ClassWriter(0);
        classReader.accept(new TransformingAdapter(classWriter), 0);
        bytes = classWriter.toByteArray();
        return bytes;
    }

    static {
        try {
            ClassLoader.registerAsParallelCapable();
        }
        catch (NoSuchMethodError noSuchMethodError) {
            // empty catch block
        }
    }

    public static class Spec
    extends VisitableURLClassLoader.Spec {
        public Spec(String name, List<URL> classpath) {
            super(name, classpath);
        }

        @Override
        public String toString() {
            return "{legacy-mixin-class-loader name:" + super.getName() + ", classpath:" + this.getClasspath() + "}";
        }
    }

    private static class TransformingAdapter
    extends ClassVisitor {
        private static final int PUBLIC_STATIC_FINAL = 25;
        private String className;
        private Map<String, String> missingStaticStringConstantGetters = new HashMap<String, String>();
        private Set<String> booleanGetGetters = new HashSet<String>();
        private Set<String> booleanFields = new HashSet<String>();
        private Set<String> booleanIsGetters = new HashSet<String>();

        TransformingAdapter(ClassVisitor cv) {
            super(458752, cv);
        }

        @Override
        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
            this.className = name;
            LinkedHashSet<String> interfaceNames = new LinkedHashSet<String>(Arrays.asList(interfaces));
            interfaceNames.add(GROOVY_OBJECT_TYPE.getInternalName());
            this.cv.visit(version, access, name, signature, superName, interfaceNames.toArray(new String[0]));
        }

        @Override
        public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
            if ((access & 0x19) == 25 && Type.getDescriptor(String.class).equals(desc)) {
                this.missingStaticStringConstantGetters.put("get" + name, (String)value);
            }
            if ((access & 2) > 0 && !this.isStatic(access) && Type.getDescriptor(Boolean.TYPE).equals(desc)) {
                this.booleanFields.add(name);
            }
            return super.visitField(access, name, desc, signature, value);
        }

        @Override
        public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
            PropertyAccessorType accessorType;
            if (this.missingStaticStringConstantGetters.containsKey(name)) {
                this.missingStaticStringConstantGetters.remove(name);
            }
            if ((access & 1) > 0 && !this.isStatic(access) && Type.getMethodDescriptor(Type.BOOLEAN_TYPE, new Type[0]).equals(desc) && (accessorType = PropertyAccessorType.fromName(name)) != null) {
                String propertyName = accessorType.propertyNameFor(name);
                if (accessorType == PropertyAccessorType.IS_GETTER) {
                    this.booleanIsGetters.add(propertyName);
                } else if (accessorType == PropertyAccessorType.GET_GETTER) {
                    this.booleanGetGetters.add(propertyName);
                }
            }
            return super.visitMethod(access, name, desc, signature, exceptions);
        }

        @Override
        public void visitEnd() {
            this.addMetaClassField();
            this.addGetMetaClass();
            this.addSetMetaClass();
            this.addGetProperty();
            this.addSetProperty();
            this.addInvokeMethod();
            this.addStaticStringConstantGetters();
            this.addBooleanGetGetters();
            this.cv.visitEnd();
        }

        private boolean isStatic(int access) {
            return (access & 8) > 0;
        }

        private void addMetaClassField() {
            this.cv.visitField(2, MixInLegacyTypesClassLoader.META_CLASS_FIELD, META_CLASS_TYPE.getDescriptor(), null, null);
        }

        private void addGetProperty() {
            MethodVisitor methodVisitor = this.cv.visitMethod(4097, "getProperty", RETURN_OBJECT_FROM_STRING, null, null);
            methodVisitor.visitCode();
            methodVisitor.visitVarInsn(25, 0);
            methodVisitor.visitMethodInsn(182, this.className, "getMetaClass", RETURN_META_CLASS, false);
            methodVisitor.visitVarInsn(25, 0);
            methodVisitor.visitVarInsn(25, 1);
            methodVisitor.visitMethodInsn(185, META_CLASS_TYPE.getInternalName(), "getProperty", RETURN_OBJECT_FROM_OBJECT_STRING, true);
            methodVisitor.visitInsn(176);
            methodVisitor.visitMaxs(3, 2);
            methodVisitor.visitEnd();
        }

        private void addSetProperty() {
            MethodVisitor methodVisitor = this.cv.visitMethod(4097, "setProperty", RETURN_VOID_FROM_STRING_OBJECT, null, null);
            methodVisitor.visitCode();
            methodVisitor.visitVarInsn(25, 0);
            methodVisitor.visitMethodInsn(182, this.className, "getMetaClass", RETURN_META_CLASS, false);
            methodVisitor.visitVarInsn(25, 0);
            methodVisitor.visitVarInsn(25, 1);
            methodVisitor.visitVarInsn(25, 2);
            methodVisitor.visitMethodInsn(185, META_CLASS_TYPE.getInternalName(), "setProperty", RETURN_VOID_FROM_OBJECT_STRING_OBJECT, true);
            methodVisitor.visitInsn(177);
            methodVisitor.visitMaxs(4, 3);
            methodVisitor.visitEnd();
        }

        private void addInvokeMethod() {
            MethodVisitor methodVisitor = this.cv.visitMethod(4097, "invokeMethod", RETURN_OBJECT_FROM_STRING_OBJECT, null, null);
            methodVisitor.visitCode();
            methodVisitor.visitVarInsn(25, 0);
            methodVisitor.visitMethodInsn(182, this.className, "getMetaClass", RETURN_META_CLASS, false);
            methodVisitor.visitVarInsn(25, 0);
            methodVisitor.visitVarInsn(25, 1);
            methodVisitor.visitVarInsn(25, 2);
            methodVisitor.visitMethodInsn(185, META_CLASS_TYPE.getInternalName(), "invokeMethod", RETURN_OBJECT_FROM_OBJECT_STRING_OBJECT, true);
            methodVisitor.visitInsn(176);
            methodVisitor.visitMaxs(4, 3);
            methodVisitor.visitEnd();
        }

        private void addGetMetaClass() {
            Label lookup = new Label();
            MethodVisitor methodVisitor = this.cv.visitMethod(4097, "getMetaClass", RETURN_META_CLASS, null, null);
            methodVisitor.visitCode();
            methodVisitor.visitVarInsn(25, 0);
            methodVisitor.visitFieldInsn(180, this.className, MixInLegacyTypesClassLoader.META_CLASS_FIELD, META_CLASS_TYPE.getDescriptor());
            methodVisitor.visitInsn(89);
            methodVisitor.visitJumpInsn(198, lookup);
            methodVisitor.visitInsn(176);
            methodVisitor.visitLabel(lookup);
            methodVisitor.visitFrame(-1, 1, new Object[]{this.className}, 1, new Object[]{META_CLASS_TYPE.getInternalName()});
            methodVisitor.visitVarInsn(25, 0);
            methodVisitor.visitMethodInsn(184, GROOVY_SYSTEM_TYPE.getInternalName(), "getMetaClassRegistry", RETURN_META_CLASS_REGISTRY, false);
            methodVisitor.visitVarInsn(25, 0);
            methodVisitor.visitMethodInsn(182, OBJECT_TYPE.getInternalName(), "getClass", RETURN_CLASS, false);
            methodVisitor.visitMethodInsn(185, META_CLASS_REGISTRY_TYPE.getInternalName(), "getMetaClass", RETURN_META_CLASS_FROM_CLASS, true);
            methodVisitor.visitFieldInsn(181, this.className, MixInLegacyTypesClassLoader.META_CLASS_FIELD, META_CLASS_TYPE.getDescriptor());
            methodVisitor.visitVarInsn(25, 0);
            methodVisitor.visitFieldInsn(180, this.className, MixInLegacyTypesClassLoader.META_CLASS_FIELD, META_CLASS_TYPE.getDescriptor());
            methodVisitor.visitInsn(176);
            methodVisitor.visitMaxs(4, 1);
            methodVisitor.visitEnd();
        }

        private void addSetMetaClass() {
            MethodVisitor methodVisitor = this.cv.visitMethod(4097, "setMetaClass", Type.getMethodDescriptor(Type.VOID_TYPE, META_CLASS_TYPE), null, null);
            methodVisitor.visitCode();
            methodVisitor.visitVarInsn(25, 0);
            methodVisitor.visitVarInsn(25, 1);
            methodVisitor.visitFieldInsn(181, this.className, MixInLegacyTypesClassLoader.META_CLASS_FIELD, META_CLASS_TYPE.getDescriptor());
            methodVisitor.visitInsn(177);
            methodVisitor.visitMaxs(2, 2);
            methodVisitor.visitEnd();
        }

        private void addStaticStringConstantGetters() {
            for (Map.Entry<String, String> constant : this.missingStaticStringConstantGetters.entrySet()) {
                MethodVisitor mv = this.cv.visitMethod(4105, constant.getKey(), Type.getMethodDescriptor(Type.getType(String.class), new Type[0]), null, null);
                mv.visitCode();
                mv.visitLdcInsn(constant.getValue());
                mv.visitInsn(176);
                mv.visitMaxs(1, 0);
                mv.visitEnd();
            }
        }

        private void addBooleanGetGetters() {
            HashSet<String> accessibleBooleanFieldsWithoutGetGetters = new HashSet<String>();
            accessibleBooleanFieldsWithoutGetGetters.addAll(this.booleanFields);
            accessibleBooleanFieldsWithoutGetGetters.retainAll(this.booleanIsGetters);
            accessibleBooleanFieldsWithoutGetGetters.removeAll(this.booleanGetGetters);
            for (String booleanField : accessibleBooleanFieldsWithoutGetGetters) {
                this.addBooleanGetGetter(booleanField);
            }
        }

        private void addBooleanGetGetter(String booleanField) {
            MethodVisitor mv = this.cv.visitMethod(4097, "get" + StringUtils.capitalize(booleanField), "()Z", null, null);
            mv.visitCode();
            Label l0 = new Label();
            mv.visitLabel(l0);
            mv.visitVarInsn(25, 0);
            mv.visitFieldInsn(180, this.className, booleanField, "Z");
            mv.visitInsn(172);
            Label l1 = new Label();
            mv.visitLabel(l1);
            mv.visitLocalVariable("this", "L" + this.className + ";", null, l0, l1, 0);
            mv.visitMaxs(1, 1);
            mv.visitEnd();
        }
    }
}

