/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.classpath;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.Arrays;
import java.util.Comparator;
import org.gradle.api.file.RelativePath;
import org.gradle.api.internal.file.archive.ZipEntry;
import org.gradle.api.internal.file.archive.ZipInput;
import org.gradle.api.internal.file.archive.impl.FileZipInput;
import org.gradle.internal.classpath.ClasspathEntryVisitor;
import org.gradle.internal.file.FileException;
import org.gradle.internal.file.FileMetadata;
import org.gradle.internal.file.FileType;
import org.gradle.internal.file.Stat;
import org.gradle.internal.service.scopes.Scopes;
import org.gradle.internal.service.scopes.ServiceScope;

@ServiceScope(value=Scopes.UserHome.class)
public class ClasspathWalker {
    private final Stat stat;

    public ClasspathWalker(Stat stat) {
        this.stat = stat;
    }

    public void visit(File root, ClasspathEntryVisitor visitor) throws IOException, FileException {
        FileMetadata fileMetadata = this.stat.stat(root);
        if (fileMetadata.getType() == FileType.RegularFile) {
            this.visitJarContents(root, visitor);
        } else if (fileMetadata.getType() == FileType.Directory) {
            this.visitDirectoryContents(root, visitor);
        }
    }

    private void visitDirectoryContents(File dir2, ClasspathEntryVisitor visitor) throws IOException {
        this.visitDir(dir2, "", visitor);
    }

    private void visitDir(File dir2, String prefix, ClasspathEntryVisitor visitor) throws IOException {
        File[] files = dir2.listFiles();
        Arrays.sort(files, Comparator.comparing(File::getName));
        for (File file : files) {
            FileMetadata fileMetadata = this.stat.stat(file);
            if (fileMetadata.getType() == FileType.RegularFile) {
                this.visitFile(file, prefix + file.getName(), visitor);
                continue;
            }
            if (fileMetadata.getType() != FileType.Directory) continue;
            this.visitDir(file, prefix + file.getName() + "/", visitor);
        }
    }

    private void visitFile(File file, String name, ClasspathEntryVisitor visitor) throws IOException {
        visitor.visit(new FileEntry(name, file));
    }

    private void visitJarContents(File jarFile, ClasspathEntryVisitor visitor) throws IOException {
        try (ZipInput entries = FileZipInput.create(jarFile);){
            for (ZipEntry entry : entries) {
                if (entry.isDirectory()) continue;
                visitor.visit(new ZipClasspathEntry(entry));
            }
        }
    }

    private static class FileEntry
    implements ClasspathEntryVisitor.Entry {
        private final String name;
        private final File file;

        public FileEntry(String name, File file) {
            this.name = name;
            this.file = file;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public RelativePath getPath() {
            return RelativePath.parse(false, this.name);
        }

        @Override
        public byte[] getContent() throws IOException {
            return Files.readAllBytes(this.file.toPath());
        }
    }

    private static class ZipClasspathEntry
    implements ClasspathEntryVisitor.Entry {
        private final ZipEntry entry;

        public ZipClasspathEntry(ZipEntry entry) {
            this.entry = entry;
        }

        @Override
        public String getName() {
            return this.entry.getName();
        }

        @Override
        public RelativePath getPath() {
            return RelativePath.parse(false, this.getName());
        }

        @Override
        public byte[] getContent() throws IOException {
            return this.entry.getContent();
        }
    }
}

