/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.component.external.model;

import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.capabilities.CapabilitiesMetadata;
import org.gradle.api.internal.attributes.AttributeContainerInternal;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.internal.Describables;
import org.gradle.internal.DisplayName;
import org.gradle.internal.component.external.model.AbstractModuleComponentResolveMetadata;
import org.gradle.internal.component.external.model.ComponentVariant;
import org.gradle.internal.component.external.model.GradleDependencyMetadata;
import org.gradle.internal.component.external.model.ImmutableCapabilities;
import org.gradle.internal.component.external.model.RealisedVariantBackedConfigurationMetadata;
import org.gradle.internal.component.external.model.UrlBackedArtifactMetadata;
import org.gradle.internal.component.external.model.VariantDerivationStrategy;
import org.gradle.internal.component.external.model.VariantMetadataRules;
import org.gradle.internal.component.model.ComponentArtifactMetadata;
import org.gradle.internal.component.model.ConfigurationMetadata;
import org.gradle.internal.component.model.ModuleSources;
import org.gradle.internal.component.model.VariantResolveMetadata;
import org.gradle.internal.impldep.com.google.common.base.Objects;
import org.gradle.internal.impldep.com.google.common.base.Optional;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableList;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableMap;

public abstract class AbstractRealisedModuleComponentResolveMetadata
extends AbstractModuleComponentResolveMetadata {
    private Optional<ImmutableList<? extends ConfigurationMetadata>> graphVariants;
    private final ImmutableMap<String, ConfigurationMetadata> configurations;

    public AbstractRealisedModuleComponentResolveMetadata(AbstractRealisedModuleComponentResolveMetadata metadata) {
        super(metadata);
        this.configurations = metadata.configurations;
    }

    public AbstractRealisedModuleComponentResolveMetadata(AbstractRealisedModuleComponentResolveMetadata metadata, ModuleSources sources, VariantDerivationStrategy derivationStrategy) {
        super(metadata, sources, derivationStrategy);
        this.configurations = metadata.configurations;
    }

    public AbstractRealisedModuleComponentResolveMetadata(AbstractModuleComponentResolveMetadata mutableMetadata, ImmutableList<? extends ComponentVariant> variants, Map<String, ConfigurationMetadata> configurations) {
        super(mutableMetadata, variants);
        this.configurations = ImmutableMap.builder().putAll(configurations).build();
    }

    @Override
    public VariantMetadataRules getVariantMetadataRules() {
        return VariantMetadataRules.noOp();
    }

    @Override
    public Set<String> getConfigurationNames() {
        return this.configurations.keySet();
    }

    @Override
    @Nullable
    public ConfigurationMetadata getConfiguration(String name) {
        return this.configurations.get(name);
    }

    @Override
    public Optional<ImmutableList<? extends ConfigurationMetadata>> getVariantsForGraphTraversal() {
        if (this.graphVariants == null) {
            this.graphVariants = this.buildVariantsForGraphTraversal(this.getVariants());
        }
        return this.graphVariants;
    }

    private Optional<ImmutableList<? extends ConfigurationMetadata>> buildVariantsForGraphTraversal(List<? extends ComponentVariant> variants) {
        if (variants.isEmpty()) {
            return this.maybeDeriveVariants();
        }
        ImmutableList.Builder configurations = new ImmutableList.Builder();
        for (ComponentVariant componentVariant : variants) {
            configurations.add(new RealisedVariantBackedConfigurationMetadata(this.getId(), componentVariant, this.getAttributes(), this.getAttributesFactory()));
        }
        return Optional.of(configurations.build());
    }

    public static class ImmutableRealisedVariantImpl
    implements ComponentVariant,
    VariantResolveMetadata {
        private final ModuleComponentIdentifier componentId;
        private final String name;
        private final ImmutableAttributes attributes;
        private final ImmutableList<? extends ComponentVariant.Dependency> dependencies;
        private final ImmutableList<? extends ComponentVariant.DependencyConstraint> dependencyConstraints;
        private final ImmutableList<? extends ComponentVariant.File> files;
        private final ImmutableCapabilities capabilities;
        private final ImmutableList<GradleDependencyMetadata> dependencyMetadata;
        private final boolean externalVariant;

        public ImmutableRealisedVariantImpl(ModuleComponentIdentifier componentId, String name, ImmutableAttributes attributes, ImmutableList<? extends ComponentVariant.Dependency> dependencies, ImmutableList<? extends ComponentVariant.DependencyConstraint> dependencyConstraints, ImmutableList<? extends ComponentVariant.File> files, ImmutableCapabilities capabilities, List<GradleDependencyMetadata> dependencyMetadata, boolean externalVariant) {
            this.componentId = componentId;
            this.name = name;
            this.attributes = attributes;
            this.dependencies = dependencies;
            this.dependencyConstraints = dependencyConstraints;
            this.files = files;
            this.capabilities = capabilities;
            this.dependencyMetadata = ImmutableList.copyOf(dependencyMetadata);
            this.externalVariant = externalVariant;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public VariantResolveMetadata.Identifier getIdentifier() {
            return null;
        }

        @Override
        public DisplayName asDescribable() {
            return Describables.of(this.componentId, "variant", this.name);
        }

        @Override
        public ImmutableAttributes getAttributes() {
            return this.attributes;
        }

        @Override
        public ImmutableList<? extends ComponentVariant.Dependency> getDependencies() {
            return this.dependencies;
        }

        @Override
        public ImmutableList<? extends ComponentVariant.DependencyConstraint> getDependencyConstraints() {
            return this.dependencyConstraints;
        }

        public ImmutableList<GradleDependencyMetadata> getDependencyMetadata() {
            return this.dependencyMetadata;
        }

        @Override
        public ImmutableList<? extends ComponentVariant.File> getFiles() {
            return this.files;
        }

        @Override
        public CapabilitiesMetadata getCapabilities() {
            return this.capabilities;
        }

        @Override
        public ImmutableList<? extends ComponentArtifactMetadata> getArtifacts() {
            ImmutableList.Builder artifacts2 = new ImmutableList.Builder();
            for (ComponentVariant.File file : this.files) {
                artifacts2.add(new UrlBackedArtifactMetadata(this.componentId, file.getName(), file.getUri()));
            }
            return artifacts2.build();
        }

        @Override
        public boolean isExternalVariant() {
            return this.externalVariant;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ImmutableRealisedVariantImpl that = (ImmutableRealisedVariantImpl)o;
            return Objects.equal(this.componentId, that.componentId) && Objects.equal(this.name, that.name) && Objects.equal(this.attributes, that.attributes) && Objects.equal(this.dependencies, that.dependencies) && Objects.equal(this.dependencyConstraints, that.dependencyConstraints) && Objects.equal(this.files, that.files) && this.externalVariant == that.externalVariant;
        }

        public int hashCode() {
            return Objects.hashCode(this.componentId, this.name, this.attributes, this.dependencies, this.dependencyConstraints, this.files, this.externalVariant);
        }
    }

    protected static class NameOnlyVariantResolveMetadata
    implements VariantResolveMetadata {
        private final String name;

        public NameOnlyVariantResolveMetadata(String name) {
            this.name = name;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public VariantResolveMetadata.Identifier getIdentifier() {
            return null;
        }

        @Override
        public DisplayName asDescribable() {
            throw new UnsupportedOperationException("NameOnlyVariantResolveMetadata cannot be used that way");
        }

        @Override
        public AttributeContainerInternal getAttributes() {
            throw new UnsupportedOperationException("NameOnlyVariantResolveMetadata cannot be used that way");
        }

        @Override
        public ImmutableList<? extends ComponentArtifactMetadata> getArtifacts() {
            throw new UnsupportedOperationException("NameOnlyVariantResolveMetadata cannot be used that way");
        }

        @Override
        public CapabilitiesMetadata getCapabilities() {
            throw new UnsupportedOperationException("NameOnlyVariantResolveMetadata cannot be used that way");
        }

        @Override
        public boolean isExternalVariant() {
            return false;
        }
    }
}

