/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.component.external.model;

import javax.annotation.Nullable;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.Project;
import org.gradle.api.capabilities.Capability;
import org.gradle.internal.component.external.model.CapabilityInternal;
import org.gradle.internal.impldep.com.google.common.base.Objects;
import org.gradle.util.TextUtil;

public class ProjectDerivedCapability
implements CapabilityInternal {
    private final Project project;
    private final String featureName;

    public ProjectDerivedCapability(Project project) {
        this(project, null);
    }

    public ProjectDerivedCapability(Project project, @Nullable String featureName) {
        this.project = project;
        this.featureName = featureName;
    }

    @Override
    public String getGroup() {
        return ProjectDerivedCapability.notNull("group", this.project.getGroup());
    }

    @Override
    public String getName() {
        String name = ProjectDerivedCapability.notNull("name", this.project.getName());
        return this.featureName == null ? name : name + "-" + TextUtil.camelToKebabCase(this.featureName);
    }

    @Override
    public String getVersion() {
        return ProjectDerivedCapability.notNull("version", this.project.getVersion());
    }

    public int hashCode() {
        return 31 * this.project.hashCode() + this.featureName.hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Capability)) {
            return false;
        }
        Capability that = (Capability)o;
        return Objects.equal(this.getGroup(), that.getGroup()) && Objects.equal(this.getName(), that.getName()) && Objects.equal(this.getVersion(), that.getVersion());
    }

    private static String notNull(String id, Object o) {
        if (o == null) {
            throw new InvalidUserDataException(id + " must not be null");
        }
        return o.toString();
    }

    @Override
    public String getCapabilityId() {
        return this.getGroup() + ":" + this.getName();
    }
}

