/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.component.local.model;

import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.component.LibraryBinaryIdentifier;
import org.gradle.api.artifacts.component.LibraryComponentSelector;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.capabilities.Capability;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.internal.impldep.com.google.common.base.Objects;
import org.gradle.internal.impldep.com.google.common.base.Strings;

public class DefaultLibraryComponentSelector
implements LibraryComponentSelector {
    private final String projectPath;
    private final String libraryName;
    private final String variant;

    public DefaultLibraryComponentSelector(String projectPath, String libraryName) {
        this(projectPath, libraryName, null);
    }

    public DefaultLibraryComponentSelector(String projectPath, String libraryName, String variant) {
        assert (!Strings.isNullOrEmpty(projectPath)) : "project path cannot be null or empty";
        this.projectPath = projectPath;
        this.libraryName = Strings.emptyToNull(libraryName);
        this.variant = variant;
    }

    @Override
    public String getDisplayName() {
        String txt = Strings.isNullOrEmpty(this.libraryName) ? "project '" + this.projectPath + "'" : (Strings.isNullOrEmpty(this.variant) ? "project '" + this.projectPath + "' library '" + this.libraryName + "'" : "project '" + this.projectPath + "' library '" + this.libraryName + "' binary '" + this.variant + "'");
        return txt;
    }

    @Override
    public String getProjectPath() {
        return this.projectPath;
    }

    @Override
    public String getLibraryName() {
        return this.libraryName;
    }

    @Override
    @Nullable
    public String getVariant() {
        return this.variant;
    }

    @Override
    public boolean matchesStrictly(ComponentIdentifier identifier) {
        assert (identifier != null) : "identifier cannot be null";
        if (identifier instanceof LibraryBinaryIdentifier) {
            LibraryBinaryIdentifier projectComponentIdentifier = (LibraryBinaryIdentifier)identifier;
            return Objects.equal(projectComponentIdentifier.getProjectPath(), this.projectPath) && Objects.equal(projectComponentIdentifier.getLibraryName(), this.libraryName) && Objects.equal(projectComponentIdentifier.getVariant(), this.variant);
        }
        return false;
    }

    @Override
    public AttributeContainer getAttributes() {
        return ImmutableAttributes.EMPTY;
    }

    @Override
    public List<Capability> getRequestedCapabilities() {
        return Collections.emptyList();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultLibraryComponentSelector that = (DefaultLibraryComponentSelector)o;
        return Objects.equal(this.projectPath, that.projectPath) && Objects.equal(this.libraryName, that.libraryName) && Objects.equal(this.variant, that.variant);
    }

    public int hashCode() {
        return Objects.hashCode(this.projectPath, this.libraryName, this.variant);
    }

    public String toString() {
        return this.getDisplayName();
    }
}

