/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.composite;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import org.gradle.api.initialization.IncludedBuild;
import org.gradle.api.internal.BuildDefinition;
import org.gradle.api.internal.GradleInternal;
import org.gradle.api.internal.SettingsInternal;
import org.gradle.initialization.IncludedBuildSpec;
import org.gradle.initialization.SettingsLoader;
import org.gradle.internal.build.BuildStateRegistry;
import org.gradle.internal.build.CompositeBuildParticipantBuildState;
import org.gradle.internal.build.IncludedBuildState;
import org.gradle.internal.build.PublicBuildPath;
import org.gradle.internal.composite.DefaultConfigurableIncludedBuild;
import org.gradle.internal.composite.IncludedRootBuild;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.plugin.management.internal.PluginRequests;

public class ChildBuildRegisteringSettingsLoader
implements SettingsLoader {
    private final SettingsLoader delegate;
    private final BuildStateRegistry buildRegistry;
    private final PublicBuildPath publicBuildPath;
    private final Instantiator instantiator;

    public ChildBuildRegisteringSettingsLoader(SettingsLoader delegate, BuildStateRegistry buildRegistry, PublicBuildPath publicBuildPath, Instantiator instantiator) {
        this.delegate = delegate;
        this.buildRegistry = buildRegistry;
        this.publicBuildPath = publicBuildPath;
        this.instantiator = instantiator;
    }

    @Override
    public SettingsInternal findAndLoadSettings(GradleInternal gradle) {
        SettingsInternal settings = this.delegate.findAndLoadSettings(gradle);
        List<IncludedBuildSpec> includedBuilds = settings.getIncludedBuilds();
        if (!includedBuilds.isEmpty()) {
            LinkedHashSet<IncludedBuild> children = new LinkedHashSet<IncludedBuild>(includedBuilds.size());
            for (IncludedBuildSpec includedBuildSpec : includedBuilds) {
                if (!includedBuildSpec.rootDir.equals(this.buildRegistry.getRootBuild().getBuildRootDir())) {
                    IncludedBuildState includedBuild = this.addIncludedBuild(includedBuildSpec, gradle);
                    children.add(includedBuild.getModel());
                    continue;
                }
                this.buildRegistry.registerSubstitutionsForRootBuild();
                children.add(new IncludedRootBuild((CompositeBuildParticipantBuildState)((Object)this.buildRegistry.getRootBuild())));
            }
            gradle.setIncludedBuilds(children);
        } else {
            gradle.setIncludedBuilds(Collections.emptyList());
        }
        return settings;
    }

    private IncludedBuildState addIncludedBuild(IncludedBuildSpec includedBuildSpec, GradleInternal gradle) {
        gradle.getOwner().assertCanAdd(includedBuildSpec);
        DefaultConfigurableIncludedBuild configurable = this.instantiator.newInstance(DefaultConfigurableIncludedBuild.class, includedBuildSpec.rootDir);
        includedBuildSpec.configurer.execute(configurable);
        BuildDefinition buildDefinition = BuildDefinition.fromStartParameterForBuild(gradle.getStartParameter(), configurable.getName(), includedBuildSpec.rootDir, PluginRequests.EMPTY, configurable.getDependencySubstitutionAction(), this.publicBuildPath);
        return this.buildRegistry.addIncludedBuild(buildDefinition);
    }
}

