/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.execution.history.impl;

import java.util.Map;
import javax.annotation.Nullable;
import org.gradle.internal.execution.history.OverlappingOutputDetector;
import org.gradle.internal.execution.history.OverlappingOutputs;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableSortedMap;
import org.gradle.internal.snapshot.DirectorySnapshot;
import org.gradle.internal.snapshot.FileSystemLocationSnapshot;
import org.gradle.internal.snapshot.FileSystemSnapshot;
import org.gradle.internal.snapshot.MissingFileSnapshot;
import org.gradle.internal.snapshot.RegularFileSnapshot;
import org.gradle.internal.snapshot.RootTrackingFileSystemSnapshotHierarchyVisitor;
import org.gradle.internal.snapshot.SnapshotUtil;
import org.gradle.internal.snapshot.SnapshotVisitResult;

public class DefaultOverlappingOutputDetector
implements OverlappingOutputDetector {
    @Override
    @Nullable
    public OverlappingOutputs detect(ImmutableSortedMap<String, FileSystemSnapshot> previous, ImmutableSortedMap<String, FileSystemSnapshot> current) {
        for (Map.Entry entry : current.entrySet()) {
            OverlappingOutputs overlappingOutputs;
            String propertyName = (String)entry.getKey();
            FileSystemSnapshot currentSnapshot = (FileSystemSnapshot)entry.getValue();
            FileSystemSnapshot previousSnapshot = previous.getOrDefault(propertyName, FileSystemSnapshot.EMPTY);
            if (SnapshotUtil.getRootHashes(previousSnapshot).equals(SnapshotUtil.getRootHashes(currentSnapshot)) || (overlappingOutputs = DefaultOverlappingOutputDetector.detect(propertyName, previousSnapshot, currentSnapshot)) == null) continue;
            return overlappingOutputs;
        }
        return null;
    }

    @Nullable
    private static OverlappingOutputs detect(String propertyName, FileSystemSnapshot previous, FileSystemSnapshot before) {
        Map<String, FileSystemLocationSnapshot> previousIndex = SnapshotUtil.index(previous);
        OverlappingOutputsDetectingVisitor outputsDetectingVisitor = new OverlappingOutputsDetectingVisitor(previousIndex);
        before.accept(outputsDetectingVisitor);
        String overlappingPath = outputsDetectingVisitor.getOverlappingPath();
        return overlappingPath == null ? null : new OverlappingOutputs(propertyName, overlappingPath);
    }

    private static class OverlappingOutputsDetectingVisitor
    extends RootTrackingFileSystemSnapshotHierarchyVisitor {
        private final Map<String, FileSystemLocationSnapshot> previousSnapshots;
        private String overlappingPath;

        public OverlappingOutputsDetectingVisitor(Map<String, FileSystemLocationSnapshot> previousSnapshots) {
            this.previousSnapshots = previousSnapshots;
        }

        @Override
        public SnapshotVisitResult visitEntry(FileSystemLocationSnapshot snapshot, final boolean isRoot) {
            boolean newContent = snapshot.accept(new FileSystemLocationSnapshot.FileSystemLocationSnapshotTransformer<Boolean>(){

                @Override
                public Boolean visitDirectory(DirectorySnapshot directorySnapshot) {
                    return this.hasNewContent(directorySnapshot);
                }

                @Override
                public Boolean visitRegularFile(RegularFileSnapshot fileSnapshot) {
                    return this.hasNewContent(fileSnapshot);
                }

                @Override
                public Boolean visitMissing(MissingFileSnapshot missingSnapshot) {
                    if (isRoot) {
                        return false;
                    }
                    return this.hasNewContent(missingSnapshot);
                }
            });
            if (newContent) {
                this.overlappingPath = snapshot.getAbsolutePath();
                return SnapshotVisitResult.TERMINATE;
            }
            return SnapshotVisitResult.CONTINUE;
        }

        private boolean hasNewContent(FileSystemLocationSnapshot snapshot) {
            FileSystemLocationSnapshot previousSnapshot = this.previousSnapshots.get(snapshot.getAbsolutePath());
            if (previousSnapshot == null) {
                return true;
            }
            return !snapshot.isContentUpToDate(previousSnapshot);
        }

        @Nullable
        public String getOverlappingPath() {
            return this.overlappingPath;
        }
    }
}

