/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.execution.impl;

import java.util.Optional;
import javax.annotation.Nullable;
import org.gradle.cache.Cache;
import org.gradle.internal.Try;
import org.gradle.internal.execution.CachingResult;
import org.gradle.internal.execution.DeferredExecutionAwareStep;
import org.gradle.internal.execution.DeferredExecutionHandler;
import org.gradle.internal.execution.ExecutionEngine;
import org.gradle.internal.execution.ExecutionRequestContext;
import org.gradle.internal.execution.UnitOfWork;

public class DefaultExecutionEngine
implements ExecutionEngine {
    private final DeferredExecutionAwareStep<? super ExecutionRequestContext, CachingResult> executeStep;

    public DefaultExecutionEngine(DeferredExecutionAwareStep<? super ExecutionRequestContext, CachingResult> executeStep) {
        this.executeStep = executeStep;
    }

    @Override
    public CachingResult execute(UnitOfWork work) {
        return (CachingResult)this.executeStep.execute(work, new Request(null));
    }

    @Override
    public CachingResult rebuild(UnitOfWork work, String reason) {
        return (CachingResult)this.executeStep.execute(work, new Request(reason));
    }

    @Override
    public <T, O> T getFromIdentityCacheOrDeferExecution(UnitOfWork work, Cache<UnitOfWork.Identity, Try<O>> cache2, DeferredExecutionHandler<O, T> handler) {
        return this.executeStep.executeDeferred(work, new Request(null), cache2, handler);
    }

    private static class Request
    implements ExecutionRequestContext {
        private final String rebuildReason;

        public Request(@Nullable String rebuildReason) {
            this.rebuildReason = rebuildReason;
        }

        @Override
        public Optional<String> getRebuildReason() {
            return Optional.ofNullable(this.rebuildReason);
        }
    }
}

