/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.execution.impl;

import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.gradle.api.UncheckedIOException;
import org.gradle.internal.execution.UnitOfWork;
import org.gradle.internal.fingerprint.CurrentFileCollectionFingerprint;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableSortedMap;
import org.gradle.internal.snapshot.ValueSnapshot;
import org.gradle.internal.snapshot.ValueSnapshotter;

public class InputUtil {
    public static Result fingerprintInputProperties(UnitOfWork work, ImmutableSortedMap<String, ValueSnapshot> previousValueSnapshots, ValueSnapshotter valueSnapshotter, ImmutableSortedMap<String, ValueSnapshot> knownValueSnapshots, ImmutableSortedMap<String, CurrentFileCollectionFingerprint> knownFingerprints, InputPropertyPredicate filter) {
        InputCollectingVisitor visitor = new InputCollectingVisitor(work, previousValueSnapshots, valueSnapshotter, knownValueSnapshots, knownFingerprints, filter);
        work.visitInputs(visitor);
        return visitor.complete();
    }

    public static <K extends Comparable<?>, V> ImmutableSortedMap<K, V> union(ImmutableSortedMap<K, V> a, ImmutableSortedMap<K, V> b) {
        if (a.isEmpty()) {
            return b;
        }
        if (b.isEmpty()) {
            return a;
        }
        return ((ImmutableSortedMap.Builder)((ImmutableSortedMap.Builder)ImmutableSortedMap.naturalOrder().putAll(a)).putAll(b)).build();
    }

    private static class InputCollectingVisitor
    implements UnitOfWork.InputVisitor {
        private final UnitOfWork work;
        private final ImmutableSortedMap<String, ValueSnapshot> previousValueSnapshots;
        private final ValueSnapshotter valueSnapshotter;
        private final ImmutableSortedMap<String, ValueSnapshot> knownValueSnapshots;
        private final ImmutableSortedMap<String, CurrentFileCollectionFingerprint> knownFingerprints;
        private final InputPropertyPredicate filter;
        private final ImmutableSortedMap.Builder<String, ValueSnapshot> valueSnapshotsBuilder = ImmutableSortedMap.naturalOrder();
        private final ImmutableSortedMap.Builder<String, CurrentFileCollectionFingerprint> fingerprintsBuilder = ImmutableSortedMap.naturalOrder();

        public InputCollectingVisitor(UnitOfWork work, ImmutableSortedMap<String, ValueSnapshot> previousValueSnapshots, ValueSnapshotter valueSnapshotter, ImmutableSortedMap<String, ValueSnapshot> knownValueSnapshots, ImmutableSortedMap<String, CurrentFileCollectionFingerprint> knownFingerprints, InputPropertyPredicate filter) {
            this.work = work;
            this.previousValueSnapshots = previousValueSnapshots;
            this.valueSnapshotter = valueSnapshotter;
            this.knownValueSnapshots = knownValueSnapshots;
            this.knownFingerprints = knownFingerprints;
            this.filter = filter;
        }

        @Override
        public void visitInputProperty(String propertyName, UnitOfWork.IdentityKind identity, UnitOfWork.ValueSupplier value) {
            if (this.knownValueSnapshots.containsKey(propertyName)) {
                return;
            }
            if (!this.filter.include(propertyName, UnitOfWork.InputPropertyType.NON_INCREMENTAL, identity)) {
                return;
            }
            Object actualValue = value.getValue();
            try {
                ValueSnapshot previousSnapshot = this.previousValueSnapshots.get(propertyName);
                if (previousSnapshot == null) {
                    this.valueSnapshotsBuilder.put((Object)propertyName, (Object)this.valueSnapshotter.snapshot(actualValue));
                } else {
                    this.valueSnapshotsBuilder.put((Object)propertyName, (Object)this.valueSnapshotter.snapshot(actualValue, previousSnapshot));
                }
            }
            catch (Exception e) {
                throw new UncheckedIOException(String.format("Unable to store input properties for %s. Property '%s' with value '%s' cannot be serialized.", this.work.getDisplayName(), propertyName, value.getValue()), e);
            }
        }

        @Override
        public void visitInputFileProperty(String propertyName, UnitOfWork.InputPropertyType type, UnitOfWork.IdentityKind identity, @Nullable Object value, Supplier<CurrentFileCollectionFingerprint> fingerprinter) {
            if (this.knownFingerprints.containsKey(propertyName)) {
                return;
            }
            if (!this.filter.include(propertyName, type, identity)) {
                return;
            }
            this.fingerprintsBuilder.put((Object)propertyName, (Object)fingerprinter.get());
        }

        public Result complete() {
            return new Result(){

                @Override
                public ImmutableSortedMap<String, ValueSnapshot> getValueSnapshots() {
                    return valueSnapshotsBuilder.build();
                }

                @Override
                public ImmutableSortedMap<String, CurrentFileCollectionFingerprint> getFileFingerprints() {
                    return fingerprintsBuilder.build();
                }
            };
        }
    }

    public static interface Result {
        public ImmutableSortedMap<String, ValueSnapshot> getValueSnapshots();

        public ImmutableSortedMap<String, CurrentFileCollectionFingerprint> getFileFingerprints();
    }

    public static interface InputPropertyPredicate {
        public boolean include(String var1, UnitOfWork.InputPropertyType var2, UnitOfWork.IdentityKind var3);
    }
}

