/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.execution.steps;

import org.gradle.internal.execution.Context;
import org.gradle.internal.execution.CurrentSnapshotResult;
import org.gradle.internal.execution.Step;
import org.gradle.internal.execution.UnitOfWork;
import org.gradle.internal.execution.history.OutputFilesRepository;

public class RecordOutputsStep<C extends Context>
implements Step<C, CurrentSnapshotResult> {
    private final OutputFilesRepository outputFilesRepository;
    private final Step<? super C, ? extends CurrentSnapshotResult> delegate;

    public RecordOutputsStep(OutputFilesRepository outputFilesRepository, Step<? super C, ? extends CurrentSnapshotResult> delegate) {
        this.outputFilesRepository = outputFilesRepository;
        this.delegate = delegate;
    }

    @Override
    public CurrentSnapshotResult execute(UnitOfWork work, C context) {
        CurrentSnapshotResult result = this.delegate.execute(work, context);
        this.outputFilesRepository.recordOutputs(result.getOutputFilesProduceByWork().values());
        return result;
    }
}

