/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.execution.steps;

import java.io.File;
import java.util.Optional;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.gradle.api.InvalidUserDataException;
import org.gradle.internal.execution.CachingContext;
import org.gradle.internal.execution.IncrementalChangesContext;
import org.gradle.internal.execution.Result;
import org.gradle.internal.execution.Step;
import org.gradle.internal.execution.UnitOfWork;
import org.gradle.internal.execution.caching.CachingState;
import org.gradle.internal.execution.history.AfterPreviousExecutionState;
import org.gradle.internal.execution.history.BeforeExecutionState;
import org.gradle.internal.execution.history.ExecutionHistoryStore;
import org.gradle.internal.execution.history.changes.DefaultIncrementalInputProperties;
import org.gradle.internal.execution.history.changes.ExecutionStateChangeDetector;
import org.gradle.internal.execution.history.changes.ExecutionStateChanges;
import org.gradle.internal.execution.history.changes.IncrementalInputProperties;
import org.gradle.internal.execution.history.changes.RebuildExecutionStateChanges;
import org.gradle.internal.fingerprint.CurrentFileCollectionFingerprint;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableBiMap;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableSortedMap;
import org.gradle.internal.snapshot.ValueSnapshot;

public class ResolveChangesStep<R extends Result>
implements Step<CachingContext, R> {
    private static final String NO_HISTORY = "No history is available.";
    private final ExecutionStateChangeDetector changeDetector;
    private final Step<? super IncrementalChangesContext, R> delegate;

    public ResolveChangesStep(ExecutionStateChangeDetector changeDetector, Step<? super IncrementalChangesContext, R> delegate) {
        this.changeDetector = changeDetector;
        this.delegate = delegate;
    }

    @Override
    public R execute(UnitOfWork work, final CachingContext context) {
        final Optional<BeforeExecutionState> beforeExecutionState = context.getBeforeExecutionState();
        final ExecutionStateChanges changes = context.getRebuildReason().map(rebuildReason -> new RebuildExecutionStateChanges((String)rebuildReason, beforeExecutionState.map(BeforeExecutionState::getInputFileProperties).orElse(null), ResolveChangesStep.createIncrementalInputProperties(work))).orElseGet(() -> beforeExecutionState.map(beforeExecution -> context.getAfterPreviousExecutionState().map(afterPreviousExecution -> this.changeDetector.detectChanges((AfterPreviousExecutionState)afterPreviousExecution, (BeforeExecutionState)beforeExecution, work, ResolveChangesStep.createIncrementalInputProperties(work))).orElseGet(() -> new RebuildExecutionStateChanges(NO_HISTORY, beforeExecution.getInputFileProperties(), ResolveChangesStep.createIncrementalInputProperties(work)))).orElse(null));
        return this.delegate.execute(work, new IncrementalChangesContext(){

            @Override
            public Optional<ExecutionStateChanges> getChanges() {
                return Optional.ofNullable(changes);
            }

            @Override
            public CachingState getCachingState() {
                return context.getCachingState();
            }

            @Override
            public Optional<String> getRebuildReason() {
                return context.getRebuildReason();
            }

            @Override
            public ImmutableSortedMap<String, ValueSnapshot> getInputProperties() {
                return context.getInputProperties();
            }

            @Override
            public ImmutableSortedMap<String, CurrentFileCollectionFingerprint> getInputFileProperties() {
                return context.getInputFileProperties();
            }

            @Override
            public UnitOfWork.Identity getIdentity() {
                return context.getIdentity();
            }

            @Override
            public File getWorkspace() {
                return context.getWorkspace();
            }

            @Override
            public Optional<ExecutionHistoryStore> getHistory() {
                return context.getHistory();
            }

            @Override
            public Optional<AfterPreviousExecutionState> getAfterPreviousExecutionState() {
                return context.getAfterPreviousExecutionState();
            }

            @Override
            public Optional<BeforeExecutionState> getBeforeExecutionState() {
                return beforeExecutionState;
            }
        });
    }

    private static IncrementalInputProperties createIncrementalInputProperties(UnitOfWork work) {
        UnitOfWork.InputChangeTrackingStrategy inputChangeTrackingStrategy = work.getInputChangeTrackingStrategy();
        switch (inputChangeTrackingStrategy) {
            case NONE: {
                return IncrementalInputProperties.NONE;
            }
            case ALL_PARAMETERS: {
                return IncrementalInputProperties.ALL;
            }
            case INCREMENTAL_PARAMETERS: {
                final ImmutableBiMap.Builder builder = ImmutableBiMap.builder();
                work.visitInputs(new UnitOfWork.InputVisitor(){

                    @Override
                    public void visitInputFileProperty(String propertyName, UnitOfWork.InputPropertyType type, UnitOfWork.IdentityKind identity, @Nullable Object value, Supplier<CurrentFileCollectionFingerprint> fingerprinter) {
                        if (type.isIncremental()) {
                            if (value == null) {
                                throw new InvalidUserDataException("Must specify a value for incremental input property '" + propertyName + "'.");
                            }
                            builder.put(propertyName, value);
                        }
                    }
                });
                return new DefaultIncrementalInputProperties((ImmutableBiMap<String, Object>)builder.build());
            }
        }
        throw new AssertionError((Object)("Unknown InputChangeTrackingStrategy: " + (Object)((Object)inputChangeTrackingStrategy)));
    }
}

