/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.execution.steps;

import java.io.File;
import java.util.Optional;
import org.gradle.internal.execution.IncrementalChangesContext;
import org.gradle.internal.execution.InputChangesContext;
import org.gradle.internal.execution.Result;
import org.gradle.internal.execution.Step;
import org.gradle.internal.execution.UnitOfWork;
import org.gradle.internal.execution.history.AfterPreviousExecutionState;
import org.gradle.internal.execution.history.BeforeExecutionState;
import org.gradle.internal.execution.history.ExecutionHistoryStore;
import org.gradle.internal.execution.history.changes.ExecutionStateChanges;
import org.gradle.internal.execution.history.changes.InputChangesInternal;
import org.gradle.internal.fingerprint.CurrentFileCollectionFingerprint;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableSortedMap;
import org.gradle.internal.snapshot.ValueSnapshot;
import org.gradle.work.InputChanges;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResolveInputChangesStep<C extends IncrementalChangesContext>
implements Step<C, Result> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ResolveInputChangesStep.class);
    private final Step<? super InputChangesContext, ? extends Result> delegate;

    public ResolveInputChangesStep(Step<? super InputChangesContext, ? extends Result> delegate) {
        this.delegate = delegate;
    }

    @Override
    public Result execute(UnitOfWork work, C context) {
        final Optional inputChanges = work.getInputChangeTrackingStrategy().requiresInputChanges() ? Optional.of(this.determineInputChanges(work, (IncrementalChangesContext)context)) : Optional.empty();
        return this.delegate.execute(work, new InputChangesContext((IncrementalChangesContext)context){
            final /* synthetic */ IncrementalChangesContext val$context;
            {
                this.val$context = incrementalChangesContext;
            }

            @Override
            public Optional<InputChangesInternal> getInputChanges() {
                return inputChanges;
            }

            @Override
            public boolean isIncrementalExecution() {
                return inputChanges.map(InputChanges::isIncremental).orElse(false);
            }

            @Override
            public Optional<String> getRebuildReason() {
                return this.val$context.getRebuildReason();
            }

            @Override
            public ImmutableSortedMap<String, ValueSnapshot> getInputProperties() {
                return this.val$context.getInputProperties();
            }

            @Override
            public ImmutableSortedMap<String, CurrentFileCollectionFingerprint> getInputFileProperties() {
                return this.val$context.getInputFileProperties();
            }

            @Override
            public UnitOfWork.Identity getIdentity() {
                return this.val$context.getIdentity();
            }

            @Override
            public File getWorkspace() {
                return this.val$context.getWorkspace();
            }

            @Override
            public Optional<ExecutionHistoryStore> getHistory() {
                return this.val$context.getHistory();
            }

            @Override
            public Optional<AfterPreviousExecutionState> getAfterPreviousExecutionState() {
                return this.val$context.getAfterPreviousExecutionState();
            }

            @Override
            public Optional<BeforeExecutionState> getBeforeExecutionState() {
                return this.val$context.getBeforeExecutionState();
            }
        });
    }

    private InputChangesInternal determineInputChanges(UnitOfWork work, IncrementalChangesContext context) {
        ExecutionStateChanges changes = context.getChanges().get();
        InputChangesInternal inputChanges = changes.createInputChanges();
        if (!inputChanges.isIncremental()) {
            LOGGER.info("The input changes require a full rebuild for incremental {}.", (Object)work.getDisplayName());
        }
        return inputChanges;
    }
}

