/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.execution.steps;

import java.util.Formatter;
import java.util.List;
import java.util.Optional;
import org.gradle.caching.internal.origin.OriginMetadata;
import org.gradle.internal.Try;
import org.gradle.internal.execution.CurrentSnapshotResult;
import org.gradle.internal.execution.ExecutionOutcome;
import org.gradle.internal.execution.IncrementalChangesContext;
import org.gradle.internal.execution.Result;
import org.gradle.internal.execution.Step;
import org.gradle.internal.execution.UnitOfWork;
import org.gradle.internal.execution.UpToDateResult;
import org.gradle.internal.execution.history.AfterPreviousExecutionState;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableList;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableSortedMap;
import org.gradle.internal.impldep.org.apache.commons.lang.StringUtils;
import org.gradle.internal.snapshot.FileSystemSnapshot;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SkipUpToDateStep<C extends IncrementalChangesContext>
implements Step<C, UpToDateResult> {
    private static final Logger LOGGER = LoggerFactory.getLogger(SkipUpToDateStep.class);
    private static final ImmutableList<String> CHANGE_TRACKING_DISABLED = ImmutableList.of("Change tracking is disabled.");
    private final Step<? super C, ? extends CurrentSnapshotResult> delegate;

    public SkipUpToDateStep(Step<? super C, ? extends CurrentSnapshotResult> delegate) {
        this.delegate = delegate;
    }

    @Override
    public UpToDateResult execute(final UnitOfWork work, C context) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Determining if {} is up-to-date", (Object)work.getDisplayName());
        }
        return context.getChanges().map(changes -> {
            ImmutableList<String> reasons = changes.getAllChangeMessages();
            if (reasons.isEmpty()) {
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.info("Skipping {} as it is up-to-date.", (Object)work.getDisplayName());
                }
                final AfterPreviousExecutionState afterPreviousExecutionState = context.getAfterPreviousExecutionState().get();
                return new UpToDateResult((IncrementalChangesContext)context){
                    final /* synthetic */ IncrementalChangesContext val$context;
                    {
                        this.val$context = incrementalChangesContext;
                    }

                    @Override
                    public ImmutableList<String> getExecutionReasons() {
                        return ImmutableList.of();
                    }

                    @Override
                    public ImmutableSortedMap<String, FileSystemSnapshot> getOutputFilesProduceByWork() {
                        return afterPreviousExecutionState.getOutputFilesProducedByWork();
                    }

                    @Override
                    public Optional<OriginMetadata> getReusedOutputOriginMetadata() {
                        return Optional.of(afterPreviousExecutionState.getOriginMetadata());
                    }

                    @Override
                    public Try<Result.ExecutionResult> getExecutionResult() {
                        return Try.successful(new Result.ExecutionResult(){

                            @Override
                            public ExecutionOutcome getOutcome() {
                                return ExecutionOutcome.UP_TO_DATE;
                            }

                            @Override
                            public Object getOutput() {
                                return work.loadRestoredOutput(val$context.getWorkspace());
                            }
                        });
                    }
                };
            }
            return this.executeBecause(work, reasons, context);
        }).orElseGet(() -> this.executeBecause(work, CHANGE_TRACKING_DISABLED, context));
    }

    private UpToDateResult executeBecause(UnitOfWork work, final ImmutableList<String> reasons, C context) {
        this.logExecutionReasons(reasons, work);
        final CurrentSnapshotResult result = this.delegate.execute(work, context);
        return new UpToDateResult(){

            @Override
            public ImmutableList<String> getExecutionReasons() {
                return reasons;
            }

            @Override
            public ImmutableSortedMap<String, FileSystemSnapshot> getOutputFilesProduceByWork() {
                return result.getOutputFilesProduceByWork();
            }

            @Override
            public Optional<OriginMetadata> getReusedOutputOriginMetadata() {
                return result.isReused() ? Optional.of(result.getOriginMetadata()) : Optional.empty();
            }

            @Override
            public Try<Result.ExecutionResult> getExecutionResult() {
                return result.getExecutionResult();
            }
        };
    }

    private void logExecutionReasons(List<String> reasons, UnitOfWork work) {
        if (LOGGER.isInfoEnabled()) {
            Formatter formatter = new Formatter();
            formatter.format("%s is not up-to-date because:", StringUtils.capitalize(work.getDisplayName()));
            for (String message2 : reasons) {
                formatter.format("%n  %s", message2);
            }
            LOGGER.info(formatter.toString());
        }
    }
}

