/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.execution.steps;

import java.util.AbstractCollection;
import java.util.Collection;
import java.util.stream.Collectors;
import org.gradle.api.InvalidUserDataException;
import org.gradle.internal.execution.Context;
import org.gradle.internal.execution.Result;
import org.gradle.internal.execution.Step;
import org.gradle.internal.execution.UnitOfWork;
import org.gradle.internal.execution.WorkValidationException;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableList;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableMultimap;
import org.gradle.internal.reflect.MessageFormattingTypeValidationContext;
import org.gradle.internal.reflect.TypeValidationContext;
import org.gradle.model.internal.type.ModelType;

public class ValidateStep<C extends Context, R extends Result>
implements Step<C, R> {
    private final ValidationWarningReporter warningReporter;
    private final Step<? super C, ? extends R> delegate;

    public ValidateStep(ValidationWarningReporter warningReporter, Step<? super C, ? extends R> delegate) {
        this.warningReporter = warningReporter;
        this.delegate = delegate;
    }

    @Override
    public R execute(UnitOfWork work, C context) {
        DefaultWorkValidationContext validationContext = new DefaultWorkValidationContext();
        work.validate(validationContext);
        ImmutableMultimap<TypeValidationContext.Severity, String> problems = validationContext.getProblems();
        Collection warnings = problems.get((Object)TypeValidationContext.Severity.WARNING);
        Collection errors = problems.get((Object)TypeValidationContext.Severity.ERROR);
        warnings.forEach(this.warningReporter::reportValidationWarning);
        if (!((AbstractCollection)errors).isEmpty()) {
            throw new WorkValidationException(String.format("%s found with the configuration of %s (%s).", ((AbstractCollection)errors).size() == 1 ? "A problem was" : "Some problems were", work.getDisplayName(), ValidateStep.describeTypesChecked(validationContext.getTypes())), errors.stream().limit(5L).sorted().map(InvalidUserDataException::new).collect(Collectors.toList()));
        }
        return this.delegate.execute(work, context);
    }

    private static String describeTypesChecked(ImmutableList<Class<?>> types) {
        return types.size() == 1 ? "type '" + ValidateStep.getTypeDisplayName((Class)types.get(0)) + "'" : "types '" + types.stream().map(ValidateStep::getTypeDisplayName).collect(Collectors.joining("', '")) + "'";
    }

    private static String getTypeDisplayName(Class<?> type) {
        return ModelType.of(type).getDisplayName();
    }

    private static class DefaultWorkValidationContext
    implements UnitOfWork.WorkValidationContext {
        private final ImmutableMultimap.Builder<TypeValidationContext.Severity, String> problems = ImmutableMultimap.builder();
        private final ImmutableList.Builder<Class<?>> types = ImmutableList.builder();

        private DefaultWorkValidationContext() {
        }

        @Override
        public TypeValidationContext createContextFor(Class<?> type, final boolean cacheable) {
            this.types.add((Object)type);
            return new MessageFormattingTypeValidationContext(null){

                @Override
                protected void recordProblem(TypeValidationContext.Severity severity, String message2) {
                    if (severity == TypeValidationContext.Severity.CACHEABILITY_WARNING && !cacheable) {
                        return;
                    }
                    problems.put(severity.toReportableSeverity(), message2);
                }
            };
        }

        public ImmutableMultimap<TypeValidationContext.Severity, String> getProblems() {
            return this.problems.build();
        }

        public ImmutableList<Class<?>> getTypes() {
            return this.types.build();
        }
    }

    public static interface ValidationWarningReporter {
        public void reportValidationWarning(String var1);
    }
}

