/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.file;

import java.io.File;
import java.util.List;
import org.gradle.internal.file.DefaultFileHierarchySet;
import org.gradle.internal.file.FileHierarchySet;
import org.gradle.internal.file.ReservedFileSystemLocation;
import org.gradle.internal.file.ReservedFileSystemLocationRegistry;
import org.gradle.internal.impldep.com.google.common.base.Function;
import org.gradle.internal.impldep.com.google.common.collect.Iterables;

public class DefaultReservedFileSystemLocationRegistry
implements ReservedFileSystemLocationRegistry {
    private final FileHierarchySet reservedFileSystemLocations;

    public DefaultReservedFileSystemLocationRegistry(List<ReservedFileSystemLocation> registeredReservedFileSystemLocations) {
        this.reservedFileSystemLocations = DefaultFileHierarchySet.of(Iterables.transform(registeredReservedFileSystemLocations, new Function<ReservedFileSystemLocation, File>(){

            @Override
            public File apply(ReservedFileSystemLocation input) {
                return input.getReservedFileSystemLocation().get().getAsFile();
            }
        }));
    }

    @Override
    public boolean isInReservedFileSystemLocation(File location) {
        return this.reservedFileSystemLocations.contains(location);
    }
}

