/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.com.amazonaws.services.s3.internal;

import java.io.InputStream;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.gradle.internal.impldep.com.amazonaws.AmazonWebServiceResponse;
import org.gradle.internal.impldep.com.amazonaws.http.HttpResponse;
import org.gradle.internal.impldep.com.amazonaws.services.s3.internal.AbstractS3ResponseHandler;
import org.gradle.internal.impldep.com.amazonaws.transform.Unmarshaller;

public class S3XmlResponseHandler<T>
extends AbstractS3ResponseHandler<T> {
    private Unmarshaller<T, InputStream> responseUnmarshaller;
    private static final Log log = LogFactory.getLog("org.gradle.internal.impldep.com.amazonaws.request");
    private Map<String, String> responseHeaders;

    public S3XmlResponseHandler(Unmarshaller<T, InputStream> responseUnmarshaller) {
        this.responseUnmarshaller = responseUnmarshaller;
    }

    @Override
    public AmazonWebServiceResponse<T> handle(HttpResponse response) throws Exception {
        AmazonWebServiceResponse<T> awsResponse = this.parseResponseMetadata(response);
        this.responseHeaders = response.getHeaders();
        if (this.responseUnmarshaller != null) {
            log.trace("Beginning to parse service response XML");
            T result = this.responseUnmarshaller.unmarshall(response.getContent());
            log.trace("Done parsing service response XML");
            awsResponse.setResult(result);
        }
        return awsResponse;
    }

    public Map<String, String> getResponseHeaders() {
        return this.responseHeaders;
    }
}

