/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.com.amazonaws.services.s3.model.transform;

import java.io.ByteArrayInputStream;
import java.nio.ByteBuffer;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import org.gradle.internal.impldep.com.amazonaws.annotation.SdkInternalApi;
import org.gradle.internal.impldep.com.amazonaws.services.s3.internal.eventstreaming.HeaderType;
import org.gradle.internal.impldep.com.amazonaws.services.s3.internal.eventstreaming.HeaderValue;
import org.gradle.internal.impldep.com.amazonaws.services.s3.internal.eventstreaming.Message;
import org.gradle.internal.impldep.com.amazonaws.services.s3.model.SelectObjectContentEvent;
import org.gradle.internal.impldep.com.amazonaws.services.s3.model.SelectObjectContentEventException;
import org.gradle.internal.impldep.com.amazonaws.services.s3.model.transform.ProgressStaxUnmarshaller;
import org.gradle.internal.impldep.com.amazonaws.services.s3.model.transform.StatsStaxUnmarshaller;
import org.gradle.internal.impldep.com.amazonaws.transform.StaxUnmarshallerContext;
import org.gradle.internal.impldep.com.amazonaws.util.XmlUtils;

@SdkInternalApi
public abstract class SelectObjectContentEventUnmarshaller {
    public static SelectObjectContentEvent unmarshalMessage(Message message2) {
        String messageType = SelectObjectContentEventUnmarshaller.getStringHeader(message2, ":message-type");
        if ("error".equals(messageType)) {
            throw SelectObjectContentEventUnmarshaller.unmarshalErrorMessage(message2);
        }
        if ("event".equals(messageType)) {
            return SelectObjectContentEventUnmarshaller.unmarshalEventMessage(message2);
        }
        throw new SelectObjectContentEventException("Service returned unknown message type: " + messageType);
    }

    private static SelectObjectContentEventException unmarshalErrorMessage(Message message2) {
        String errorCode = SelectObjectContentEventUnmarshaller.getStringHeader(message2, ":error-code");
        String errorMessage = SelectObjectContentEventUnmarshaller.getStringHeader(message2, ":error-message");
        SelectObjectContentEventException exception = new SelectObjectContentEventException("S3 returned an error: " + errorMessage + " (" + errorCode + ")");
        exception.setErrorCode(errorCode);
        exception.setErrorMessage(errorMessage);
        return exception;
    }

    private static SelectObjectContentEvent unmarshalEventMessage(Message message2) {
        String eventType = SelectObjectContentEventUnmarshaller.getStringHeader(message2, ":event-type");
        try {
            return SelectObjectContentEventUnmarshaller.forEventType(eventType).unmarshal(message2);
        }
        catch (Exception e) {
            throw new SelectObjectContentEventException("Failed to read response event of type " + eventType, e);
        }
    }

    public static SelectObjectContentEventUnmarshaller forEventType(String eventType) {
        if ("Records".equals(eventType)) {
            return new RecordsEventUnmarshaller();
        }
        if ("Stats".equals(eventType)) {
            return new StatsEventUnmarshaller();
        }
        if ("Progress".equals(eventType)) {
            return new ProgressEventUnmarshaller();
        }
        if ("Cont".equals(eventType)) {
            return new ContinuationEventUnmarshaller();
        }
        if ("End".equals(eventType)) {
            return new EndEventUnmarshaller();
        }
        return new UnknownEventUnmarshaller();
    }

    private static String getStringHeader(Message message2, String headerName) {
        HeaderValue header = message2.getHeaders().get(headerName);
        if (header == null) {
            throw new SelectObjectContentEventException("Unexpected lack of '" + headerName + "' header from service.");
        }
        if (header.getType() != HeaderType.STRING) {
            throw new SelectObjectContentEventException("Unexpected non-string '" + headerName + "' header: " + (Object)((Object)header.getType()));
        }
        return header.getString();
    }

    public abstract SelectObjectContentEvent unmarshal(Message var1) throws Exception;

    private static StaxUnmarshallerContext payloadUnmarshaller(Message message2) throws XMLStreamException {
        ByteArrayInputStream payloadStream = new ByteArrayInputStream(message2.getPayload());
        XMLEventReader xmlEventReader = XmlUtils.getXmlInputFactory().createXMLEventReader(payloadStream);
        return new StaxUnmarshallerContext(xmlEventReader);
    }

    public static class UnknownEventUnmarshaller
    extends SelectObjectContentEventUnmarshaller {
        @Override
        public SelectObjectContentEvent unmarshal(Message message2) {
            return new SelectObjectContentEvent();
        }
    }

    public static class EndEventUnmarshaller
    extends SelectObjectContentEventUnmarshaller {
        @Override
        public SelectObjectContentEvent.EndEvent unmarshal(Message message2) {
            return new SelectObjectContentEvent.EndEvent();
        }
    }

    public static class ContinuationEventUnmarshaller
    extends SelectObjectContentEventUnmarshaller {
        @Override
        public SelectObjectContentEvent.ContinuationEvent unmarshal(Message message2) {
            return new SelectObjectContentEvent.ContinuationEvent();
        }
    }

    public static class ProgressEventUnmarshaller
    extends SelectObjectContentEventUnmarshaller {
        @Override
        public SelectObjectContentEvent.ProgressEvent unmarshal(Message message2) throws Exception {
            StaxUnmarshallerContext context = SelectObjectContentEventUnmarshaller.payloadUnmarshaller(message2);
            return new SelectObjectContentEvent.ProgressEvent().withDetails(ProgressStaxUnmarshaller.getInstance().unmarshall(context));
        }
    }

    public static class StatsEventUnmarshaller
    extends SelectObjectContentEventUnmarshaller {
        @Override
        public SelectObjectContentEvent.StatsEvent unmarshal(Message message2) throws Exception {
            StaxUnmarshallerContext context = SelectObjectContentEventUnmarshaller.payloadUnmarshaller(message2);
            return new SelectObjectContentEvent.StatsEvent().withDetails(StatsStaxUnmarshaller.getInstance().unmarshall(context));
        }
    }

    public static class RecordsEventUnmarshaller
    extends SelectObjectContentEventUnmarshaller {
        @Override
        public SelectObjectContentEvent.RecordsEvent unmarshal(Message message2) {
            return new SelectObjectContentEvent.RecordsEvent().withPayload(ByteBuffer.wrap(message2.getPayload()));
        }
    }
}

