/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.com.amazonaws.services.s3.transfer.internal;

import java.util.Collection;
import java.util.concurrent.atomic.AtomicBoolean;
import org.gradle.internal.impldep.com.amazonaws.event.ProgressEventType;
import org.gradle.internal.impldep.com.amazonaws.event.ProgressListenerChain;
import org.gradle.internal.impldep.com.amazonaws.services.s3.transfer.Transfer;
import org.gradle.internal.impldep.com.amazonaws.services.s3.transfer.TransferProgress;
import org.gradle.internal.impldep.com.amazonaws.services.s3.transfer.internal.AbstractTransfer;

public abstract class MultipleFileTransfer<T extends Transfer>
extends AbstractTransfer {
    protected final Collection<? extends T> subTransfers;
    private AtomicBoolean subTransferStarted = new AtomicBoolean(false);

    MultipleFileTransfer(String description, TransferProgress transferProgress, ProgressListenerChain progressListenerChain, Collection<? extends T> subTransfers) {
        super(description, transferProgress, progressListenerChain);
        this.subTransfers = subTransfers;
    }

    public void collateFinalState() {
        boolean seenCanceled = false;
        for (Transfer download : this.subTransfers) {
            if (download.getState() == Transfer.TransferState.Failed) {
                this.setState(Transfer.TransferState.Failed);
                return;
            }
            if (download.getState() != Transfer.TransferState.Canceled) continue;
            seenCanceled = true;
        }
        if (seenCanceled) {
            this.setState(Transfer.TransferState.Canceled);
        } else {
            this.setState(Transfer.TransferState.Completed);
        }
    }

    @Override
    public void setState(Transfer.TransferState state2) {
        super.setState(state2);
        switch (state2) {
            case Waiting: {
                this.fireProgressEvent(ProgressEventType.TRANSFER_PREPARING_EVENT);
                break;
            }
            case InProgress: {
                if (!this.subTransferStarted.compareAndSet(false, true)) break;
                this.fireProgressEvent(ProgressEventType.TRANSFER_STARTED_EVENT);
                break;
            }
            case Completed: {
                this.fireProgressEvent(ProgressEventType.TRANSFER_COMPLETED_EVENT);
                break;
            }
            case Canceled: {
                this.fireProgressEvent(ProgressEventType.TRANSFER_CANCELED_EVENT);
                break;
            }
            case Failed: {
                this.fireProgressEvent(ProgressEventType.TRANSFER_FAILED_EVENT);
                break;
            }
        }
    }
}

