/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.com.beust.jcommander;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.gradle.internal.impldep.com.beust.jcommander.DynamicParameter;
import org.gradle.internal.impldep.com.beust.jcommander.IParameterValidator;
import org.gradle.internal.impldep.com.beust.jcommander.IParameterValidator2;
import org.gradle.internal.impldep.com.beust.jcommander.IValueValidator;
import org.gradle.internal.impldep.com.beust.jcommander.JCommander;
import org.gradle.internal.impldep.com.beust.jcommander.Parameter;
import org.gradle.internal.impldep.com.beust.jcommander.ParameterException;
import org.gradle.internal.impldep.com.beust.jcommander.Parameterized;
import org.gradle.internal.impldep.com.beust.jcommander.Parameters;
import org.gradle.internal.impldep.com.beust.jcommander.ResourceBundle;
import org.gradle.internal.impldep.com.beust.jcommander.SubParameter;
import org.gradle.internal.impldep.com.beust.jcommander.WrappedParameter;
import org.gradle.internal.impldep.com.beust.jcommander.validators.NoValidator;
import org.gradle.internal.impldep.com.beust.jcommander.validators.NoValueValidator;

public class ParameterDescription {
    private Object object;
    private WrappedParameter wrappedParameter;
    private Parameter parameterAnnotation;
    private DynamicParameter dynamicParameterAnnotation;
    private Parameterized parameterized;
    private boolean assigned = false;
    private java.util.ResourceBundle bundle;
    private String description;
    private JCommander jCommander;
    private Object defaultObject;
    private String longestName = "";

    public ParameterDescription(Object object, DynamicParameter dynamicParameter, Parameterized parameterized, java.util.ResourceBundle resourceBundle, JCommander jCommander) {
        if (!Map.class.isAssignableFrom(parameterized.getType())) {
            throw new ParameterException("@DynamicParameter " + parameterized.getName() + " should be of type Map but is " + parameterized.getType().getName());
        }
        this.dynamicParameterAnnotation = dynamicParameter;
        this.wrappedParameter = new WrappedParameter(this.dynamicParameterAnnotation);
        this.init(object, parameterized, resourceBundle, jCommander);
    }

    public ParameterDescription(Object object, Parameter parameter, Parameterized parameterized, java.util.ResourceBundle resourceBundle, JCommander jCommander) {
        this.parameterAnnotation = parameter;
        this.wrappedParameter = new WrappedParameter(this.parameterAnnotation);
        this.init(object, parameterized, resourceBundle, jCommander);
    }

    private java.util.ResourceBundle findResourceBundle(Object object) {
        java.util.ResourceBundle resourceBundle = null;
        Parameters parameters = object.getClass().getAnnotation(Parameters.class);
        if (parameters != null && !this.isEmpty(parameters.resourceBundle())) {
            resourceBundle = java.util.ResourceBundle.getBundle(parameters.resourceBundle(), Locale.getDefault());
        } else {
            ResourceBundle resourceBundle2 = object.getClass().getAnnotation(ResourceBundle.class);
            if (resourceBundle2 != null && !this.isEmpty(resourceBundle2.value())) {
                resourceBundle = java.util.ResourceBundle.getBundle(resourceBundle2.value(), Locale.getDefault());
            }
        }
        return resourceBundle;
    }

    private boolean isEmpty(String string2) {
        return string2 == null || "".equals(string2);
    }

    private void initDescription(String string2, String string3, String[] stringArray) {
        this.description = string2;
        if (!"".equals(string3) && this.bundle != null) {
            this.description = this.bundle.getString(string3);
        }
        for (String string4 : stringArray) {
            if (string4.length() <= this.longestName.length()) continue;
            this.longestName = string4;
        }
    }

    private void init(Object object, Parameterized parameterized, java.util.ResourceBundle resourceBundle, JCommander jCommander) {
        this.object = object;
        this.parameterized = parameterized;
        this.bundle = resourceBundle;
        if (this.bundle == null) {
            this.bundle = this.findResourceBundle(object);
        }
        this.jCommander = jCommander;
        if (this.parameterAnnotation != null) {
            String string2 = Enum.class.isAssignableFrom(parameterized.getType()) && this.parameterAnnotation.description().isEmpty() ? "Options: " + EnumSet.allOf(parameterized.getType()) : this.parameterAnnotation.description();
            this.initDescription(string2, this.parameterAnnotation.descriptionKey(), this.parameterAnnotation.names());
        } else if (this.dynamicParameterAnnotation != null) {
            this.initDescription(this.dynamicParameterAnnotation.description(), this.dynamicParameterAnnotation.descriptionKey(), this.dynamicParameterAnnotation.names());
        } else {
            throw new AssertionError((Object)"Shound never happen");
        }
        try {
            this.defaultObject = parameterized.get(object);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.defaultObject != null && this.parameterAnnotation != null) {
            this.validateDefaultValues(this.parameterAnnotation.names());
        }
    }

    private void validateDefaultValues(String[] stringArray) {
        String string2 = stringArray.length > 0 ? stringArray[0] : "";
        this.validateValueParameter(string2, this.defaultObject);
    }

    public String getLongestName() {
        return this.longestName;
    }

    public Object getDefault() {
        return this.defaultObject;
    }

    public String getDescription() {
        return this.description;
    }

    public Object getObject() {
        return this.object;
    }

    public String getNames() {
        StringBuilder stringBuilder = new StringBuilder();
        String[] stringArray = this.wrappedParameter.names();
        for (int i = 0; i < stringArray.length; ++i) {
            if (i > 0) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(stringArray[i]);
        }
        return stringBuilder.toString();
    }

    public WrappedParameter getParameter() {
        return this.wrappedParameter;
    }

    public Parameterized getParameterized() {
        return this.parameterized;
    }

    private boolean isMultiOption() {
        Class<?> clazz = this.parameterized.getType();
        return clazz.equals(List.class) || clazz.equals(Set.class) || this.parameterized.isDynamicParameter();
    }

    public void addValue(String string2) {
        this.addValue(string2, false);
    }

    public boolean isAssigned() {
        return this.assigned;
    }

    public void setAssigned(boolean bl) {
        this.assigned = bl;
    }

    public void addValue(String string2, boolean bl) {
        this.addValue(null, string2, bl, true, -1);
    }

    Object addValue(String string2, String string3, boolean bl, boolean bl2, int n) {
        Collection<Object> collection;
        boolean bl3;
        ParameterDescription.p("Adding " + (bl ? "default " : "") + "value:" + string3 + " to parameter:" + this.parameterized.getName());
        if (string2 == null) {
            string2 = this.wrappedParameter.names()[0];
        }
        if (n == 0 && this.assigned && !this.isMultiOption() && !this.jCommander.isParameterOverwritingAllowed() || this.isNonOverwritableForced()) {
            throw new ParameterException("Can only specify option " + string2 + " once.");
        }
        if (bl2) {
            this.validateParameter(string2, string3);
        }
        Class<?> clazz = this.parameterized.getType();
        Object object = this.jCommander.convertValue(this.getParameterized(), this.getParameterized().getType(), string2, string3);
        if (bl2) {
            this.validateValueParameter(string2, object);
        }
        if (bl3 = Collection.class.isAssignableFrom(clazz)) {
            Collection<Object> collection2 = (Collection<Object>)this.parameterized.get(this.object);
            if (collection2 == null || this.fieldIsSetForTheFirstTime(bl)) {
                collection2 = this.newCollection(clazz);
                this.parameterized.set(this.object, collection2);
            }
            if (object instanceof Collection) {
                collection2.addAll((Collection)object);
            } else {
                collection2.add(object);
            }
            collection = collection2;
        } else {
            List<SubParameterIndex> list = this.findSubParameters(clazz);
            if (!list.isEmpty()) {
                collection = this.handleSubParameters(string3, n, clazz, list);
            } else {
                this.wrappedParameter.addValue(this.parameterized, this.object, object);
                collection = object;
            }
        }
        if (!bl) {
            this.assigned = true;
        }
        return collection;
    }

    private Object handleSubParameters(String string2, int n, Class<?> clazz, List<SubParameterIndex> list) {
        Object object;
        SubParameterIndex subParameterIndex = null;
        for (SubParameterIndex subParameterIndex2 : list) {
            if (subParameterIndex2.order != n) continue;
            subParameterIndex = subParameterIndex2;
            break;
        }
        if (subParameterIndex != null) {
            Object object2 = this.parameterized.get(this.object);
            try {
                if (object2 == null) {
                    object2 = clazz.newInstance();
                    this.parameterized.set(this.object, object2);
                }
                this.wrappedParameter.addValue(this.parameterized, object2, string2, subParameterIndex.field);
                object = object2;
            }
            catch (IllegalAccessException | InstantiationException reflectiveOperationException) {
                throw new ParameterException("Couldn't instantiate " + clazz, reflectiveOperationException);
            }
        } else {
            throw new ParameterException("Couldn't find where to assign parameter " + string2 + " in " + clazz);
        }
        return object;
    }

    public Parameter getParameterAnnotation() {
        return this.parameterAnnotation;
    }

    private List<SubParameterIndex> findSubParameters(Class<?> clazz) {
        ArrayList<SubParameterIndex> arrayList = new ArrayList<SubParameterIndex>();
        for (Field field : clazz.getDeclaredFields()) {
            SubParameter subParameter = field.getAnnotation(SubParameter.class);
            if (subParameter == null) continue;
            SubParameter subParameter2 = subParameter;
            arrayList.add(new SubParameterIndex(subParameter2.order(), field));
        }
        return arrayList;
    }

    private void validateParameter(String string2, String string3) {
        Class<? extends IParameterValidator>[] classArray = this.wrappedParameter.validateWith();
        if (classArray != null && classArray.length > 0) {
            for (Class<? extends IParameterValidator> clazz : classArray) {
                ParameterDescription.validateParameter(this, clazz, string2, string3);
            }
        }
    }

    void validateValueParameter(String string2, Object object) {
        Class<? extends IValueValidator>[] classArray = this.wrappedParameter.validateValueWith();
        if (classArray != null && classArray.length > 0) {
            for (Class<? extends IValueValidator> clazz : classArray) {
                ParameterDescription.validateValueParameter(clazz, string2, object);
            }
        }
    }

    public static void validateValueParameter(Class<? extends IValueValidator> clazz, String string2, Object object) {
        try {
            if (clazz != NoValueValidator.class) {
                ParameterDescription.p("Validating value parameter:" + string2 + " value:" + object + " validator:" + clazz);
            }
            clazz.newInstance().validate(string2, object);
        }
        catch (IllegalAccessException | InstantiationException reflectiveOperationException) {
            throw new ParameterException("Can't instantiate validator:" + reflectiveOperationException);
        }
    }

    public static void validateParameter(ParameterDescription parameterDescription, Class<? extends IParameterValidator> clazz, String string2, String string3) {
        try {
            if (clazz != NoValidator.class) {
                ParameterDescription.p("Validating parameter:" + string2 + " value:" + string3 + " validator:" + clazz);
            }
            clazz.newInstance().validate(string2, string3);
            if (IParameterValidator2.class.isAssignableFrom(clazz)) {
                IParameterValidator2 iParameterValidator2 = (IParameterValidator2)clazz.newInstance();
                iParameterValidator2.validate(string2, string3, parameterDescription);
            }
        }
        catch (IllegalAccessException | InstantiationException reflectiveOperationException) {
            throw new ParameterException("Can't instantiate validator:" + reflectiveOperationException);
        }
        catch (ParameterException parameterException) {
            throw parameterException;
        }
        catch (Exception exception) {
            throw new ParameterException(exception);
        }
    }

    private Collection<Object> newCollection(Class<?> clazz) {
        if (SortedSet.class.isAssignableFrom(clazz)) {
            return new TreeSet<Object>();
        }
        if (LinkedHashSet.class.isAssignableFrom(clazz)) {
            return new LinkedHashSet<Object>();
        }
        if (Set.class.isAssignableFrom(clazz)) {
            return new HashSet<Object>();
        }
        if (List.class.isAssignableFrom(clazz)) {
            return new ArrayList<Object>();
        }
        throw new ParameterException("Parameters of Collection type '" + clazz.getSimpleName() + "' are not supported. Please use List or Set instead.");
    }

    private boolean fieldIsSetForTheFirstTime(boolean bl) {
        return !bl && !this.assigned;
    }

    private static void p(String string2) {
        if (System.getProperty("jcommander.debug") != null) {
            JCommander.getConsole().println("[ParameterDescription] " + string2);
        }
    }

    public String toString() {
        return "[ParameterDescription " + this.parameterized.getName() + "]";
    }

    public boolean isDynamicParameter() {
        return this.dynamicParameterAnnotation != null;
    }

    public boolean isHelp() {
        return this.wrappedParameter.isHelp();
    }

    public boolean isNonOverwritableForced() {
        return this.wrappedParameter.isNonOverwritableForced();
    }

    class SubParameterIndex {
        int order = -1;
        Field field;

        public SubParameterIndex(int n, Field field) {
            this.order = n;
            this.field = field;
        }
    }
}

