/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.gnu.trove;

import java.util.ConcurrentModificationException;
import org.gradle.internal.impldep.gnu.trove.TIterator;
import org.gradle.internal.impldep.gnu.trove.TObjectFloatHashMap;
import org.gradle.internal.impldep.gnu.trove.TObjectHash;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TObjectFloatIterator<K>
extends TIterator {
    private final TObjectFloatHashMap<K> _map;

    public TObjectFloatIterator(TObjectFloatHashMap<K> map) {
        super(map);
        this._map = map;
    }

    @Override
    protected final int nextIndex() {
        if (this._expectedSize != this._hash.size()) {
            throw new ConcurrentModificationException();
        }
        Object[] set2 = this._map._set;
        int i = this._index;
        while (i-- > 0 && (set2[i] == null || set2[i] == TObjectHash.REMOVED)) {
        }
        return i;
    }

    public void advance() {
        this.moveToNextIndex();
    }

    public K key() {
        return (K)this._map._set[this._index];
    }

    public float value() {
        return this._map._values[this._index];
    }

    public float setValue(float val) {
        float old = this.value();
        this._map._values[this._index] = val;
        return old;
    }
}

