/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.org.apache.http.impl.entity;

import org.gradle.internal.impldep.org.apache.http.HttpException;
import org.gradle.internal.impldep.org.apache.http.HttpMessage;
import org.gradle.internal.impldep.org.apache.http.ProtocolException;
import org.gradle.internal.impldep.org.apache.http.annotation.Contract;
import org.gradle.internal.impldep.org.apache.http.annotation.ThreadingBehavior;
import org.gradle.internal.impldep.org.apache.http.entity.ContentLengthStrategy;
import org.gradle.internal.impldep.org.apache.http.impl.entity.LaxContentLengthStrategy;

@Contract(threading=ThreadingBehavior.IMMUTABLE_CONDITIONAL)
public class DisallowIdentityContentLengthStrategy
implements ContentLengthStrategy {
    public static final DisallowIdentityContentLengthStrategy INSTANCE = new DisallowIdentityContentLengthStrategy(new LaxContentLengthStrategy(0));
    private final ContentLengthStrategy contentLengthStrategy;

    public DisallowIdentityContentLengthStrategy(ContentLengthStrategy contentLengthStrategy) {
        this.contentLengthStrategy = contentLengthStrategy;
    }

    @Override
    public long determineLength(HttpMessage message2) throws HttpException {
        long result = this.contentLengthStrategy.determineLength(message2);
        if (result == -1L) {
            throw new ProtocolException("Identity transfer encoding cannot be used");
        }
        return result;
    }
}

