/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.org.apache.http.impl.entity;

import org.gradle.internal.impldep.org.apache.http.Header;
import org.gradle.internal.impldep.org.apache.http.HttpException;
import org.gradle.internal.impldep.org.apache.http.HttpMessage;
import org.gradle.internal.impldep.org.apache.http.HttpVersion;
import org.gradle.internal.impldep.org.apache.http.ProtocolException;
import org.gradle.internal.impldep.org.apache.http.annotation.Contract;
import org.gradle.internal.impldep.org.apache.http.annotation.ThreadingBehavior;
import org.gradle.internal.impldep.org.apache.http.entity.ContentLengthStrategy;
import org.gradle.internal.impldep.org.apache.http.util.Args;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class StrictContentLengthStrategy
implements ContentLengthStrategy {
    public static final StrictContentLengthStrategy INSTANCE = new StrictContentLengthStrategy();
    private final int implicitLen;

    public StrictContentLengthStrategy(int implicitLen) {
        this.implicitLen = implicitLen;
    }

    public StrictContentLengthStrategy() {
        this(-1);
    }

    @Override
    public long determineLength(HttpMessage message2) throws HttpException {
        Args.notNull(message2, "HTTP message");
        Header transferEncodingHeader = message2.getFirstHeader("Transfer-Encoding");
        if (transferEncodingHeader != null) {
            String s = transferEncodingHeader.getValue();
            if ("chunked".equalsIgnoreCase(s)) {
                if (message2.getProtocolVersion().lessEquals(HttpVersion.HTTP_1_0)) {
                    throw new ProtocolException("Chunked transfer encoding not allowed for " + message2.getProtocolVersion());
                }
                return -2L;
            }
            if ("identity".equalsIgnoreCase(s)) {
                return -1L;
            }
            throw new ProtocolException("Unsupported transfer encoding: " + s);
        }
        Header contentLengthHeader = message2.getFirstHeader("Content-Length");
        if (contentLengthHeader != null) {
            String s = contentLengthHeader.getValue();
            try {
                long len = Long.parseLong(s);
                if (len < 0L) {
                    throw new ProtocolException("Negative content length: " + s);
                }
                return len;
            }
            catch (NumberFormatException e) {
                throw new ProtocolException("Invalid content length: " + s);
            }
        }
        return this.implicitLen;
    }
}

