/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.org.apache.ivy.ant;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.Reference;
import org.gradle.internal.impldep.org.apache.ivy.Ivy;
import org.gradle.internal.impldep.org.apache.ivy.ant.AntMessageLogger;
import org.gradle.internal.impldep.org.apache.ivy.ant.IvyAntSettings;
import org.gradle.internal.impldep.org.apache.ivy.core.IvyContext;
import org.gradle.internal.impldep.org.apache.ivy.core.module.descriptor.ModuleDescriptor;
import org.gradle.internal.impldep.org.apache.ivy.core.report.ResolveReport;
import org.gradle.internal.impldep.org.apache.ivy.core.settings.IvySettings;
import org.gradle.internal.impldep.org.apache.ivy.util.Message;
import org.gradle.internal.impldep.org.apache.ivy.util.StringUtils;

public abstract class IvyTask
extends Task {
    public static final String ANT_PROJECT_CONTEXT_KEY = "ant-project";
    private Boolean validate = null;
    private Reference antIvyEngineRef = null;
    private static final DateFormat DATE_FORMAT = new SimpleDateFormat("yyyyMMddHHmmss");

    protected boolean doValidate(IvySettings ivy) {
        if (this.validate != null) {
            return this.validate;
        }
        return ivy.doValidate();
    }

    public boolean isValidate() {
        return this.validate == null ? true : this.validate;
    }

    public void setValidate(boolean validate) {
        this.validate = validate;
    }

    public void setSettingsRef(Reference ref) {
        this.antIvyEngineRef = ref;
    }

    public Reference getSettingsRef() {
        return this.antIvyEngineRef;
    }

    protected IvySettings getSettings() {
        return this.getIvyInstance().getSettings();
    }

    protected Ivy getIvyInstance() {
        IvyAntSettings antIvyEngine;
        if (this.antIvyEngineRef != null) {
            antIvyEngine = this.antIvyEngineRef.getReferencedObject(this.getProject());
            if (!antIvyEngine.getClass().getName().equals(IvyAntSettings.class.getName())) {
                throw new BuildException(this.antIvyEngineRef.getRefId() + " doesn't reference an ivy:settings", this.getLocation());
            }
            if (!(antIvyEngine instanceof IvyAntSettings)) {
                throw new BuildException(this.antIvyEngineRef.getRefId() + " has been defined in a different classloader.  " + "Please use the same loader when defining your task, or " + "redeclare your ivy:settings in this classloader", this.getLocation());
            }
        } else {
            antIvyEngine = IvyAntSettings.getDefaultInstance(this);
        }
        Ivy ivy = antIvyEngine.getConfiguredIvyInstance(this);
        AntMessageLogger.register(this, ivy);
        return ivy;
    }

    protected void setResolved(ResolveReport report, boolean keep) {
        ModuleDescriptor md = report.getModuleDescriptor();
        String[] confs = report.getConfigurations();
        if (keep) {
            this.getProject().addReference("ivy.resolved.report", report);
            this.getProject().addReference("ivy.resolved.configurations.ref", confs);
            this.getProject().addReference("ivy.resolved.descriptor", md);
        }
        String suffix = md.getModuleRevisionId().getModuleId().getOrganisation() + "." + md.getModuleRevisionId().getModuleId().getName();
        this.getProject().addReference("ivy.resolved.report." + suffix, report);
        this.getProject().addReference("ivy.resolved.descriptor." + suffix, md);
        this.getProject().addReference("ivy.resolved.configurations.ref." + suffix, confs);
    }

    protected void setResolved(ResolveReport report, String resolveId, boolean keep) {
        this.setResolved(report, keep);
        if (resolveId != null) {
            ModuleDescriptor md = report.getModuleDescriptor();
            String[] confs = report.getConfigurations();
            this.getProject().addReference("ivy.resolved.report." + resolveId, report);
            this.getProject().addReference("ivy.resolved.descriptor." + resolveId, md);
            this.getProject().addReference("ivy.resolved.configurations.ref." + resolveId, confs);
        }
    }

    protected String[] getResolvedConfigurations(String org, String module, boolean strict) {
        return (String[])this.getReference("ivy.resolved.configurations.ref", org, module, strict);
    }

    protected Object getResolvedDescriptor(String resolveId) {
        return this.getResolvedDescriptor(resolveId, true);
    }

    protected Object getResolvedDescriptor(String resolveId, boolean strict) {
        Object result = this.getProject().getReference("ivy.resolved.descriptor." + resolveId);
        if (strict && result == null) {
            throw new BuildException("ModuleDescriptor for resolve with id '" + resolveId + "' not found.");
        }
        return result;
    }

    protected Object getResolvedDescriptor(String org, String module) {
        return this.getResolvedDescriptor(org, module, false);
    }

    protected Object getResolvedDescriptor(String org, String module, boolean strict) {
        return this.getReference("ivy.resolved.descriptor", org, module, strict);
    }

    private Object getReference(String prefix, String org, String module, boolean strict) {
        Object reference = null;
        if (org != null && module != null) {
            reference = this.getProject().getReference(prefix + "." + org + "." + module);
        }
        if (!strict && reference == null) {
            reference = this.getProject().getReference(prefix);
        }
        return reference;
    }

    protected ResolveReport getResolvedReport(String org, String module, String resolveId) {
        ResolveReport result = null;
        result = resolveId == null ? (ResolveReport)this.getReference("ivy.resolved.report", org, module, false) : (ResolveReport)this.getReference("ivy.resolved.report." + resolveId, null, null, false);
        return result;
    }

    protected String[] splitConfs(String conf) {
        if (conf == null) {
            return null;
        }
        String[] confs = conf.split(",");
        for (int i = 0; i < confs.length; ++i) {
            confs[i] = confs[i].trim();
        }
        return confs;
    }

    protected String mergeConfs(String[] conf) {
        return StringUtils.join(conf, ", ");
    }

    protected static Date getPubDate(String date, Date def) {
        if (date != null) {
            if ("now".equals(date.toLowerCase(Locale.US))) {
                return new Date();
            }
            try {
                return DATE_FORMAT.parse(date);
            }
            catch (Exception ex) {
                throw new BuildException("publication date provided in bad format. should be yyyyMMddHHmmss and not " + date);
            }
        }
        return def;
    }

    protected String getProperty(String value, IvySettings ivy, String name) {
        if (value == null) {
            return this.getProperty(ivy, name);
        }
        value = ivy.substitute(value);
        Message.debug("parameter found as attribute value: " + name + "=" + value);
        return value;
    }

    protected String getProperty(String value, IvySettings ivy, String name, String resolveId) {
        if (resolveId == null) {
            return this.getProperty(value, ivy, name);
        }
        return this.getProperty(value, ivy, name + "." + resolveId);
    }

    protected String getProperty(IvySettings ivy, String name, String resolveId) {
        if (resolveId == null) {
            return this.getProperty(ivy, name);
        }
        return this.getProperty(ivy, name + "." + resolveId);
    }

    protected String getProperty(IvySettings ivy, String name) {
        String val = ivy.getVariable(name);
        if (val == null) {
            val = ivy.substitute(this.getProject().getProperty(name));
            if (val != null) {
                Message.debug("parameter found as ant project property: " + name + "=" + val);
            } else {
                Message.debug("parameter not found: " + name);
            }
        } else {
            val = ivy.substitute(val);
            Message.debug("parameter found as ivy variable: " + name + "=" + val);
        }
        return val;
    }

    protected void prepareTask() {
        this.getProject().setProperty("ivy.version", Ivy.getIvyVersion());
        IvyContext.pushNewCopyContext();
        IvyContext.getContext().setIvy(this.getIvyInstance());
        IvyContext.getContext().push(ANT_PROJECT_CONTEXT_KEY, this.getProject());
    }

    protected void finalizeTask() {
        if (!IvyContext.getContext().pop(ANT_PROJECT_CONTEXT_KEY, this.getProject())) {
            Message.error("ANT project poped from stack not equals current !. Ignoring");
        }
        IvyContext.popContext();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void execute() throws BuildException {
        try {
            this.prepareTask();
            this.doExecute();
        }
        finally {
            this.finalizeTask();
        }
    }

    public abstract void doExecute() throws BuildException;

    public String toString() {
        return this.getClass().getName() + ":" + this.getTaskName();
    }

    protected void cacheAttributeNotSupported() {
        throw new BuildException("cache attribute is not supported any more. See IVY-685 for details.");
    }
}

