/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.org.apache.ivy.core.check;

import java.io.IOException;
import java.net.URL;
import java.text.ParseException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import org.gradle.internal.impldep.org.apache.ivy.core.check.CheckEngineSettings;
import org.gradle.internal.impldep.org.apache.ivy.core.module.descriptor.Artifact;
import org.gradle.internal.impldep.org.apache.ivy.core.module.descriptor.DependencyDescriptor;
import org.gradle.internal.impldep.org.apache.ivy.core.module.descriptor.ModuleDescriptor;
import org.gradle.internal.impldep.org.apache.ivy.core.resolve.ResolveData;
import org.gradle.internal.impldep.org.apache.ivy.core.resolve.ResolveEngine;
import org.gradle.internal.impldep.org.apache.ivy.core.resolve.ResolveOptions;
import org.gradle.internal.impldep.org.apache.ivy.core.resolve.ResolvedModuleRevision;
import org.gradle.internal.impldep.org.apache.ivy.plugins.parser.ModuleDescriptorParserRegistry;
import org.gradle.internal.impldep.org.apache.ivy.plugins.resolver.DependencyResolver;
import org.gradle.internal.impldep.org.apache.ivy.util.Message;

public class CheckEngine {
    private CheckEngineSettings settings;
    private ResolveEngine resolveEngine;

    public CheckEngine(CheckEngineSettings settings, ResolveEngine resolveEngine) {
        this.settings = settings;
        this.resolveEngine = resolveEngine;
    }

    public boolean check(URL ivyFile, String resolvername) {
        try {
            boolean result = true;
            ModuleDescriptor md = ModuleDescriptorParserRegistry.getInstance().parseDescriptor(this.settings, ivyFile, this.settings.doValidate());
            if (resolvername != null) {
                DependencyResolver resolver = this.settings.getResolver(resolvername);
                String[] confs = md.getConfigurationsNames();
                HashSet<Artifact> artifacts2 = new HashSet<Artifact>();
                for (int i = 0; i < confs.length; ++i) {
                    artifacts2.addAll(Arrays.asList(md.getArtifacts(confs[i])));
                }
                Iterator iter = artifacts2.iterator();
                while (iter.hasNext()) {
                    Artifact art = (Artifact)iter.next();
                    if (resolver.exists(art)) continue;
                    Message.info("declared publication not found: " + art);
                    result = false;
                }
            }
            DependencyDescriptor[] dds = md.getDependencies();
            ResolveData data = new ResolveData(this.resolveEngine, new ResolveOptions());
            for (int i = 0; i < dds.length; ++i) {
                String[] masterConfs = dds[i].getModuleConfigurations();
                for (int j = 0; j < masterConfs.length; ++j) {
                    if ("*".equals(masterConfs[j].trim()) || md.getConfiguration(masterConfs[j]) != null) continue;
                    Message.info("dependency required in non existing conf for " + ivyFile + " \n\tin " + dds[i] + ": " + masterConfs[j]);
                    result = false;
                }
                DependencyResolver resolver = this.settings.getResolver(dds[i].getDependencyRevisionId());
                ResolvedModuleRevision rmr = resolver.getDependency(dds[i], data);
                if (rmr == null) {
                    Message.info("dependency not found in " + ivyFile + ":\n\t" + dds[i]);
                    result = false;
                    continue;
                }
                String[] depConfs = dds[i].getDependencyConfigurations(md.getConfigurationsNames());
                for (int j = 0; j < depConfs.length; ++j) {
                    if (!Arrays.asList(rmr.getDescriptor().getConfigurationsNames()).contains(depConfs[j])) {
                        Message.info("dependency configuration is missing for " + ivyFile + "\n\tin " + dds[i] + ": " + depConfs[j]);
                        result = false;
                    }
                    Artifact[] arts = rmr.getDescriptor().getArtifacts(depConfs[j]);
                    for (int k = 0; k < arts.length; ++k) {
                        if (resolver.exists(arts[k])) continue;
                        Message.info("dependency artifact is missing for " + ivyFile + "\n\t in " + dds[i] + ": " + arts[k]);
                        result = false;
                    }
                }
            }
            return result;
        }
        catch (ParseException e) {
            Message.info("parse problem on " + ivyFile + ": " + e);
            return false;
        }
        catch (IOException e) {
            Message.info("io problem on " + ivyFile + ": " + e);
            return false;
        }
        catch (Exception e) {
            Message.info("problem on " + ivyFile + ": " + e);
            return false;
        }
    }
}

