/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.org.apache.ivy.core.report;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.gradle.internal.impldep.org.apache.ivy.core.cache.ResolutionCacheManager;
import org.gradle.internal.impldep.org.apache.ivy.core.module.descriptor.Artifact;
import org.gradle.internal.impldep.org.apache.ivy.core.module.descriptor.ModuleDescriptor;
import org.gradle.internal.impldep.org.apache.ivy.core.module.id.ModuleId;
import org.gradle.internal.impldep.org.apache.ivy.core.module.id.ModuleRevisionId;
import org.gradle.internal.impldep.org.apache.ivy.core.report.ArtifactDownloadReport;
import org.gradle.internal.impldep.org.apache.ivy.core.report.DownloadReport;
import org.gradle.internal.impldep.org.apache.ivy.core.report.DownloadStatus;
import org.gradle.internal.impldep.org.apache.ivy.core.resolve.IvyNode;
import org.gradle.internal.impldep.org.apache.ivy.core.resolve.ResolveEngine;
import org.gradle.internal.impldep.org.apache.ivy.core.resolve.ResolveOptions;
import org.gradle.internal.impldep.org.apache.ivy.core.sort.SortOptions;
import org.gradle.internal.impldep.org.apache.ivy.plugins.report.XmlReportParser;
import org.gradle.internal.impldep.org.apache.ivy.util.Message;

public class ConfigurationResolveReport {
    private final ModuleDescriptor md;
    private final String conf;
    private final Date date;
    private final ResolveOptions options;
    private Map dependencyReports = new LinkedHashMap();
    private Map dependencies = new LinkedHashMap();
    private final ResolveEngine resolveEngine;
    private Map modulesIdsMap = new LinkedHashMap();
    private List modulesIds;
    private Boolean hasChanged = null;

    public ConfigurationResolveReport(ResolveEngine resolveEngine, ModuleDescriptor md, String conf, Date date, ResolveOptions options) {
        this.resolveEngine = resolveEngine;
        this.md = md;
        this.conf = conf;
        this.date = date;
        this.options = options;
    }

    public void checkIfChanged() {
        String resolveId;
        ResolutionCacheManager cache2 = this.resolveEngine.getSettings().getResolutionCacheManager();
        File previousReportFile = cache2.getConfigurationResolveReportInCache(resolveId = this.options.getResolveId(), this.conf);
        if (previousReportFile.exists()) {
            try {
                XmlReportParser parser = new XmlReportParser();
                parser.parse(previousReportFile);
                List<ModuleRevisionId> previousDeps = Arrays.asList(parser.getDependencyRevisionIds());
                HashSet<ModuleRevisionId> previousDepSet = new HashSet<ModuleRevisionId>(previousDeps);
                this.hasChanged = !previousDepSet.equals(this.getModuleRevisionIds());
            }
            catch (Exception e) {
                Message.warn("Error while parsing configuration resolve report " + previousReportFile.getAbsolutePath());
                e.printStackTrace();
                this.hasChanged = Boolean.TRUE;
            }
        } else {
            this.hasChanged = Boolean.TRUE;
        }
    }

    public boolean hasChanged() {
        return this.hasChanged;
    }

    public Set getModuleRevisionIds() {
        LinkedHashSet<ModuleRevisionId> mrids = new LinkedHashSet<ModuleRevisionId>();
        Iterator iter = this.getDependencies().iterator();
        while (iter.hasNext()) {
            IvyNode node = (IvyNode)iter.next();
            if (node.isEvicted(this.getConfiguration()) || node.hasProblem()) continue;
            mrids.add(node.getResolvedId());
        }
        return mrids;
    }

    public void addDependency(IvyNode node) {
        this.dependencies.put(node.getId(), node);
        this.dependencies.put(node.getResolvedId(), node);
        this.dependencyReports.put(node, Collections.EMPTY_LIST);
    }

    public void updateDependency(ModuleRevisionId mrid, IvyNode node) {
        this.dependencies.put(mrid, node);
    }

    public void addDependency(IvyNode node, DownloadReport report) {
        this.dependencies.put(node.getId(), node);
        this.dependencies.put(node.getResolvedId(), node);
        ArrayList<ArtifactDownloadReport> adrs = new ArrayList<ArtifactDownloadReport>();
        Artifact[] artifacts2 = node.getArtifacts(this.conf);
        for (int i = 0; i < artifacts2.length; ++i) {
            ArtifactDownloadReport artifactReport = report.getArtifactReport(artifacts2[i]);
            if (artifactReport != null) {
                adrs.add(artifactReport);
                continue;
            }
            Message.debug("no report found for " + artifacts2[i]);
        }
        this.dependencyReports.put(node, adrs);
    }

    public String getConfiguration() {
        return this.conf;
    }

    public Date getDate() {
        return this.date;
    }

    public ModuleDescriptor getModuleDescriptor() {
        return this.md;
    }

    public IvyNode[] getUnresolvedDependencies() {
        ArrayList<IvyNode> unresolved = new ArrayList<IvyNode>();
        Iterator iter = this.getDependencies().iterator();
        while (iter.hasNext()) {
            IvyNode node = (IvyNode)iter.next();
            if (!node.hasProblem()) continue;
            unresolved.add(node);
        }
        return unresolved.toArray(new IvyNode[unresolved.size()]);
    }

    private Collection getDependencies() {
        return new LinkedHashSet(this.dependencies.values());
    }

    public IvyNode[] getEvictedNodes() {
        ArrayList<IvyNode> evicted = new ArrayList<IvyNode>();
        Iterator iter = this.getDependencies().iterator();
        while (iter.hasNext()) {
            IvyNode node = (IvyNode)iter.next();
            if (!node.isEvicted(this.conf)) continue;
            evicted.add(node);
        }
        return evicted.toArray(new IvyNode[evicted.size()]);
    }

    private Set getEvictedMrids() {
        LinkedHashSet<ModuleRevisionId> evicted = new LinkedHashSet<ModuleRevisionId>();
        IvyNode[] evictedNodes = this.getEvictedNodes();
        for (int i = 0; i < evictedNodes.length; ++i) {
            evicted.add(evictedNodes[i].getId());
        }
        return evicted;
    }

    public IvyNode[] getDownloadedNodes() {
        ArrayList<IvyNode> downloaded = new ArrayList<IvyNode>();
        Iterator iter = this.getDependencies().iterator();
        while (iter.hasNext()) {
            IvyNode node = (IvyNode)iter.next();
            if (!node.isDownloaded() || node.getRealNode() != node) continue;
            downloaded.add(node);
        }
        return downloaded.toArray(new IvyNode[downloaded.size()]);
    }

    public IvyNode[] getSearchedNodes() {
        ArrayList<IvyNode> downloaded = new ArrayList<IvyNode>();
        Iterator iter = this.getDependencies().iterator();
        while (iter.hasNext()) {
            IvyNode node = (IvyNode)iter.next();
            if (!node.isSearched() || node.getRealNode() != node) continue;
            downloaded.add(node);
        }
        return downloaded.toArray(new IvyNode[downloaded.size()]);
    }

    public ArtifactDownloadReport[] getDownloadReports(ModuleRevisionId mrid) {
        Collection col = (Collection)this.dependencyReports.get(this.getDependency(mrid));
        if (col == null) {
            return new ArtifactDownloadReport[0];
        }
        return col.toArray(new ArtifactDownloadReport[col.size()]);
    }

    public IvyNode getDependency(ModuleRevisionId mrid) {
        return (IvyNode)this.dependencies.get(mrid);
    }

    public List getModuleIds() {
        if (this.modulesIds == null) {
            List sortedDependencies = this.resolveEngine.getSortEngine().sortNodes(this.getDependencies(), SortOptions.SILENT);
            Collections.reverse(sortedDependencies);
            Iterator iter = sortedDependencies.iterator();
            while (iter.hasNext()) {
                IvyNode dependency = (IvyNode)iter.next();
                ModuleId mid = dependency.getResolvedId().getModuleId();
                LinkedHashSet<IvyNode> deps = (LinkedHashSet<IvyNode>)this.modulesIdsMap.get(mid);
                if (deps == null) {
                    deps = new LinkedHashSet<IvyNode>();
                    this.modulesIdsMap.put(mid, deps);
                }
                deps.add(dependency);
            }
            this.modulesIds = new ArrayList(this.modulesIdsMap.keySet());
        }
        return Collections.unmodifiableList(this.modulesIds);
    }

    public Collection getNodes(ModuleId mid) {
        if (this.modulesIds == null) {
            this.getModuleIds();
        }
        return (Collection)this.modulesIdsMap.get(mid);
    }

    public ResolveEngine getResolveEngine() {
        return this.resolveEngine;
    }

    public int getArtifactsNumber() {
        int total = 0;
        Iterator iter = this.dependencyReports.values().iterator();
        while (iter.hasNext()) {
            Collection reports = (Collection)iter.next();
            total += reports == null ? 0 : reports.size();
        }
        return total;
    }

    public ArtifactDownloadReport[] getAllArtifactsReports() {
        return this.getArtifactsReports(null, true);
    }

    public ArtifactDownloadReport[] getArtifactsReports(DownloadStatus downloadStatus, boolean withEvicted) {
        LinkedHashSet<ArtifactDownloadReport> all = new LinkedHashSet<ArtifactDownloadReport>();
        Set evictedMrids = null;
        if (!withEvicted) {
            evictedMrids = this.getEvictedMrids();
        }
        Iterator iter = this.dependencyReports.values().iterator();
        while (iter.hasNext()) {
            Collection reports = (Collection)iter.next();
            Iterator itReport = reports.iterator();
            while (itReport.hasNext()) {
                ArtifactDownloadReport report = (ArtifactDownloadReport)itReport.next();
                if (downloadStatus != null && report.getDownloadStatus() != downloadStatus || !withEvicted && evictedMrids.contains(report.getArtifact().getModuleRevisionId())) continue;
                all.add(report);
            }
        }
        return all.toArray(new ArtifactDownloadReport[all.size()]);
    }

    public ArtifactDownloadReport[] getDownloadedArtifactsReports() {
        return this.getArtifactsReports(DownloadStatus.SUCCESSFUL, true);
    }

    public ArtifactDownloadReport[] getFailedArtifactsReports() {
        ArtifactDownloadReport[] allFailedReports = this.getArtifactsReports(DownloadStatus.FAILED, true);
        return ConfigurationResolveReport.filterOutMergedArtifacts(allFailedReports);
    }

    public boolean hasError() {
        return this.getUnresolvedDependencies().length > 0 || this.getFailedArtifactsReports().length > 0;
    }

    public int getNodesNumber() {
        return this.getDependencies().size();
    }

    public static ArtifactDownloadReport[] filterOutMergedArtifacts(ArtifactDownloadReport[] allFailedReports) {
        ArrayList<ArtifactDownloadReport> adrs = new ArrayList<ArtifactDownloadReport>(Arrays.asList(allFailedReports));
        Iterator iterator = adrs.iterator();
        while (iterator.hasNext()) {
            ArtifactDownloadReport adr = (ArtifactDownloadReport)iterator.next();
            if (adr.getArtifact().getExtraAttribute("ivy:merged") == null) continue;
            iterator.remove();
        }
        return adrs.toArray(new ArtifactDownloadReport[adrs.size()]);
    }
}

