/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.org.apache.ivy.core.resolve;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Properties;
import java.util.Set;
import org.gradle.internal.impldep.org.apache.ivy.Ivy;
import org.gradle.internal.impldep.org.apache.ivy.core.IvyContext;
import org.gradle.internal.impldep.org.apache.ivy.core.cache.ArtifactOrigin;
import org.gradle.internal.impldep.org.apache.ivy.core.cache.ResolutionCacheManager;
import org.gradle.internal.impldep.org.apache.ivy.core.event.EventManager;
import org.gradle.internal.impldep.org.apache.ivy.core.event.download.PrepareDownloadEvent;
import org.gradle.internal.impldep.org.apache.ivy.core.event.resolve.EndResolveEvent;
import org.gradle.internal.impldep.org.apache.ivy.core.event.resolve.StartResolveEvent;
import org.gradle.internal.impldep.org.apache.ivy.core.module.descriptor.Artifact;
import org.gradle.internal.impldep.org.apache.ivy.core.module.descriptor.Configuration;
import org.gradle.internal.impldep.org.apache.ivy.core.module.descriptor.DefaultDependencyDescriptor;
import org.gradle.internal.impldep.org.apache.ivy.core.module.descriptor.DefaultModuleDescriptor;
import org.gradle.internal.impldep.org.apache.ivy.core.module.descriptor.DependencyDescriptor;
import org.gradle.internal.impldep.org.apache.ivy.core.module.descriptor.ModuleDescriptor;
import org.gradle.internal.impldep.org.apache.ivy.core.module.id.ModuleId;
import org.gradle.internal.impldep.org.apache.ivy.core.module.id.ModuleRevisionId;
import org.gradle.internal.impldep.org.apache.ivy.core.report.ArtifactDownloadReport;
import org.gradle.internal.impldep.org.apache.ivy.core.report.ConfigurationResolveReport;
import org.gradle.internal.impldep.org.apache.ivy.core.report.DownloadReport;
import org.gradle.internal.impldep.org.apache.ivy.core.report.DownloadStatus;
import org.gradle.internal.impldep.org.apache.ivy.core.report.ResolveReport;
import org.gradle.internal.impldep.org.apache.ivy.core.resolve.DownloadOptions;
import org.gradle.internal.impldep.org.apache.ivy.core.resolve.IvyNode;
import org.gradle.internal.impldep.org.apache.ivy.core.resolve.IvyNodeCallers;
import org.gradle.internal.impldep.org.apache.ivy.core.resolve.IvyNodeEviction;
import org.gradle.internal.impldep.org.apache.ivy.core.resolve.ResolveData;
import org.gradle.internal.impldep.org.apache.ivy.core.resolve.ResolveEngineSettings;
import org.gradle.internal.impldep.org.apache.ivy.core.resolve.ResolveOptions;
import org.gradle.internal.impldep.org.apache.ivy.core.resolve.ResolvedModuleRevision;
import org.gradle.internal.impldep.org.apache.ivy.core.resolve.RestartResolveProcess;
import org.gradle.internal.impldep.org.apache.ivy.core.resolve.VisitNode;
import org.gradle.internal.impldep.org.apache.ivy.core.sort.SortEngine;
import org.gradle.internal.impldep.org.apache.ivy.core.sort.SortOptions;
import org.gradle.internal.impldep.org.apache.ivy.plugins.conflict.ConflictManager;
import org.gradle.internal.impldep.org.apache.ivy.plugins.parser.ModuleDescriptorParser;
import org.gradle.internal.impldep.org.apache.ivy.plugins.parser.ModuleDescriptorParserRegistry;
import org.gradle.internal.impldep.org.apache.ivy.plugins.repository.url.URLResource;
import org.gradle.internal.impldep.org.apache.ivy.plugins.resolver.DependencyResolver;
import org.gradle.internal.impldep.org.apache.ivy.plugins.version.VersionMatcher;
import org.gradle.internal.impldep.org.apache.ivy.util.Message;
import org.gradle.internal.impldep.org.apache.ivy.util.filter.Filter;

public class ResolveEngine {
    private ResolveEngineSettings settings;
    private EventManager eventManager;
    private SortEngine sortEngine;
    private Set fetchedSet = new HashSet();
    private DependencyResolver dictatorResolver;

    public ResolveEngine(ResolveEngineSettings settings, EventManager eventManager, SortEngine sortEngine) {
        this.settings = settings;
        this.eventManager = eventManager;
        this.sortEngine = sortEngine;
    }

    public DependencyResolver getDictatorResolver() {
        return this.dictatorResolver;
    }

    public void setDictatorResolver(DependencyResolver dictatorResolver) {
        this.dictatorResolver = dictatorResolver;
        this.settings.setDictatorResolver(dictatorResolver);
    }

    public ResolveReport resolve(File ivySource) throws ParseException, IOException {
        return this.resolve(ivySource.toURI().toURL());
    }

    public ResolveReport resolve(URL ivySource) throws ParseException, IOException {
        return this.resolve(ivySource, new ResolveOptions());
    }

    public ResolveReport resolve(ModuleRevisionId mrid, ResolveOptions options, boolean changing) throws ParseException, IOException {
        DefaultModuleDescriptor md;
        ResolveOptions optionsToUse = new ResolveOptions(options);
        if (options.useSpecialConfs()) {
            ResolvedModuleRevision rmr = this.findModule(mrid, new ResolveOptions(options));
            if (rmr == null) {
                Message.verbose("module not found " + mrid);
                optionsToUse.setLog("download-only");
                md = DefaultModuleDescriptor.newCallerInstance(mrid, new String[]{"default"}, options.isTransitive(), changing);
            } else {
                String[] confs = options.getConfs(rmr.getDescriptor());
                md = DefaultModuleDescriptor.newCallerInstance(ModuleRevisionId.newInstance(mrid, rmr.getId().getRevision()), confs, options.isTransitive(), changing);
            }
        } else {
            md = DefaultModuleDescriptor.newCallerInstance(mrid, options.getConfs(), options.isTransitive(), changing);
        }
        return this.resolve(md, optionsToUse);
    }

    public ResolveReport resolve(URL ivySource, ResolveOptions options) throws ParseException, IOException {
        URLResource res = new URLResource(ivySource);
        ModuleDescriptorParser parser = ModuleDescriptorParserRegistry.getInstance().getParser(res);
        Message.verbose("using " + parser + " to parse " + ivySource);
        ModuleDescriptor md = parser.parseDescriptor(this.settings, ivySource, options.isValidate());
        String revision = options.getRevision();
        if (revision == null && md.getResolvedModuleRevisionId().getRevision() == null) {
            revision = Ivy.getWorkingRevision();
        }
        if (revision != null) {
            md.setResolvedModuleRevisionId(ModuleRevisionId.newInstance(md.getModuleRevisionId(), revision));
        }
        return this.resolve(md, options);
    }

    public ResolveReport resolve(ModuleDescriptor md, ResolveOptions options) throws ParseException, IOException {
        DependencyResolver oldDictator = this.getDictatorResolver();
        IvyContext context = IvyContext.getContext();
        try {
            String[] confs = options.getConfs(md);
            options.setConfs(confs);
            if (options.getResolveId() == null) {
                options.setResolveId(ResolveOptions.getDefaultResolveId(md));
            }
            this.eventManager.fireIvyEvent(new StartResolveEvent(md, confs));
            long start = System.currentTimeMillis();
            if ("default".equals(options.getLog())) {
                Message.info(":: resolving dependencies :: " + md.getResolvedModuleRevisionId() + (options.isTransitive() ? "" : " [not transitive]"));
                Message.info("\tconfs: " + Arrays.asList(confs));
            } else {
                Message.verbose(":: resolving dependencies :: " + md.getResolvedModuleRevisionId() + (options.isTransitive() ? "" : " [not transitive]"));
                Message.verbose("\tconfs: " + Arrays.asList(confs));
            }
            Message.verbose("\tvalidate = " + options.isValidate());
            Message.verbose("\trefresh = " + options.isRefresh());
            ResolveReport report = new ResolveReport(md, options.getResolveId());
            ResolveData data = new ResolveData(this, options);
            context.setResolveData(data);
            IvyNode[] dependencies = this.getDependencies(md, options, report);
            report.setDependencies(Arrays.asList(dependencies), options.getArtifactFilter());
            if (options.getCheckIfChanged()) {
                report.checkIfChanged();
            }
            ResolutionCacheManager cacheManager = this.settings.getResolutionCacheManager();
            cacheManager.saveResolvedModuleDescriptor(md);
            File ivyPropertiesInCache = cacheManager.getResolvedIvyPropertiesInCache(md.getResolvedModuleRevisionId());
            Properties props = new Properties();
            if (dependencies.length > 0) {
                DependencyDescriptor dd;
                int i;
                HashMap<ModuleId, ModuleRevisionId> forcedRevisions = new HashMap<ModuleId, ModuleRevisionId>();
                for (int i2 = 0; i2 < dependencies.length; ++i2) {
                    if (dependencies[i2].getModuleRevision() == null || !dependencies[i2].getModuleRevision().isForce()) continue;
                    forcedRevisions.put(dependencies[i2].getModuleId(), dependencies[i2].getResolvedId());
                }
                IvyNode root = dependencies[0].getRoot();
                HashMap<ModuleId, IvyNode> topLevelDeps = new HashMap<ModuleId, IvyNode>();
                for (i = 0; i < dependencies.length; ++i) {
                    if (dependencies[i].hasProblem() || (dd = dependencies[i].getDependencyDescriptor(root)) == null) continue;
                    ModuleId orgMod = dependencies[i].getModuleId();
                    topLevelDeps.put(orgMod, dependencies[i]);
                }
                for (i = 0; i < dependencies.length; ++i) {
                    ModuleId mid;
                    IvyNode tlDep;
                    if (dependencies[i].hasProblem() || dependencies[i].isCompletelyEvicted()) continue;
                    dd = dependencies[i].getDependencyDescriptor(root);
                    if (dd == null && (tlDep = (IvyNode)topLevelDeps.get(mid = dependencies[i].getModuleId())) != null) {
                        dd = tlDep.getDependencyDescriptor(root);
                    }
                    if (dd == null) continue;
                    ModuleRevisionId depResolvedId = dependencies[i].getResolvedId();
                    ModuleDescriptor depDescriptor = dependencies[i].getDescriptor();
                    ModuleRevisionId depRevisionId = dd.getDependencyRevisionId();
                    ModuleRevisionId forcedRevisionId = (ModuleRevisionId)forcedRevisions.get(dependencies[i].getModuleId());
                    if (dependencies[i].getModuleRevision() != null && dependencies[i].getModuleRevision().isForce() && !depResolvedId.equals(depRevisionId) && !this.settings.getVersionMatcher().isDynamic(depRevisionId)) {
                        depResolvedId = depRevisionId;
                        depDescriptor = null;
                    }
                    if (depResolvedId == null) {
                        throw new NullPointerException("getResolvedId() is null for " + dependencies[i].toString());
                    }
                    if (depRevisionId == null) {
                        throw new NullPointerException("getDependencyRevisionId() is null for " + dd.toString());
                    }
                    String rev = depResolvedId.getRevision();
                    String forcedRev = forcedRevisionId == null ? rev : forcedRevisionId.getRevision();
                    String status = depDescriptor == null ? "?" : depDescriptor.getStatus();
                    Message.debug("storing dependency " + depResolvedId + " in props");
                    props.put(depRevisionId.encodeToString(), rev + " " + status + " " + forcedRev + " " + depResolvedId.getBranch());
                }
            }
            FileOutputStream out = new FileOutputStream(ivyPropertiesInCache);
            props.store(out, md.getResolvedModuleRevisionId() + " resolved revisions");
            out.close();
            Message.verbose("\tresolved ivy file produced in cache");
            report.setResolveTime(System.currentTimeMillis() - start);
            if (options.isDownload()) {
                Message.verbose(":: downloading artifacts ::");
                this.downloadArtifacts(report, options.getArtifactFilter(), (DownloadOptions)new DownloadOptions().setLog(options.getLog()));
            }
            if (options.isOutputReport()) {
                this.outputReport(report, cacheManager, options);
            }
            Message.verbose("\tresolve done (" + report.getResolveTime() + "ms resolve - " + report.getDownloadTime() + "ms download)");
            Message.sumupProblems();
            this.eventManager.fireIvyEvent(new EndResolveEvent(md, confs, report));
            ResolveReport resolveReport = report;
            return resolveReport;
        }
        catch (RuntimeException ex) {
            Message.error(ex.getMessage());
            Message.sumupProblems();
            throw ex;
        }
        finally {
            context.setResolveData(null);
            this.setDictatorResolver(oldDictator);
        }
    }

    public void outputReport(ResolveReport report, ResolutionCacheManager cacheMgr, ResolveOptions options) throws IOException {
        if ("default".equals(options.getLog())) {
            Message.info(":: resolution report :: resolve " + report.getResolveTime() + "ms" + " :: artifacts dl " + report.getDownloadTime() + "ms");
        } else {
            Message.verbose(":: resolution report :: resolve " + report.getResolveTime() + "ms" + " :: artifacts dl " + report.getDownloadTime() + "ms");
        }
        report.setProblemMessages(Message.getProblems());
        report.output(this.settings.getReportOutputters(), cacheMgr, options);
    }

    public void downloadArtifacts(ResolveReport report, Filter artifactFilter, DownloadOptions options) {
        long start = System.currentTimeMillis();
        IvyNode[] dependencies = report.getDependencies().toArray(new IvyNode[report.getDependencies().size()]);
        this.eventManager.fireIvyEvent(new PrepareDownloadEvent(report.getArtifacts().toArray(new Artifact[report.getArtifacts().size()])));
        long totalSize = 0L;
        for (int i = 0; i < dependencies.length; ++i) {
            this.checkInterrupted();
            if (dependencies[i].isCompletelyEvicted() || dependencies[i].hasProblem() || dependencies[i].getModuleRevision() == null) continue;
            DependencyResolver resolver = dependencies[i].getModuleRevision().getArtifactResolver();
            Artifact[] selectedArtifacts = dependencies[i].getSelectedArtifacts(artifactFilter);
            DownloadReport dReport = resolver.download(selectedArtifacts, options);
            ArtifactDownloadReport[] adrs = dReport.getArtifactsReports();
            for (int j = 0; j < adrs.length; ++j) {
                if (adrs[j].getDownloadStatus() == DownloadStatus.FAILED) {
                    if (adrs[j].getArtifact().getExtraAttribute("ivy:merged") != null) {
                        Message.warn("\tmerged artifact not found: " + adrs[j].getArtifact() + ". It was required in " + adrs[j].getArtifact().getExtraAttribute("ivy:merged"));
                        continue;
                    }
                    Message.warn("\t" + adrs[j]);
                    resolver.reportFailure(adrs[j].getArtifact());
                    continue;
                }
                if (adrs[j].getDownloadStatus() != DownloadStatus.SUCCESSFUL) continue;
                totalSize += adrs[j].getSize();
            }
            String[] dconfs = dependencies[i].getRootModuleConfigurations();
            for (int j = 0; j < dconfs.length; ++j) {
                if (dependencies[i].isEvicted(dconfs[j]) || dependencies[i].isBlacklisted(dconfs[j])) {
                    report.getConfigurationReport(dconfs[j]).addDependency(dependencies[i]);
                    continue;
                }
                report.getConfigurationReport(dconfs[j]).addDependency(dependencies[i], dReport);
            }
        }
        report.setDownloadTime(System.currentTimeMillis() - start);
        report.setDownloadSize(totalSize);
    }

    public ArtifactDownloadReport download(Artifact artifact, DownloadOptions options) {
        DependencyResolver resolver = this.settings.getResolver(artifact.getModuleRevisionId());
        DownloadReport r = resolver.download(new Artifact[]{artifact}, options);
        return r.getArtifactReport(artifact);
    }

    public ArtifactOrigin locate(Artifact artifact) {
        DependencyResolver resolver = this.settings.getResolver(artifact.getModuleRevisionId());
        return resolver.locate(artifact);
    }

    public ArtifactDownloadReport download(ArtifactOrigin origin, DownloadOptions options) {
        DependencyResolver resolver = this.settings.getResolver(origin.getArtifact().getModuleRevisionId());
        return resolver.download(origin, options);
    }

    public IvyNode[] getDependencies(URL ivySource, ResolveOptions options) throws ParseException, IOException {
        return this.getDependencies(ModuleDescriptorParserRegistry.getInstance().parseDescriptor(this.settings, ivySource, options.isValidate()), options, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IvyNode[] getDependencies(ModuleDescriptor md, ResolveOptions options, ResolveReport report) {
        if (md == null) {
            throw new NullPointerException("module descriptor must not be null");
        }
        String[] confs = options.getConfs(md);
        ArrayList<String> missingConfs = new ArrayList<String>();
        for (int i = 0; i < confs.length; ++i) {
            if (confs[i] == null) {
                throw new NullPointerException("null conf not allowed: confs where: " + Arrays.asList(confs));
            }
            if (md.getConfiguration(confs[i]) != null) continue;
            missingConfs.add(" '" + confs[i] + "' ");
        }
        if (!missingConfs.isEmpty()) {
            throw new IllegalArgumentException("requested configuration" + (missingConfs.size() > 1 ? "s" : "") + " not found in " + md.getModuleRevisionId() + ": " + missingConfs);
        }
        IvyContext context = IvyContext.pushNewCopyContext();
        try {
            options.setConfs(confs);
            Date reportDate = new Date();
            ResolveData data = context.getResolveData();
            if (data == null) {
                data = new ResolveData(this, options);
                context.setResolveData(data);
            }
            IvyNode rootNode = new IvyNode(data, md);
            for (int i = 0; i < confs.length; ++i) {
                Message.verbose("resolving dependencies for configuration '" + confs[i] + "'");
                this.fetchedSet.clear();
                ConfigurationResolveReport confReport = null;
                if (report != null && (confReport = report.getConfigurationReport(confs[i])) == null) {
                    confReport = new ConfigurationResolveReport(this, md, confs[i], reportDate, options);
                    report.addReport(confs[i], confReport);
                }
                data.setReport(confReport);
                VisitNode root = new VisitNode(data, rootNode, null, confs[i], null);
                root.setRequestedConf(confs[i]);
                rootNode.updateConfsToFetch(Collections.singleton(confs[i]));
                boolean fetched = false;
                while (!fetched) {
                    try {
                        this.fetchDependencies(root, confs[i], false);
                        fetched = true;
                    }
                    catch (RestartResolveProcess restart) {
                        Message.verbose("====================================================");
                        Message.verbose("=           RESTARTING RESOLVE PROCESS");
                        Message.verbose("= " + restart.getMessage());
                        Message.verbose("====================================================");
                        this.fetchedSet.clear();
                    }
                }
                Iterator iter = data.getNodes().iterator();
                while (iter.hasNext()) {
                    IvyNode dep = (IvyNode)iter.next();
                    dep.clean();
                }
            }
            Collection nodes = data.getNodes();
            LinkedHashSet<IvyNode> dependencies = new LinkedHashSet<IvyNode>(nodes.size());
            Iterator iter = nodes.iterator();
            while (iter.hasNext()) {
                IvyNode node = (IvyNode)iter.next();
                if (node == null || node.isRoot() || node.isCompletelyBlacklisted()) continue;
                dependencies.add(node);
            }
            List sortedDependencies = this.sortEngine.sortNodes(dependencies, SortOptions.SILENT);
            Collections.reverse(sortedDependencies);
            this.handleTransiviteEviction(md, confs, data, sortedDependencies);
            IvyNode[] ivyNodeArray = dependencies.toArray(new IvyNode[dependencies.size()]);
            return ivyNodeArray;
        }
        finally {
            IvyContext.popContext();
        }
    }

    private void handleTransiviteEviction(ModuleDescriptor md, String[] confs, ResolveData data, List sortedDependencies) {
        ListIterator iter = sortedDependencies.listIterator();
        while (iter.hasNext()) {
            IvyNode node = (IvyNode)iter.next();
            if (node.isCompletelyEvicted()) continue;
            for (int i = 0; i < confs.length; ++i) {
                IvyNodeCallers.Caller[] callers = node.getCallers(confs[i]);
                if (this.settings.debugConflictResolution()) {
                    Message.debug("checking if " + node.getId() + " is transitively evicted in " + confs[i]);
                }
                boolean allEvicted = callers.length > 0;
                for (int j = 0; j < callers.length; ++j) {
                    if (callers[j].getModuleRevisionId().equals(md.getModuleRevisionId())) {
                        allEvicted = false;
                        break;
                    }
                    IvyNode callerNode = data.getNode(callers[j].getModuleRevisionId());
                    if (callerNode == null) {
                        Message.warn("ivy internal error: no node found for " + callers[j].getModuleRevisionId() + ": looked in " + data.getNodeIds() + " and root module id was " + md.getModuleRevisionId());
                        continue;
                    }
                    if (!callerNode.isEvicted(confs[i])) {
                        allEvicted = false;
                        break;
                    }
                    if (!this.settings.debugConflictResolution()) continue;
                    Message.debug("caller " + callerNode.getId() + " of " + node.getId() + " is evicted");
                }
                if (allEvicted) {
                    Message.verbose("all callers are evicted for " + node + ": evicting too");
                    node.markEvicted(confs[i], null, null, null);
                    continue;
                }
                if (!this.settings.debugConflictResolution()) continue;
                Message.debug(node.getId() + " isn't transitively evicted, at least one caller was" + " not evicted");
            }
        }
    }

    private void fetchDependencies(VisitNode node, String conf, boolean shouldBePublic) {
        IvyNodeEviction.EvictionData ed;
        int i;
        String[] confs;
        this.checkInterrupted();
        long start = System.currentTimeMillis();
        if (node.getParent() != null) {
            Message.verbose("== resolving dependencies " + node.getParent().getId() + "->" + node.getId() + " [" + node.getParentConf() + "->" + conf + "]");
        } else {
            Message.verbose("== resolving dependencies for " + node.getId() + " [" + conf + "]");
        }
        ResolveData data = node.getNode().getData();
        VisitNode parentVisitNode = data.getCurrentVisitNode();
        data.setCurrentVisitNode(node);
        DependencyDescriptor dd = node.getDependencyDescriptor();
        VersionMatcher versionMatcher = node.getNode().getData().getSettings().getVersionMatcher();
        if (!(dd == null || node.getRoot() == node.getParent() && versionMatcher.isDynamic(dd.getDependencyRevisionId()))) {
            this.resolveConflict(node, conf);
        }
        if (node.loadData(conf, shouldBePublic)) {
            this.resolveConflict(node, conf);
            if (!node.isEvicted() && !node.isCircular()) {
                confs = node.getRealConfs(conf);
                for (i = 0; i < confs.length; ++i) {
                    this.doFetchDependencies(node, confs[i]);
                }
            }
        } else if (!(node.hasProblem() || node.isEvicted() || node.isCircular())) {
            confs = node.getRealConfs(conf);
            for (i = 0; i < confs.length; ++i) {
                this.doFetchDependencies(node, confs[i]);
            }
        }
        if (node.isEvicted() && (ed = node.getEvictedData()).getSelected() != null) {
            Iterator iter = ed.getSelected().iterator();
            while (iter.hasNext()) {
                IvyNode selected = (IvyNode)iter.next();
                if (!selected.isLoaded()) {
                    selected.updateConfsToFetch(Collections.singleton(conf));
                    continue;
                }
                this.fetchDependencies(node.gotoNode(selected), conf, true);
            }
        }
        if (this.settings.debugConflictResolution()) {
            Message.debug(node.getId() + " => dependencies resolved in " + conf + " (" + (System.currentTimeMillis() - start) + "ms)");
        }
        data.setCurrentVisitNode(parentVisitNode);
    }

    private void doFetchDependencies(VisitNode node, String conf) {
        String[] extendedConfs;
        Configuration c = node.getConfiguration(conf);
        if (c == null) {
            if (!node.isConfRequiredByMergedUsageOnly(conf)) {
                Message.warn("configuration not found '" + conf + "' in " + node.getResolvedId() + ": ignoring");
                if (node.getParent() != null) {
                    Message.warn("it was required from " + node.getParent().getResolvedId());
                }
            }
            return;
        }
        boolean requestedConfSet = false;
        if (node.getRequestedConf() == null) {
            node.setRequestedConf(conf);
            requestedConfSet = true;
        }
        if ((extendedConfs = c.getExtends()).length > 0) {
            node.updateConfsToFetch(Arrays.asList(extendedConfs));
        }
        for (int i = 0; i < extendedConfs.length; ++i) {
            this.fetchDependencies(node, extendedConfs[i], false);
        }
        if (!this.isDependenciesFetched(node.getNode(), conf) && node.isTransitive()) {
            Collection dependencies = node.getDependencies(conf);
            Iterator iter = dependencies.iterator();
            while (iter.hasNext()) {
                int i;
                VisitNode dep = (VisitNode)iter.next();
                dep.useRealNode();
                String[] confs = dep.getRequiredConfigurations(node, conf);
                for (i = 0; i < confs.length; ++i) {
                    this.fetchDependencies(dep, confs[i], true);
                }
                if (dep.isEvicted() || dep.hasProblem()) continue;
                confs = dep.getConfsToFetch();
                for (i = 0; i < confs.length; ++i) {
                    this.fetchDependencies(dep, confs[i], false);
                }
            }
            this.markDependenciesFetched(node.getNode(), conf);
        }
        if (requestedConfSet) {
            node.setRequestedConf(null);
        }
    }

    private boolean isDependenciesFetched(IvyNode node, String conf) {
        String key = this.getDependenciesFetchedKey(node, conf);
        return this.fetchedSet.contains(key);
    }

    private void markDependenciesFetched(IvyNode node, String conf) {
        String key = this.getDependenciesFetchedKey(node, conf);
        this.fetchedSet.add(key);
    }

    private String getDependenciesFetchedKey(IvyNode node, String conf) {
        ModuleRevisionId moduleRevisionId = node.getResolvedId();
        String key = moduleRevisionId.getOrganisation() + "|" + moduleRevisionId.getName() + "|" + moduleRevisionId.getRevision() + "|" + conf;
        return key;
    }

    private void resolveConflict(VisitNode node, String conf) {
        this.resolveConflict(node, node.getParent(), conf, Collections.EMPTY_SET);
    }

    private boolean resolveConflict(VisitNode node, VisitNode ancestor, String conf, Collection toevict) {
        if (ancestor == null || node == ancestor) {
            return true;
        }
        if (this.checkConflictSolvedEvicted(node, ancestor)) {
            return true;
        }
        boolean debugConflictResolution = this.settings.debugConflictResolution();
        if (this.checkConflictSolvedSelected(node, ancestor)) {
            if (this.resolveConflict(node, ancestor.getParent(), conf, toevict)) {
                IvyNodeEviction.EvictionData evictionData = node.getEvictionDataInRoot(node.getRootModuleConf(), ancestor);
                if (evictionData != null) {
                    if (debugConflictResolution) {
                        Message.debug(node + " was previously evicted in root module conf " + node.getRootModuleConf());
                    }
                    node.markEvicted(evictionData);
                    if (debugConflictResolution) {
                        Message.debug("evicting " + node + " by " + evictionData);
                    }
                }
                return true;
            }
            return false;
        }
        Set resolvedNodes = ancestor.getNode().getResolvedNodes(node.getModuleId(), node.getRootModuleConf());
        resolvedNodes.addAll(ancestor.getNode().getPendingConflicts(node.getRootModuleConf(), node.getModuleId()));
        Collection conflicts = this.computeConflicts(node, ancestor, conf, toevict, resolvedNodes);
        ConflictManager conflictManager = ancestor.getNode().getConflictManager(node.getModuleId());
        Collection resolved = this.resolveConflicts(node, ancestor, conflicts, conflictManager);
        if (resolved == null) {
            if (debugConflictResolution) {
                Message.debug("impossible to resolve conflicts for " + node + " in " + ancestor + " yet");
                Message.debug("setting all nodes as pending conflicts for later conflict resolution: " + conflicts);
            }
            ancestor.getNode().setPendingConflicts(node.getModuleId(), node.getRootModuleConf(), conflicts);
            return false;
        }
        if (debugConflictResolution) {
            Message.debug("selected revisions for " + node + " in " + ancestor + ": " + resolved);
        }
        if (resolved.contains(node.getNode())) {
            toevict = resolvedNodes;
            toevict.removeAll(resolved);
            Iterator iter = toevict.iterator();
            while (iter.hasNext()) {
                IvyNode te = (IvyNode)iter.next();
                te.markEvicted(node.getRootModuleConf(), ancestor.getNode(), conflictManager, resolved);
                if (!debugConflictResolution) continue;
                Message.debug("evicting " + te + " by " + te.getEvictedData(node.getRootModuleConf()));
            }
            ancestor.getNode().setResolvedNodes(node.getModuleId(), node.getRootModuleConf(), resolved);
            HashSet evicted = new HashSet(ancestor.getNode().getEvictedNodes(node.getModuleId(), node.getRootModuleConf()));
            evicted.removeAll(resolved);
            evicted.addAll(toevict);
            ancestor.getNode().setEvictedNodes(node.getModuleId(), node.getRootModuleConf(), evicted);
            ancestor.getNode().setPendingConflicts(node.getModuleId(), node.getRootModuleConf(), Collections.EMPTY_SET);
            return this.resolveConflict(node, ancestor.getParent(), conf, toevict);
        }
        if (resolved.isEmpty() && debugConflictResolution) {
            Message.verbose("conflict manager '" + conflictManager + "' evicted all revisions among " + conflicts);
        }
        HashSet<IvyNode> evicted = new HashSet<IvyNode>(ancestor.getNode().getEvictedNodes(node.getModuleId(), node.getRootModuleConf()));
        toevict.removeAll(resolved);
        evicted.removeAll(resolved);
        evicted.addAll(toevict);
        evicted.add(node.getNode());
        ancestor.getNode().setEvictedNodes(node.getModuleId(), node.getRootModuleConf(), evicted);
        ancestor.getNode().setPendingConflicts(node.getModuleId(), node.getRootModuleConf(), Collections.EMPTY_SET);
        node.markEvicted(ancestor, conflictManager, resolved);
        if (debugConflictResolution) {
            Message.debug("evicting " + node + " by " + node.getEvictedData());
        }
        Set prevResolved = ancestor.getNode().getResolvedNodes(node.getModuleId(), node.getRootModuleConf());
        boolean solved = true;
        if (!((Object)prevResolved).equals(resolved)) {
            ancestor.getNode().setResolvedNodes(node.getModuleId(), node.getRootModuleConf(), resolved);
            Iterator iter = resolved.iterator();
            while (iter.hasNext()) {
                IvyNode sel = (IvyNode)iter.next();
                if (prevResolved.contains(sel)) continue;
                solved &= this.resolveConflict(node.gotoNode(sel), ancestor.getParent(), conf, toevict);
            }
        }
        return solved;
    }

    private Collection resolveConflicts(VisitNode node, VisitNode ancestor, Collection conflicts, ConflictManager conflictManager) {
        if (node.getParent() != ancestor && conflictManager == this.settings.getConflictManager(node.getModuleId()) && ((Object)node.getParent().getNode().getResolvedNodes(node.getModuleId(), node.getRootModuleConf())).equals(conflicts)) {
            if (this.settings.debugConflictResolution()) {
                Message.debug("no new conflicting revisions for " + node + " in " + ancestor + ": " + conflicts);
            }
            return conflicts;
        }
        if (this.settings.debugConflictResolution()) {
            Message.debug("found conflicting revisions for " + node + " in " + ancestor + ": " + conflicts);
        }
        return conflictManager.resolveConflicts(ancestor.getNode(), conflicts);
    }

    private Collection computeConflicts(VisitNode node, VisitNode ancestor, String conf, Collection toevict, Collection selectedNodes) {
        LinkedHashSet<IvyNode> conflicts = new LinkedHashSet<IvyNode>();
        conflicts.add(node.getNode());
        boolean evictedInSelected = selectedNodes.removeAll(toevict);
        if (evictedInSelected || selectedNodes.isEmpty() && !node.getParent().getNode().equals(ancestor.getNode())) {
            Collection deps = ancestor.getNode().getDependencies(node.getRootModuleConf(), ancestor.getNode().getConfigurations(node.getRootModuleConf()), ancestor.getRequestedConf());
            Iterator iter = deps.iterator();
            while (iter.hasNext()) {
                IvyNode dep = (IvyNode)iter.next();
                if (dep.getModuleId().equals(node.getModuleId())) {
                    conflicts.add(dep);
                }
                conflicts.addAll(dep.getResolvedNodes(node.getModuleId(), node.getRootModuleConf()));
            }
        } else if (selectedNodes.isEmpty()) {
            VisitNode parent = node.getParent();
            Collection parentDepIvyNodes = parent.getNode().getDependencies(node.getRootModuleConf(), parent.getNode().getConfigurations(node.getRootModuleConf()), parent.getRequestedConf());
            Iterator it = parentDepIvyNodes.iterator();
            while (it.hasNext()) {
                IvyNode parentDep = (IvyNode)it.next();
                if (!parentDep.getModuleId().equals(node.getModuleId())) continue;
                conflicts.add(parentDep);
            }
        } else {
            conflicts.addAll(selectedNodes);
        }
        return conflicts;
    }

    private boolean checkConflictSolvedSelected(VisitNode node, VisitNode ancestor) {
        if (ancestor.getResolvedRevisions(node.getModuleId()).contains(node.getResolvedId())) {
            if (this.settings.debugConflictResolution()) {
                Message.debug("conflict resolution already done for " + node + " in " + ancestor);
            }
            return true;
        }
        return false;
    }

    private boolean checkConflictSolvedEvicted(VisitNode node, VisitNode ancestor) {
        if (ancestor.getEvictedRevisions(node.getModuleId()).contains(node.getResolvedId())) {
            if (this.settings.debugConflictResolution()) {
                Message.debug("conflict resolution already done for " + node + " in " + ancestor);
            }
            return true;
        }
        return false;
    }

    public ResolvedModuleRevision findModule(ModuleRevisionId id, ResolveOptions options) {
        DependencyResolver r = this.settings.getResolver(id);
        if (r == null) {
            throw new IllegalStateException("no resolver found for " + id.getModuleId());
        }
        DefaultModuleDescriptor md = DefaultModuleDescriptor.newCallerInstance(id, new String[]{"*"}, false, false);
        if (options.getResolveId() == null) {
            options.setResolveId(ResolveOptions.getDefaultResolveId(md));
        }
        try {
            return r.getDependency(new DefaultDependencyDescriptor(id, true), new ResolveData(this, options, new ConfigurationResolveReport(this, md, "default", null, options)));
        }
        catch (ParseException e) {
            throw new RuntimeException("problem while parsing repository module descriptor for " + id + ": " + e, e);
        }
    }

    public DependencyDescriptor mediate(DependencyDescriptor dd, ResolveOptions options) {
        String resolveMode;
        if (dd == null) {
            return null;
        }
        String string2 = resolveMode = options.getResolveMode() == null ? this.settings.getResolveMode(dd.getDependencyId()) : options.getResolveMode();
        if ("dynamic".equals(resolveMode) && !dd.getDynamicConstraintDependencyRevisionId().equals(dd.getDependencyRevisionId())) {
            return dd.clone(ModuleRevisionId.newInstance(dd.getDynamicConstraintDependencyRevisionId(), dd.getDynamicConstraintDependencyRevisionId().getRevision()));
        }
        return dd;
    }

    public EventManager getEventManager() {
        return this.eventManager;
    }

    public ResolveEngineSettings getSettings() {
        return this.settings;
    }

    public SortEngine getSortEngine() {
        return this.sortEngine;
    }

    private void checkInterrupted() {
        IvyContext.getContext().getIvy().checkInterrupted();
    }
}

