/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.org.apache.maven;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.gradle.internal.impldep.org.apache.maven.ArtifactFilterManager;
import org.gradle.internal.impldep.org.apache.maven.ArtifactFilterManagerDelegate;
import org.gradle.internal.impldep.org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.gradle.internal.impldep.org.apache.maven.artifact.resolver.filter.ExclusionSetFilter;
import org.gradle.internal.impldep.org.codehaus.plexus.PlexusContainer;
import org.gradle.internal.impldep.org.codehaus.plexus.component.annotations.Component;
import org.gradle.internal.impldep.org.codehaus.plexus.component.annotations.Requirement;
import org.gradle.internal.impldep.org.codehaus.plexus.component.repository.exception.ComponentLookupException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(role=ArtifactFilterManager.class)
public class DefaultArtifactFilterManager
implements ArtifactFilterManager {
    private static final Set<String> DEFAULT_EXCLUSIONS;
    @Requirement
    private PlexusContainer plexus;
    protected Set<String> excludedArtifacts = new HashSet<String>(DEFAULT_EXCLUSIONS);

    public static ArtifactFilter createStandardFilter() {
        return new ExclusionSetFilter(DEFAULT_EXCLUSIONS);
    }

    @Override
    public ArtifactFilter getArtifactFilter() {
        LinkedHashSet<String> excludes = new LinkedHashSet<String>(this.excludedArtifacts);
        for (ArtifactFilterManagerDelegate delegate : this.getDelegates()) {
            delegate.addExcludes(excludes);
        }
        return new ExclusionSetFilter(excludes);
    }

    @Override
    public ArtifactFilter getCoreArtifactFilter() {
        return new ExclusionSetFilter(this.getCoreArtifactExcludes());
    }

    private List<ArtifactFilterManagerDelegate> getDelegates() {
        try {
            return this.plexus.lookupList(ArtifactFilterManagerDelegate.class);
        }
        catch (ComponentLookupException e) {
            return new ArrayList<ArtifactFilterManagerDelegate>();
        }
    }

    @Override
    public void excludeArtifact(String artifactId) {
        this.excludedArtifacts.add(artifactId);
    }

    @Override
    public Set<String> getCoreArtifactExcludes() {
        LinkedHashSet<String> excludes = new LinkedHashSet<String>(DEFAULT_EXCLUSIONS);
        for (ArtifactFilterManagerDelegate delegate : this.getDelegates()) {
            delegate.addCoreExcludes(excludes);
        }
        return excludes;
    }

    static {
        HashSet<String> artifacts2 = new HashSet<String>();
        artifacts2.add("classworlds:classworlds");
        artifacts2.add("org.gradle.internal.impldep.org.codehaus.plexus:plexus-classworlds");
        artifacts2.add("org.gradle.internal.impldep.org.codehaus.plexus:plexus-component-api");
        artifacts2.add("org.gradle.internal.impldep.org.codehaus.plexus:plexus-container-default");
        artifacts2.add("plexus:plexus-container-default");
        artifacts2.add("org.sonatype.spice:spice-inject-plexus");
        artifacts2.add("org.sonatype.sisu:sisu-inject-plexus");
        artifacts2.add("org.gradle.internal.impldep.org.apache.maven:maven-artifact");
        artifacts2.add("org.gradle.internal.impldep.org.apache.maven:maven-aether-provider");
        artifacts2.add("org.gradle.internal.impldep.org.apache.maven:maven-artifact-manager");
        artifacts2.add("org.gradle.internal.impldep.org.apache.maven:maven-compat");
        artifacts2.add("org.gradle.internal.impldep.org.apache.maven:maven-core");
        artifacts2.add("org.gradle.internal.impldep.org.apache.maven:maven-error-diagnostics");
        artifacts2.add("org.gradle.internal.impldep.org.apache.maven:maven-lifecycle");
        artifacts2.add("org.gradle.internal.impldep.org.apache.maven:maven-model");
        artifacts2.add("org.gradle.internal.impldep.org.apache.maven:maven-model-builder");
        artifacts2.add("org.gradle.internal.impldep.org.apache.maven:maven-monitor");
        artifacts2.add("org.gradle.internal.impldep.org.apache.maven:maven-plugin-api");
        artifacts2.add("org.gradle.internal.impldep.org.apache.maven:maven-plugin-descriptor");
        artifacts2.add("org.gradle.internal.impldep.org.apache.maven:maven-plugin-parameter-documenter");
        artifacts2.add("org.gradle.internal.impldep.org.apache.maven:maven-plugin-registry");
        artifacts2.add("org.gradle.internal.impldep.org.apache.maven:maven-profile");
        artifacts2.add("org.gradle.internal.impldep.org.apache.maven:maven-project");
        artifacts2.add("org.gradle.internal.impldep.org.apache.maven:maven-repository-metadata");
        artifacts2.add("org.gradle.internal.impldep.org.apache.maven:maven-settings");
        artifacts2.add("org.gradle.internal.impldep.org.apache.maven:maven-settings-builder");
        artifacts2.add("org.gradle.internal.impldep.org.apache.maven:maven-toolchain");
        artifacts2.add("org.gradle.internal.impldep.org.apache.maven.wagon:wagon-provider-api");
        artifacts2.add("org.gradle.internal.impldep.org.sonatype.aether:aether-api");
        artifacts2.add("org.gradle.internal.impldep.org.sonatype.aether:aether-spi");
        artifacts2.add("org.gradle.internal.impldep.org.sonatype.aether:aether-impl");
        DEFAULT_EXCLUSIONS = Collections.unmodifiableSet(artifacts2);
    }
}

