/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.org.apache.maven;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.gradle.internal.impldep.org.apache.maven.AbstractMavenLifecycleParticipant;
import org.gradle.internal.impldep.org.apache.maven.DefaultProjectDependencyGraph;
import org.gradle.internal.impldep.org.apache.maven.FilteredProjectDependencyGraph;
import org.gradle.internal.impldep.org.apache.maven.InternalErrorException;
import org.gradle.internal.impldep.org.apache.maven.LoggingRepositoryListener;
import org.gradle.internal.impldep.org.apache.maven.Maven;
import org.gradle.internal.impldep.org.apache.maven.MavenExecutionException;
import org.gradle.internal.impldep.org.apache.maven.ProjectCycleException;
import org.gradle.internal.impldep.org.apache.maven.ReactorReader;
import org.gradle.internal.impldep.org.apache.maven.RepositoryUtils;
import org.gradle.internal.impldep.org.apache.maven.artifact.ArtifactUtils;
import org.gradle.internal.impldep.org.apache.maven.artifact.handler.manager.ArtifactHandlerManager;
import org.gradle.internal.impldep.org.apache.maven.eventspy.internal.EventSpyDispatcher;
import org.gradle.internal.impldep.org.apache.maven.execution.DefaultMavenExecutionResult;
import org.gradle.internal.impldep.org.apache.maven.execution.ExecutionEvent;
import org.gradle.internal.impldep.org.apache.maven.execution.MavenExecutionRequest;
import org.gradle.internal.impldep.org.apache.maven.execution.MavenExecutionRequestPopulationException;
import org.gradle.internal.impldep.org.apache.maven.execution.MavenExecutionRequestPopulator;
import org.gradle.internal.impldep.org.apache.maven.execution.MavenExecutionResult;
import org.gradle.internal.impldep.org.apache.maven.execution.MavenSession;
import org.gradle.internal.impldep.org.apache.maven.execution.ProjectDependencyGraph;
import org.gradle.internal.impldep.org.apache.maven.lifecycle.internal.ExecutionEventCatapult;
import org.gradle.internal.impldep.org.apache.maven.lifecycle.internal.LifecycleStarter;
import org.gradle.internal.impldep.org.apache.maven.model.building.ModelProblem;
import org.gradle.internal.impldep.org.apache.maven.model.building.ModelProblemUtils;
import org.gradle.internal.impldep.org.apache.maven.model.building.UrlModelSource;
import org.gradle.internal.impldep.org.apache.maven.plugin.LegacySupport;
import org.gradle.internal.impldep.org.apache.maven.project.DuplicateProjectException;
import org.gradle.internal.impldep.org.apache.maven.project.MavenProject;
import org.gradle.internal.impldep.org.apache.maven.project.ProjectBuilder;
import org.gradle.internal.impldep.org.apache.maven.project.ProjectBuildingException;
import org.gradle.internal.impldep.org.apache.maven.project.ProjectBuildingRequest;
import org.gradle.internal.impldep.org.apache.maven.project.ProjectBuildingResult;
import org.gradle.internal.impldep.org.apache.maven.project.ProjectSorter;
import org.gradle.internal.impldep.org.apache.maven.repository.DelegatingLocalArtifactRepository;
import org.gradle.internal.impldep.org.apache.maven.repository.LocalRepositoryNotAccessibleException;
import org.gradle.internal.impldep.org.apache.maven.settings.Mirror;
import org.gradle.internal.impldep.org.apache.maven.settings.Proxy;
import org.gradle.internal.impldep.org.apache.maven.settings.Server;
import org.gradle.internal.impldep.org.apache.maven.settings.building.SettingsProblem;
import org.gradle.internal.impldep.org.apache.maven.settings.crypto.DefaultSettingsDecryptionRequest;
import org.gradle.internal.impldep.org.apache.maven.settings.crypto.SettingsDecrypter;
import org.gradle.internal.impldep.org.apache.maven.settings.crypto.SettingsDecryptionResult;
import org.gradle.internal.impldep.org.codehaus.plexus.PlexusContainer;
import org.gradle.internal.impldep.org.codehaus.plexus.classworlds.realm.ClassRealm;
import org.gradle.internal.impldep.org.codehaus.plexus.component.annotations.Component;
import org.gradle.internal.impldep.org.codehaus.plexus.component.annotations.Requirement;
import org.gradle.internal.impldep.org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.gradle.internal.impldep.org.codehaus.plexus.configuration.xml.XmlPlexusConfiguration;
import org.gradle.internal.impldep.org.codehaus.plexus.logging.Logger;
import org.gradle.internal.impldep.org.codehaus.plexus.util.IOUtil;
import org.gradle.internal.impldep.org.codehaus.plexus.util.StringUtils;
import org.gradle.internal.impldep.org.codehaus.plexus.util.dag.CycleDetectedException;
import org.gradle.internal.impldep.org.codehaus.plexus.util.xml.Xpp3Dom;
import org.gradle.internal.impldep.org.sonatype.aether.RepositorySystem;
import org.gradle.internal.impldep.org.sonatype.aether.RepositorySystemSession;
import org.gradle.internal.impldep.org.sonatype.aether.repository.Authentication;
import org.gradle.internal.impldep.org.sonatype.aether.repository.LocalRepository;
import org.gradle.internal.impldep.org.sonatype.aether.repository.WorkspaceReader;
import org.gradle.internal.impldep.org.sonatype.aether.util.DefaultRepositorySystemSession;
import org.gradle.internal.impldep.org.sonatype.aether.util.graph.manager.ClassicDependencyManager;
import org.gradle.internal.impldep.org.sonatype.aether.util.graph.selector.AndDependencySelector;
import org.gradle.internal.impldep.org.sonatype.aether.util.graph.selector.ExclusionDependencySelector;
import org.gradle.internal.impldep.org.sonatype.aether.util.graph.selector.OptionalDependencySelector;
import org.gradle.internal.impldep.org.sonatype.aether.util.graph.selector.ScopeDependencySelector;
import org.gradle.internal.impldep.org.sonatype.aether.util.graph.transformer.ChainedDependencyGraphTransformer;
import org.gradle.internal.impldep.org.sonatype.aether.util.graph.transformer.ConflictMarker;
import org.gradle.internal.impldep.org.sonatype.aether.util.graph.transformer.JavaDependencyContextRefiner;
import org.gradle.internal.impldep.org.sonatype.aether.util.graph.transformer.JavaEffectiveScopeCalculator;
import org.gradle.internal.impldep.org.sonatype.aether.util.graph.transformer.NearestVersionConflictResolver;
import org.gradle.internal.impldep.org.sonatype.aether.util.graph.traverser.FatArtifactTraverser;
import org.gradle.internal.impldep.org.sonatype.aether.util.repository.ChainedWorkspaceReader;
import org.gradle.internal.impldep.org.sonatype.aether.util.repository.DefaultAuthenticationSelector;
import org.gradle.internal.impldep.org.sonatype.aether.util.repository.DefaultMirrorSelector;
import org.gradle.internal.impldep.org.sonatype.aether.util.repository.DefaultProxySelector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(role=Maven.class)
public class DefaultMaven
implements Maven {
    @Requirement
    private Logger logger;
    @Requirement
    protected ProjectBuilder projectBuilder;
    @Requirement
    private LifecycleStarter lifecycleStarter;
    @Requirement
    protected PlexusContainer container;
    @Requirement
    MavenExecutionRequestPopulator populator;
    @Requirement
    private ExecutionEventCatapult eventCatapult;
    @Requirement
    private ArtifactHandlerManager artifactHandlerManager;
    @Requirement(optional=true, hint="ide")
    private WorkspaceReader workspaceRepository;
    @Requirement
    private RepositorySystem repoSystem;
    @Requirement
    private SettingsDecrypter settingsDecrypter;
    @Requirement
    private LegacySupport legacySupport;
    @Requirement
    private EventSpyDispatcher eventSpyDispatcher;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MavenExecutionResult execute(MavenExecutionRequest request) {
        MavenExecutionResult result;
        try {
            result = this.doExecute(this.populator.populateDefaults(request));
        }
        catch (OutOfMemoryError e) {
            result = this.processResult(new DefaultMavenExecutionResult(), e);
        }
        catch (MavenExecutionRequestPopulationException e) {
            result = this.processResult(new DefaultMavenExecutionResult(), e);
        }
        catch (RuntimeException e) {
            result = this.processResult(new DefaultMavenExecutionResult(), new InternalErrorException("Internal error: " + e, e));
        }
        finally {
            this.legacySupport.setSession(null);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MavenExecutionResult doExecute(MavenExecutionRequest request) {
        List<MavenProject> projects;
        if (request.getStartTime() != null) {
            request.getSystemProperties().put("${build.timestamp}", new SimpleDateFormat("yyyyMMdd-hhmm").format(request.getStartTime()));
        }
        request.setStartTime(new Date());
        DefaultMavenExecutionResult result = new DefaultMavenExecutionResult();
        try {
            this.validateLocalRepository(request);
        }
        catch (LocalRepositoryNotAccessibleException e) {
            return this.processResult(result, e);
        }
        DelegatingLocalArtifactRepository delegatingLocalArtifactRepository = new DelegatingLocalArtifactRepository(request.getLocalRepository());
        request.setLocalRepository(delegatingLocalArtifactRepository);
        DefaultRepositorySystemSession repoSession = (DefaultRepositorySystemSession)this.newRepositorySession(request);
        MavenSession session = new MavenSession(this.container, repoSession, request, result);
        this.legacySupport.setSession(session);
        try {
            for (AbstractMavenLifecycleParticipant listener : this.getLifecycleParticipants(Collections.<MavenProject>emptyList())) {
                listener.afterSessionStart(session);
            }
        }
        catch (MavenExecutionException e) {
            return this.processResult(result, e);
        }
        this.eventCatapult.fire(ExecutionEvent.Type.ProjectDiscoveryStarted, session, null);
        request.getProjectBuildingRequest().setRepositorySession(session.getRepositorySession());
        try {
            projects = this.getProjectsForMavenReactor(request);
        }
        catch (ProjectBuildingException e) {
            return this.processResult(result, e);
        }
        session.setProjects(projects);
        result.setTopologicallySortedProjects(session.getProjects());
        result.setProject(session.getTopLevelProject());
        try {
            Map<String, MavenProject> projectMap = this.getProjectMap(session.getProjects());
            ReactorReader reactorRepository = new ReactorReader(projectMap);
            repoSession.setWorkspaceReader(ChainedWorkspaceReader.newInstance(reactorRepository, repoSession.getWorkspaceReader()));
        }
        catch (org.gradle.internal.impldep.org.apache.maven.DuplicateProjectException e) {
            return this.processResult(result, e);
        }
        ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            for (AbstractMavenLifecycleParticipant listener : this.getLifecycleParticipants(projects)) {
                Thread.currentThread().setContextClassLoader(listener.getClass().getClassLoader());
                listener.afterProjectsRead(session);
            }
        }
        catch (MavenExecutionException e) {
            MavenExecutionResult listener = this.processResult(result, e);
            return listener;
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalClassLoader);
        }
        try {
            ProjectSorter projectSorter = new ProjectSorter(session.getProjects());
            ProjectDependencyGraph projectDependencyGraph = this.createDependencyGraph(projectSorter, request);
            session.setProjects(projectDependencyGraph.getSortedProjects());
            session.setProjectDependencyGraph(projectDependencyGraph);
        }
        catch (CycleDetectedException e) {
            String message2 = "The projects in the reactor contain a cyclic reference: " + e.getMessage();
            ProjectCycleException error = new ProjectCycleException(message2, e);
            return this.processResult(result, error);
        }
        catch (DuplicateProjectException e) {
            return this.processResult(result, e);
        }
        catch (MavenExecutionException e) {
            return this.processResult(result, e);
        }
        result.setTopologicallySortedProjects(session.getProjects());
        if (result.hasExceptions()) {
            return result;
        }
        this.lifecycleStarter.execute(session);
        this.validateActivatedProfiles(session.getProjects(), request.getActiveProfiles());
        if (session.getResult().hasExceptions()) {
            return this.processResult(result, session.getResult().getExceptions().get(0));
        }
        return result;
    }

    public RepositorySystemSession newRepositorySession(MavenExecutionRequest request) {
        DefaultRepositorySystemSession session = new DefaultRepositorySystemSession();
        session.setCache(request.getRepositoryCache());
        session.setIgnoreInvalidArtifactDescriptor(true).setIgnoreMissingArtifactDescriptor(true);
        LinkedHashMap<Object, Object> configProps = new LinkedHashMap<Object, Object>();
        configProps.put("aether.connector.userAgent", this.getUserAgent());
        configProps.put("aether.interactive", request.isInteractiveMode());
        configProps.putAll(request.getSystemProperties());
        configProps.putAll(request.getUserProperties());
        session.setOffline(request.isOffline());
        session.setChecksumPolicy(request.getGlobalChecksumPolicy());
        if (request.isNoSnapshotUpdates()) {
            session.setUpdatePolicy("never");
        } else if (request.isUpdateSnapshots()) {
            session.setUpdatePolicy("always");
        } else {
            session.setUpdatePolicy(null);
        }
        session.setNotFoundCachingEnabled(request.isCacheNotFound());
        session.setTransferErrorCachingEnabled(request.isCacheTransferError());
        session.setArtifactTypeRegistry(RepositoryUtils.newArtifactTypeRegistry(this.artifactHandlerManager));
        LocalRepository localRepo = new LocalRepository(request.getLocalRepository().getBasedir());
        session.setLocalRepositoryManager(this.repoSystem.newLocalRepositoryManager(localRepo));
        if (request.getWorkspaceReader() != null) {
            session.setWorkspaceReader(request.getWorkspaceReader());
        } else {
            session.setWorkspaceReader(this.workspaceRepository);
        }
        DefaultSettingsDecryptionRequest decrypt = new DefaultSettingsDecryptionRequest();
        decrypt.setProxies((List)request.getProxies());
        decrypt.setServers((List)request.getServers());
        SettingsDecryptionResult decrypted = this.settingsDecrypter.decrypt(decrypt);
        if (this.logger.isDebugEnabled()) {
            for (SettingsProblem problem : decrypted.getProblems()) {
                this.logger.debug(problem.getMessage(), problem.getException());
            }
        }
        DefaultMirrorSelector mirrorSelector = new DefaultMirrorSelector();
        for (Mirror mirror : request.getMirrors()) {
            mirrorSelector.add(mirror.getId(), mirror.getUrl(), mirror.getLayout(), false, mirror.getMirrorOf(), mirror.getMirrorOfLayouts());
        }
        session.setMirrorSelector(mirrorSelector);
        DefaultProxySelector proxySelector = new DefaultProxySelector();
        for (Proxy proxy : decrypted.getProxies()) {
            Authentication proxyAuth = new Authentication(proxy.getUsername(), proxy.getPassword());
            proxySelector.add(new org.gradle.internal.impldep.org.sonatype.aether.repository.Proxy(proxy.getProtocol(), proxy.getHost(), proxy.getPort(), proxyAuth), proxy.getNonProxyHosts());
        }
        session.setProxySelector(proxySelector);
        DefaultAuthenticationSelector authSelector = new DefaultAuthenticationSelector();
        for (Server server : decrypted.getServers()) {
            Authentication auth = new Authentication(server.getUsername(), server.getPassword(), server.getPrivateKey(), server.getPassphrase());
            authSelector.add(server.getId(), auth);
            if (server.getConfiguration() != null) {
                Xpp3Dom dom = (Xpp3Dom)server.getConfiguration();
                for (int i = dom.getChildCount() - 1; i >= 0; --i) {
                    Xpp3Dom child = dom.getChild(i);
                    if (!"wagonProvider".equals(child.getName())) continue;
                    dom.removeChild(i);
                }
                XmlPlexusConfiguration config = new XmlPlexusConfiguration(dom);
                configProps.put("aether.connector.wagon.config." + server.getId(), config);
            }
            configProps.put("aether.connector.perms.fileMode." + server.getId(), server.getFilePermissions());
            configProps.put("aether.connector.perms.dirMode." + server.getId(), server.getDirectoryPermissions());
        }
        session.setAuthenticationSelector(authSelector);
        FatArtifactTraverser depTraverser = new FatArtifactTraverser();
        session.setDependencyTraverser(depTraverser);
        ClassicDependencyManager depManager = new ClassicDependencyManager();
        session.setDependencyManager(depManager);
        AndDependencySelector depFilter = new AndDependencySelector(new ScopeDependencySelector("test", "provided"), new OptionalDependencySelector(), new ExclusionDependencySelector());
        session.setDependencySelector(depFilter);
        ChainedDependencyGraphTransformer transformer = new ChainedDependencyGraphTransformer(new ConflictMarker(), new JavaEffectiveScopeCalculator(), new NearestVersionConflictResolver(), new JavaDependencyContextRefiner());
        session.setDependencyGraphTransformer(transformer);
        session.setTransferListener(request.getTransferListener());
        session.setRepositoryListener(this.eventSpyDispatcher.chainListener(new LoggingRepositoryListener(this.logger)));
        session.setUserProps(request.getUserProperties());
        session.setSystemProps(request.getSystemProperties());
        session.setConfigProps(configProps);
        return session;
    }

    private String getUserAgent() {
        return "Apache-Maven/" + this.getMavenVersion() + " (Java " + System.getProperty("java.version") + "; " + System.getProperty("os.name") + " " + System.getProperty("os.version") + ")";
    }

    private String getMavenVersion() {
        Properties props = new Properties();
        InputStream is = this.getClass().getResourceAsStream("/META-INF/maven/org.apache.maven/maven-core/pom.properties");
        if (is != null) {
            try {
                props.load(is);
            }
            catch (IOException e) {
                this.logger.debug("Failed to read Maven version", e);
            }
            IOUtil.close(is);
        }
        return props.getProperty("version", "unknown-version");
    }

    private void validateLocalRepository(MavenExecutionRequest request) throws LocalRepositoryNotAccessibleException {
        File localRepoDir = request.getLocalRepositoryPath();
        this.logger.debug("Using local repository at " + localRepoDir);
        localRepoDir.mkdirs();
        if (!localRepoDir.isDirectory()) {
            throw new LocalRepositoryNotAccessibleException("Could not create local repository at " + localRepoDir);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection<AbstractMavenLifecycleParticipant> getLifecycleParticipants(Collection<MavenProject> projects) {
        LinkedHashSet<AbstractMavenLifecycleParticipant> lifecycleListeners = new LinkedHashSet<AbstractMavenLifecycleParticipant>();
        ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            try {
                lifecycleListeners.addAll(this.container.lookupList(AbstractMavenLifecycleParticipant.class));
            }
            catch (ComponentLookupException e) {
                this.logger.warn("Failed to lookup lifecycle participants: " + e.getMessage());
            }
            HashSet<ClassRealm> scannedRealms = new HashSet<ClassRealm>();
            for (MavenProject project : projects) {
                ClassRealm projectRealm = project.getClassRealm();
                if (projectRealm == null || !scannedRealms.add(projectRealm)) continue;
                Thread.currentThread().setContextClassLoader(projectRealm);
                try {
                    lifecycleListeners.addAll(this.container.lookupList(AbstractMavenLifecycleParticipant.class));
                }
                catch (ComponentLookupException e) {
                    this.logger.warn("Failed to lookup lifecycle participants: " + e.getMessage());
                }
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalClassLoader);
        }
        return lifecycleListeners;
    }

    private MavenExecutionResult processResult(MavenExecutionResult result, Throwable e) {
        if (!result.getExceptions().contains(e)) {
            result.addException(e);
        }
        return result;
    }

    private List<MavenProject> getProjectsForMavenReactor(MavenExecutionRequest request) throws ProjectBuildingException {
        ArrayList<MavenProject> projects = new ArrayList<MavenProject>();
        if (request.getPom() == null) {
            UrlModelSource modelSource = new UrlModelSource(DefaultMaven.class.getResource("project/standalone.xml"));
            MavenProject project = this.projectBuilder.build(modelSource, request.getProjectBuildingRequest()).getProject();
            project.setExecutionRoot(true);
            projects.add(project);
            request.setProjectPresent(false);
            return projects;
        }
        List<File> files = Arrays.asList(request.getPom().getAbsoluteFile());
        this.collectProjects(projects, files, request);
        return projects;
    }

    private Map<String, MavenProject> getProjectMap(List<MavenProject> projects) throws org.gradle.internal.impldep.org.apache.maven.DuplicateProjectException {
        LinkedHashMap<String, MavenProject> index = new LinkedHashMap<String, MavenProject>();
        LinkedHashMap<String, List<File>> collisions = new LinkedHashMap<String, List<File>>();
        for (MavenProject project : projects) {
            String projectId = ArtifactUtils.key(project.getGroupId(), project.getArtifactId(), project.getVersion());
            MavenProject collision = (MavenProject)index.get(projectId);
            if (collision == null) {
                index.put(projectId, project);
                continue;
            }
            ArrayList<File> pomFiles = (ArrayList<File>)collisions.get(projectId);
            if (pomFiles == null) {
                pomFiles = new ArrayList<File>(Arrays.asList(collision.getFile(), project.getFile()));
                collisions.put(projectId, pomFiles);
                continue;
            }
            pomFiles.add(project.getFile());
        }
        if (!collisions.isEmpty()) {
            throw new org.gradle.internal.impldep.org.apache.maven.DuplicateProjectException("Two or more projects in the reactor have the same identifier, please make sure that <groupId>:<artifactId>:<version> is unique for each project: " + collisions, collisions);
        }
        return index;
    }

    private void collectProjects(List<MavenProject> projects, List<File> files, MavenExecutionRequest request) throws ProjectBuildingException {
        ProjectBuildingRequest projectBuildingRequest = request.getProjectBuildingRequest();
        List<ProjectBuildingResult> results = this.projectBuilder.build(files, request.isRecursive(), projectBuildingRequest);
        boolean problems = false;
        for (ProjectBuildingResult result : results) {
            projects.add(result.getProject());
            if (result.getProblems().isEmpty() || !this.logger.isWarnEnabled()) continue;
            this.logger.warn("");
            this.logger.warn("Some problems were encountered while building the effective model for " + result.getProject().getId());
            for (ModelProblem problem : result.getProblems()) {
                String location = ModelProblemUtils.formatLocation(problem, result.getProjectId());
                this.logger.warn(problem.getMessage() + (StringUtils.isNotEmpty(location) ? " @ " + location : ""));
            }
            problems = true;
        }
        if (problems) {
            this.logger.warn("");
            this.logger.warn("It is highly recommended to fix these problems because they threaten the stability of your build.");
            this.logger.warn("");
            this.logger.warn("For this reason, future Maven versions might no longer support building such malformed projects.");
            this.logger.warn("");
        }
    }

    private void validateActivatedProfiles(List<MavenProject> projects, List<String> activeProfileIds) {
        LinkedHashSet<String> notActivatedProfileIds = new LinkedHashSet<String>(activeProfileIds);
        for (MavenProject project : projects) {
            for (List<String> profileIds : project.getInjectedProfileIds().values()) {
                notActivatedProfileIds.removeAll(profileIds);
            }
        }
        for (String notActivatedProfileId : notActivatedProfileIds) {
            this.logger.warn("The requested profile \"" + notActivatedProfileId + "\" could not be activated because it does not exist.");
        }
    }

    protected Logger getLogger() {
        return this.logger;
    }

    private ProjectDependencyGraph createDependencyGraph(ProjectSorter sorter, MavenExecutionRequest request) throws MavenExecutionException {
        ProjectDependencyGraph graph = new DefaultProjectDependencyGraph(sorter);
        List<MavenProject> activeProjects = sorter.getSortedProjects();
        activeProjects = this.trimSelectedProjects(activeProjects, graph, request);
        if ((activeProjects = this.trimResumedProjects(activeProjects, request)).size() != sorter.getSortedProjects().size()) {
            graph = new FilteredProjectDependencyGraph(graph, activeProjects);
        }
        return graph;
    }

    private List<MavenProject> trimSelectedProjects(List<MavenProject> projects, ProjectDependencyGraph graph, MavenExecutionRequest request) throws MavenExecutionException {
        List<MavenProject> result = projects;
        if (!request.getSelectedProjects().isEmpty()) {
            File reactorDirectory = null;
            if (request.getBaseDirectory() != null) {
                reactorDirectory = new File(request.getBaseDirectory());
            }
            LinkedHashSet<MavenProject> selectedProjects = new LinkedHashSet<MavenProject>(projects.size());
            for (String selector : request.getSelectedProjects()) {
                MavenProject selectedProject = null;
                for (MavenProject project : projects) {
                    if (!this.isMatchingProject(project, selector, reactorDirectory)) continue;
                    selectedProject = project;
                    break;
                }
                if (selectedProject != null) {
                    selectedProjects.add(selectedProject);
                    continue;
                }
                throw new MavenExecutionException("Could not find the selected project in the reactor: " + selector, request.getPom());
            }
            boolean makeUpstream = false;
            boolean makeDownstream = false;
            if ("make-upstream".equals(request.getMakeBehavior())) {
                makeUpstream = true;
            } else if ("make-downstream".equals(request.getMakeBehavior())) {
                makeDownstream = true;
            } else if ("make-both".equals(request.getMakeBehavior())) {
                makeUpstream = true;
                makeDownstream = true;
            } else if (StringUtils.isNotEmpty(request.getMakeBehavior())) {
                throw new MavenExecutionException("Invalid reactor make behavior: " + request.getMakeBehavior(), request.getPom());
            }
            if (makeUpstream || makeDownstream) {
                for (MavenProject selectedProject : new ArrayList(selectedProjects)) {
                    if (makeUpstream) {
                        selectedProjects.addAll(graph.getUpstreamProjects(selectedProject, true));
                    }
                    if (!makeDownstream) continue;
                    selectedProjects.addAll(graph.getDownstreamProjects(selectedProject, true));
                }
            }
            result = new ArrayList<MavenProject>(selectedProjects.size());
            for (MavenProject project : projects) {
                if (!selectedProjects.contains(project)) continue;
                result.add(project);
            }
        }
        return result;
    }

    private List<MavenProject> trimResumedProjects(List<MavenProject> projects, MavenExecutionRequest request) throws MavenExecutionException {
        List<MavenProject> result = projects;
        if (StringUtils.isNotEmpty(request.getResumeFrom())) {
            File reactorDirectory = null;
            if (request.getBaseDirectory() != null) {
                reactorDirectory = new File(request.getBaseDirectory());
            }
            String selector = request.getResumeFrom();
            result = new ArrayList<MavenProject>(projects.size());
            boolean resumed = false;
            for (MavenProject project : projects) {
                if (!resumed && this.isMatchingProject(project, selector, reactorDirectory)) {
                    resumed = true;
                }
                if (!resumed) continue;
                result.add(project);
            }
            if (!resumed) {
                throw new MavenExecutionException("Could not find project to resume reactor build from: " + selector + " vs " + projects, request.getPom());
            }
        }
        return result;
    }

    private boolean isMatchingProject(MavenProject project, String selector, File reactorDirectory) {
        if (selector.indexOf(58) >= 0) {
            String id = ':' + project.getArtifactId();
            if (id.equals(selector)) {
                return true;
            }
            id = project.getGroupId() + id;
            if (id.equals(selector)) {
                return true;
            }
        } else if (reactorDirectory != null) {
            File selectedProject = new File(new File(reactorDirectory, selector).toURI().normalize());
            if (selectedProject.isFile()) {
                return selectedProject.equals(project.getFile());
            }
            if (selectedProject.isDirectory()) {
                return selectedProject.equals(project.getBasedir());
            }
        }
        return false;
    }
}

