/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.org.apache.maven.project;

import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.gradle.internal.impldep.org.apache.maven.RepositoryUtils;
import org.gradle.internal.impldep.org.apache.maven.artifact.Artifact;
import org.gradle.internal.impldep.org.apache.maven.artifact.ArtifactUtils;
import org.gradle.internal.impldep.org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.gradle.internal.impldep.org.apache.maven.artifact.InvalidRepositoryException;
import org.gradle.internal.impldep.org.apache.maven.artifact.factory.ArtifactFactory;
import org.gradle.internal.impldep.org.apache.maven.artifact.repository.ArtifactRepository;
import org.gradle.internal.impldep.org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.gradle.internal.impldep.org.apache.maven.model.Build;
import org.gradle.internal.impldep.org.apache.maven.model.CiManagement;
import org.gradle.internal.impldep.org.apache.maven.model.Contributor;
import org.gradle.internal.impldep.org.apache.maven.model.Dependency;
import org.gradle.internal.impldep.org.apache.maven.model.DependencyManagement;
import org.gradle.internal.impldep.org.apache.maven.model.Developer;
import org.gradle.internal.impldep.org.apache.maven.model.DistributionManagement;
import org.gradle.internal.impldep.org.apache.maven.model.Extension;
import org.gradle.internal.impldep.org.apache.maven.model.IssueManagement;
import org.gradle.internal.impldep.org.apache.maven.model.License;
import org.gradle.internal.impldep.org.apache.maven.model.MailingList;
import org.gradle.internal.impldep.org.apache.maven.model.Model;
import org.gradle.internal.impldep.org.apache.maven.model.Organization;
import org.gradle.internal.impldep.org.apache.maven.model.Parent;
import org.gradle.internal.impldep.org.apache.maven.model.Plugin;
import org.gradle.internal.impldep.org.apache.maven.model.PluginExecution;
import org.gradle.internal.impldep.org.apache.maven.model.PluginManagement;
import org.gradle.internal.impldep.org.apache.maven.model.Prerequisites;
import org.gradle.internal.impldep.org.apache.maven.model.Profile;
import org.gradle.internal.impldep.org.apache.maven.model.ReportPlugin;
import org.gradle.internal.impldep.org.apache.maven.model.ReportSet;
import org.gradle.internal.impldep.org.apache.maven.model.Reporting;
import org.gradle.internal.impldep.org.apache.maven.model.Repository;
import org.gradle.internal.impldep.org.apache.maven.model.Resource;
import org.gradle.internal.impldep.org.apache.maven.model.Scm;
import org.gradle.internal.impldep.org.apache.maven.model.io.xpp3.MavenXpp3Writer;
import org.gradle.internal.impldep.org.apache.maven.project.DefaultProjectBuildingRequest;
import org.gradle.internal.impldep.org.apache.maven.project.DuplicateArtifactAttachmentException;
import org.gradle.internal.impldep.org.apache.maven.project.ProjectBuilder;
import org.gradle.internal.impldep.org.apache.maven.project.ProjectBuildingException;
import org.gradle.internal.impldep.org.apache.maven.project.ProjectBuildingRequest;
import org.gradle.internal.impldep.org.apache.maven.project.artifact.InvalidDependencyVersionException;
import org.gradle.internal.impldep.org.apache.maven.project.artifact.MavenMetadataSource;
import org.gradle.internal.impldep.org.apache.maven.repository.RepositorySystem;
import org.gradle.internal.impldep.org.codehaus.plexus.classworlds.realm.ClassRealm;
import org.gradle.internal.impldep.org.codehaus.plexus.logging.Logger;
import org.gradle.internal.impldep.org.codehaus.plexus.util.StringUtils;
import org.gradle.internal.impldep.org.codehaus.plexus.util.xml.Xpp3Dom;
import org.gradle.internal.impldep.org.sonatype.aether.graph.DependencyFilter;
import org.gradle.internal.impldep.org.sonatype.aether.repository.RemoteRepository;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MavenProject
implements Cloneable {
    public static final String EMPTY_PROJECT_GROUP_ID = "unknown";
    public static final String EMPTY_PROJECT_ARTIFACT_ID = "empty-project";
    public static final String EMPTY_PROJECT_VERSION = "0";
    private Model model;
    private MavenProject parent;
    private File file;
    private Set<Artifact> resolvedArtifacts;
    private ArtifactFilter artifactFilter;
    private Set<Artifact> artifacts;
    private Artifact parentArtifact;
    private Set<Artifact> pluginArtifacts;
    private List<ArtifactRepository> remoteArtifactRepositories;
    private List<ArtifactRepository> pluginArtifactRepositories;
    private List<RemoteRepository> remoteProjectRepositories;
    private List<RemoteRepository> remotePluginRepositories;
    private List<Artifact> attachedArtifacts;
    private MavenProject executionProject;
    private List<MavenProject> collectedProjects;
    private List<String> compileSourceRoots = new ArrayList<String>();
    private List<String> testCompileSourceRoots = new ArrayList<String>();
    private List<String> scriptSourceRoots = new ArrayList<String>();
    private ArtifactRepository releaseArtifactRepository;
    private ArtifactRepository snapshotArtifactRepository;
    private List<Profile> activeProfiles = new ArrayList<Profile>();
    private Map<String, List<String>> injectedProfileIds = new LinkedHashMap<String, List<String>>();
    private Set<Artifact> dependencyArtifacts;
    private Artifact artifact;
    private Map<String, Artifact> artifactMap;
    private Model originalModel;
    private Map<String, Artifact> pluginArtifactMap;
    private Set<Artifact> reportArtifacts;
    private Map<String, Artifact> reportArtifactMap;
    private Set<Artifact> extensionArtifacts;
    private Map<String, Artifact> extensionArtifactMap;
    private Map<String, Artifact> managedVersionMap;
    private Map<String, MavenProject> projectReferences = new HashMap<String, MavenProject>();
    private boolean executionRoot;
    private Map<String, String> moduleAdjustments;
    private ProjectBuilder mavenProjectBuilder;
    private ProjectBuildingRequest projectBuilderConfiguration;
    private RepositorySystem repositorySystem;
    private File parentFile;
    private Map<String, Object> context;
    private ClassRealm classRealm;
    private DependencyFilter extensionDependencyFilter;
    private final Set<String> lifecyclePhases = Collections.synchronizedSet(new LinkedHashSet());
    private Logger logger;

    public MavenProject() {
        Model model = new Model();
        model.setGroupId(EMPTY_PROJECT_GROUP_ID);
        model.setArtifactId(EMPTY_PROJECT_ARTIFACT_ID);
        model.setVersion(EMPTY_PROJECT_VERSION);
        this.setModel(model);
    }

    public MavenProject(Model model) {
        this.setModel(model);
    }

    @Deprecated
    public MavenProject(MavenProject project) {
        this.repositorySystem = project.repositorySystem;
        this.logger = project.logger;
        this.mavenProjectBuilder = project.mavenProjectBuilder;
        this.projectBuilderConfiguration = project.projectBuilderConfiguration;
        this.deepCopy(project);
    }

    @Deprecated
    public MavenProject(Model model, RepositorySystem repositorySystem) {
        this.repositorySystem = repositorySystem;
        this.setModel(model);
    }

    public File getParentFile() {
        return this.parentFile;
    }

    public void setParentFile(File parentFile) {
        this.parentFile = parentFile;
    }

    MavenProject(RepositorySystem repositorySystem, ProjectBuilder mavenProjectBuilder, ProjectBuildingRequest projectBuilderConfiguration, Logger logger) {
        if (repositorySystem == null) {
            throw new IllegalArgumentException("mavenTools: null");
        }
        this.mavenProjectBuilder = mavenProjectBuilder;
        this.projectBuilderConfiguration = projectBuilderConfiguration;
        this.repositorySystem = repositorySystem;
        this.logger = logger;
    }

    @Deprecated
    public Set<Artifact> createArtifacts(ArtifactFactory artifactFactory, String inheritedScope, ArtifactFilter filter) throws InvalidDependencyVersionException {
        return MavenMetadataSource.createArtifacts(artifactFactory, this.getDependencies(), inheritedScope, filter, this);
    }

    public String getModulePathAdjustment(MavenProject moduleProject) throws IOException {
        String module = moduleProject.getArtifactId();
        File moduleFile = moduleProject.getFile();
        if (moduleFile != null) {
            File moduleDir = moduleFile.getCanonicalFile().getParentFile();
            module = moduleDir.getName();
        }
        if (this.moduleAdjustments == null) {
            this.moduleAdjustments = new HashMap<String, String>();
            List<String> modules = this.getModules();
            if (modules != null) {
                for (String modulePath : modules) {
                    int lastSlash;
                    String moduleName = modulePath;
                    if (moduleName.endsWith("/") || moduleName.endsWith("\\")) {
                        moduleName = moduleName.substring(0, moduleName.length() - 1);
                    }
                    if ((lastSlash = moduleName.lastIndexOf(47)) < 0) {
                        lastSlash = moduleName.lastIndexOf(92);
                    }
                    String adjustment = null;
                    if (lastSlash > -1) {
                        moduleName = moduleName.substring(lastSlash + 1);
                        adjustment = modulePath.substring(0, lastSlash);
                    }
                    this.moduleAdjustments.put(moduleName, adjustment);
                }
            }
        }
        return this.moduleAdjustments.get(module);
    }

    public Artifact getArtifact() {
        return this.artifact;
    }

    public void setArtifact(Artifact artifact) {
        this.artifact = artifact;
    }

    public Model getModel() {
        return this.model;
    }

    public MavenProject getParent() {
        if (this.parent == null) {
            if (this.parentFile != null) {
                this.checkProjectBuildingRequest();
                DefaultProjectBuildingRequest request = new DefaultProjectBuildingRequest(this.projectBuilderConfiguration);
                request.setRemoteRepositories(this.getRemoteArtifactRepositories());
                try {
                    this.parent = this.mavenProjectBuilder.build(this.parentFile, (ProjectBuildingRequest)request).getProject();
                }
                catch (ProjectBuildingException e) {
                    throw new IllegalStateException("Failed to build parent project for " + this.getId(), e);
                }
            }
            if (this.model.getParent() != null) {
                this.checkProjectBuildingRequest();
                DefaultProjectBuildingRequest request = new DefaultProjectBuildingRequest(this.projectBuilderConfiguration);
                request.setRemoteRepositories(this.getRemoteArtifactRepositories());
                try {
                    this.parent = this.mavenProjectBuilder.build(this.getParentArtifact(), (ProjectBuildingRequest)request).getProject();
                }
                catch (ProjectBuildingException e) {
                    throw new IllegalStateException("Failed to build parent project for " + this.getId(), e);
                }
            }
        }
        return this.parent;
    }

    public void setParent(MavenProject parent) {
        this.parent = parent;
    }

    public boolean hasParent() {
        return this.getParent() != null;
    }

    public File getFile() {
        return this.file;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public File getBasedir() {
        if (this.getFile() != null) {
            return this.getFile().getParentFile();
        }
        return null;
    }

    public void setDependencies(List<Dependency> dependencies) {
        this.getModel().setDependencies(dependencies);
    }

    public List<Dependency> getDependencies() {
        return this.getModel().getDependencies();
    }

    public DependencyManagement getDependencyManagement() {
        return this.getModel().getDependencyManagement();
    }

    private void addPath(List<String> paths, String path) {
        File file;
        if (path != null && (path = path.trim()).length() > 0 && !paths.contains(path = (file = new File(path)).isAbsolute() ? file.getAbsolutePath() : new File(this.getBasedir(), path).getAbsolutePath())) {
            paths.add(path);
        }
    }

    public void addCompileSourceRoot(String path) {
        this.addPath(this.getCompileSourceRoots(), path);
    }

    public void addScriptSourceRoot(String path) {
        if (path != null && (path = path.trim()).length() != 0 && !this.getScriptSourceRoots().contains(path)) {
            this.getScriptSourceRoots().add(path);
        }
    }

    public void addTestCompileSourceRoot(String path) {
        this.addPath(this.getTestCompileSourceRoots(), path);
    }

    public List<String> getCompileSourceRoots() {
        return this.compileSourceRoots;
    }

    public List<String> getScriptSourceRoots() {
        return this.scriptSourceRoots;
    }

    public List<String> getTestCompileSourceRoots() {
        return this.testCompileSourceRoots;
    }

    public List<String> getCompileClasspathElements() throws DependencyResolutionRequiredException {
        ArrayList<String> list = new ArrayList<String>(this.getArtifacts().size() + 1);
        list.add(this.getBuild().getOutputDirectory());
        for (Artifact a : this.getArtifacts()) {
            if (!a.getArtifactHandler().isAddedToClasspath() || !"compile".equals(a.getScope()) && !"provided".equals(a.getScope()) && !"system".equals(a.getScope())) continue;
            this.addArtifactPath(a, list);
        }
        return list;
    }

    @Deprecated
    public List<Artifact> getCompileArtifacts() {
        ArrayList<Artifact> list = new ArrayList<Artifact>(this.getArtifacts().size());
        for (Artifact a : this.getArtifacts()) {
            if (!a.getArtifactHandler().isAddedToClasspath() || !"compile".equals(a.getScope()) && !"provided".equals(a.getScope()) && !"system".equals(a.getScope())) continue;
            list.add(a);
        }
        return list;
    }

    @Deprecated
    public List<Dependency> getCompileDependencies() {
        Set<Artifact> artifacts2 = this.getArtifacts();
        if (artifacts2 == null || artifacts2.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Dependency> list = new ArrayList<Dependency>(artifacts2.size());
        for (Artifact a : this.getArtifacts()) {
            if (!"compile".equals(a.getScope()) && !"provided".equals(a.getScope()) && !"system".equals(a.getScope())) continue;
            Dependency dependency = new Dependency();
            dependency.setArtifactId(a.getArtifactId());
            dependency.setGroupId(a.getGroupId());
            dependency.setVersion(a.getVersion());
            dependency.setScope(a.getScope());
            dependency.setType(a.getType());
            dependency.setClassifier(a.getClassifier());
            list.add(dependency);
        }
        return list;
    }

    public List<String> getTestClasspathElements() throws DependencyResolutionRequiredException {
        ArrayList<String> list = new ArrayList<String>(this.getArtifacts().size() + 2);
        list.add(this.getBuild().getTestOutputDirectory());
        list.add(this.getBuild().getOutputDirectory());
        for (Artifact a : this.getArtifacts()) {
            if (!a.getArtifactHandler().isAddedToClasspath()) continue;
            this.addArtifactPath(a, list);
        }
        return list;
    }

    @Deprecated
    public List<Artifact> getTestArtifacts() {
        ArrayList<Artifact> list = new ArrayList<Artifact>(this.getArtifacts().size());
        for (Artifact a : this.getArtifacts()) {
            if (!a.getArtifactHandler().isAddedToClasspath()) continue;
            list.add(a);
        }
        return list;
    }

    @Deprecated
    public List<Dependency> getTestDependencies() {
        Set<Artifact> artifacts2 = this.getArtifacts();
        if (artifacts2 == null || artifacts2.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Dependency> list = new ArrayList<Dependency>(artifacts2.size());
        for (Artifact a : this.getArtifacts()) {
            Dependency dependency = new Dependency();
            dependency.setArtifactId(a.getArtifactId());
            dependency.setGroupId(a.getGroupId());
            dependency.setVersion(a.getVersion());
            dependency.setScope(a.getScope());
            dependency.setType(a.getType());
            dependency.setClassifier(a.getClassifier());
            list.add(dependency);
        }
        return list;
    }

    public List<String> getRuntimeClasspathElements() throws DependencyResolutionRequiredException {
        ArrayList<String> list = new ArrayList<String>(this.getArtifacts().size() + 1);
        list.add(this.getBuild().getOutputDirectory());
        for (Artifact a : this.getArtifacts()) {
            if (!a.getArtifactHandler().isAddedToClasspath() || !"compile".equals(a.getScope()) && !"runtime".equals(a.getScope())) continue;
            this.addArtifactPath(a, list);
        }
        return list;
    }

    @Deprecated
    public List<Artifact> getRuntimeArtifacts() {
        ArrayList<Artifact> list = new ArrayList<Artifact>(this.getArtifacts().size());
        for (Artifact a : this.getArtifacts()) {
            if (!a.getArtifactHandler().isAddedToClasspath() || !"compile".equals(a.getScope()) && !"runtime".equals(a.getScope())) continue;
            list.add(a);
        }
        return list;
    }

    @Deprecated
    public List<Dependency> getRuntimeDependencies() {
        Set<Artifact> artifacts2 = this.getArtifacts();
        if (artifacts2 == null || artifacts2.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Dependency> list = new ArrayList<Dependency>(artifacts2.size());
        for (Artifact a : this.getArtifacts()) {
            if (!"compile".equals(a.getScope()) && !"runtime".equals(a.getScope())) continue;
            Dependency dependency = new Dependency();
            dependency.setArtifactId(a.getArtifactId());
            dependency.setGroupId(a.getGroupId());
            dependency.setVersion(a.getVersion());
            dependency.setScope(a.getScope());
            dependency.setType(a.getType());
            dependency.setClassifier(a.getClassifier());
            list.add(dependency);
        }
        return list;
    }

    public List<String> getSystemClasspathElements() throws DependencyResolutionRequiredException {
        ArrayList<String> list = new ArrayList<String>(this.getArtifacts().size());
        list.add(this.getBuild().getOutputDirectory());
        for (Artifact a : this.getArtifacts()) {
            if (!a.getArtifactHandler().isAddedToClasspath() || !"system".equals(a.getScope())) continue;
            this.addArtifactPath(a, list);
        }
        return list;
    }

    @Deprecated
    public List<Artifact> getSystemArtifacts() {
        ArrayList<Artifact> list = new ArrayList<Artifact>(this.getArtifacts().size());
        for (Artifact a : this.getArtifacts()) {
            if (!a.getArtifactHandler().isAddedToClasspath() || !"system".equals(a.getScope())) continue;
            list.add(a);
        }
        return list;
    }

    @Deprecated
    public List<Dependency> getSystemDependencies() {
        Set<Artifact> artifacts2 = this.getArtifacts();
        if (artifacts2 == null || artifacts2.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Dependency> list = new ArrayList<Dependency>(artifacts2.size());
        for (Artifact a : this.getArtifacts()) {
            if (!"system".equals(a.getScope())) continue;
            Dependency dependency = new Dependency();
            dependency.setArtifactId(a.getArtifactId());
            dependency.setGroupId(a.getGroupId());
            dependency.setVersion(a.getVersion());
            dependency.setScope(a.getScope());
            dependency.setType(a.getType());
            dependency.setClassifier(a.getClassifier());
            list.add(dependency);
        }
        return list;
    }

    public void setModelVersion(String pomVersion) {
        this.getModel().setModelVersion(pomVersion);
    }

    public String getModelVersion() {
        return this.getModel().getModelVersion();
    }

    public String getId() {
        return this.getModel().getId();
    }

    public void setGroupId(String groupId) {
        this.getModel().setGroupId(groupId);
    }

    public String getGroupId() {
        String groupId = this.getModel().getGroupId();
        if (groupId == null && this.getModel().getParent() != null) {
            groupId = this.getModel().getParent().getGroupId();
        }
        return groupId;
    }

    public void setArtifactId(String artifactId) {
        this.getModel().setArtifactId(artifactId);
    }

    public String getArtifactId() {
        return this.getModel().getArtifactId();
    }

    public void setName(String name) {
        this.getModel().setName(name);
    }

    public String getName() {
        if (this.getModel().getName() != null) {
            return this.getModel().getName();
        }
        return this.getArtifactId();
    }

    public void setVersion(String version) {
        this.getModel().setVersion(version);
    }

    public String getVersion() {
        String version = this.getModel().getVersion();
        if (version == null && this.getModel().getParent() != null) {
            version = this.getModel().getParent().getVersion();
        }
        return version;
    }

    public String getPackaging() {
        return this.getModel().getPackaging();
    }

    public void setPackaging(String packaging) {
        this.getModel().setPackaging(packaging);
    }

    public void setInceptionYear(String inceptionYear) {
        this.getModel().setInceptionYear(inceptionYear);
    }

    public String getInceptionYear() {
        return this.getModel().getInceptionYear();
    }

    public void setUrl(String url) {
        this.getModel().setUrl(url);
    }

    public String getUrl() {
        return this.getModel().getUrl();
    }

    public Prerequisites getPrerequisites() {
        return this.getModel().getPrerequisites();
    }

    public void setIssueManagement(IssueManagement issueManagement) {
        this.getModel().setIssueManagement(issueManagement);
    }

    public CiManagement getCiManagement() {
        return this.getModel().getCiManagement();
    }

    public void setCiManagement(CiManagement ciManagement) {
        this.getModel().setCiManagement(ciManagement);
    }

    public IssueManagement getIssueManagement() {
        return this.getModel().getIssueManagement();
    }

    public void setDistributionManagement(DistributionManagement distributionManagement) {
        this.getModel().setDistributionManagement(distributionManagement);
    }

    public DistributionManagement getDistributionManagement() {
        return this.getModel().getDistributionManagement();
    }

    public void setDescription(String description) {
        this.getModel().setDescription(description);
    }

    public String getDescription() {
        return this.getModel().getDescription();
    }

    public void setOrganization(Organization organization) {
        this.getModel().setOrganization(organization);
    }

    public Organization getOrganization() {
        return this.getModel().getOrganization();
    }

    public void setScm(Scm scm) {
        this.getModel().setScm(scm);
    }

    public Scm getScm() {
        return this.getModel().getScm();
    }

    public void setMailingLists(List<MailingList> mailingLists) {
        this.getModel().setMailingLists(mailingLists);
    }

    public List<MailingList> getMailingLists() {
        return this.getModel().getMailingLists();
    }

    public void addMailingList(MailingList mailingList) {
        this.getModel().addMailingList(mailingList);
    }

    public void setDevelopers(List<Developer> developers) {
        this.getModel().setDevelopers(developers);
    }

    public List<Developer> getDevelopers() {
        return this.getModel().getDevelopers();
    }

    public void addDeveloper(Developer developer) {
        this.getModel().addDeveloper(developer);
    }

    public void setContributors(List<Contributor> contributors) {
        this.getModel().setContributors(contributors);
    }

    public List<Contributor> getContributors() {
        return this.getModel().getContributors();
    }

    public void addContributor(Contributor contributor) {
        this.getModel().addContributor(contributor);
    }

    public void setBuild(Build build) {
        this.getModel().setBuild(build);
    }

    public Build getBuild() {
        return this.getModelBuild();
    }

    public List<Resource> getResources() {
        return this.getBuild().getResources();
    }

    public List<Resource> getTestResources() {
        return this.getBuild().getTestResources();
    }

    public void addResource(Resource resource) {
        this.getBuild().addResource(resource);
    }

    public void addTestResource(Resource testResource) {
        this.getBuild().addTestResource(testResource);
    }

    @Deprecated
    public void setReporting(Reporting reporting) {
        this.getModel().setReporting(reporting);
    }

    @Deprecated
    public Reporting getReporting() {
        return this.getModel().getReporting();
    }

    public void setLicenses(List<License> licenses) {
        this.getModel().setLicenses(licenses);
    }

    public List<License> getLicenses() {
        return this.getModel().getLicenses();
    }

    public void addLicense(License license) {
        this.getModel().addLicense(license);
    }

    public void setArtifacts(Set<Artifact> artifacts2) {
        this.artifacts = artifacts2;
        this.artifactMap = null;
    }

    public Set<Artifact> getArtifacts() {
        if (this.artifacts == null) {
            if (this.artifactFilter == null || this.resolvedArtifacts == null) {
                this.artifacts = new LinkedHashSet<Artifact>();
            } else {
                this.artifacts = new LinkedHashSet<Artifact>(this.resolvedArtifacts.size() * 2);
                for (Artifact artifact : this.resolvedArtifacts) {
                    if (!this.artifactFilter.include(artifact)) continue;
                    this.artifacts.add(artifact);
                }
            }
        }
        return this.artifacts;
    }

    public Map<String, Artifact> getArtifactMap() {
        if (this.artifactMap == null) {
            this.artifactMap = ArtifactUtils.artifactMapByVersionlessId(this.getArtifacts());
        }
        return this.artifactMap;
    }

    public void setPluginArtifacts(Set<Artifact> pluginArtifacts) {
        this.pluginArtifacts = pluginArtifacts;
        this.pluginArtifactMap = null;
    }

    public Set<Artifact> getPluginArtifacts() {
        if (this.pluginArtifacts != null) {
            return this.pluginArtifacts;
        }
        this.pluginArtifacts = new HashSet<Artifact>();
        if (this.repositorySystem != null) {
            for (Plugin p : this.getBuildPlugins()) {
                Artifact artifact = this.repositorySystem.createPluginArtifact(p);
                if (artifact == null) continue;
                this.pluginArtifacts.add(artifact);
            }
        }
        this.pluginArtifactMap = null;
        return this.pluginArtifacts;
    }

    public Map<String, Artifact> getPluginArtifactMap() {
        if (this.pluginArtifactMap == null) {
            this.pluginArtifactMap = ArtifactUtils.artifactMapByVersionlessId(this.getPluginArtifacts());
        }
        return this.pluginArtifactMap;
    }

    @Deprecated
    public void setReportArtifacts(Set<Artifact> reportArtifacts) {
        this.reportArtifacts = reportArtifacts;
        this.reportArtifactMap = null;
    }

    @Deprecated
    public Set<Artifact> getReportArtifacts() {
        if (this.reportArtifacts != null) {
            return this.reportArtifacts;
        }
        this.reportArtifacts = new HashSet<Artifact>();
        if (this.repositorySystem != null) {
            for (ReportPlugin p : this.getReportPlugins()) {
                Plugin pp = new Plugin();
                pp.setGroupId(p.getGroupId());
                pp.setArtifactId(p.getArtifactId());
                pp.setVersion(p.getVersion());
                Artifact artifact = this.repositorySystem.createPluginArtifact(pp);
                if (artifact == null) continue;
                this.reportArtifacts.add(artifact);
            }
        }
        this.reportArtifactMap = null;
        return this.reportArtifacts;
    }

    @Deprecated
    public Map<String, Artifact> getReportArtifactMap() {
        if (this.reportArtifactMap == null) {
            this.reportArtifactMap = ArtifactUtils.artifactMapByVersionlessId(this.getReportArtifacts());
        }
        return this.reportArtifactMap;
    }

    public void setExtensionArtifacts(Set<Artifact> extensionArtifacts) {
        this.extensionArtifacts = extensionArtifacts;
        this.extensionArtifactMap = null;
    }

    public Set<Artifact> getExtensionArtifacts() {
        if (this.extensionArtifacts != null) {
            return this.extensionArtifacts;
        }
        this.extensionArtifacts = new HashSet<Artifact>();
        List<Extension> extensions = this.getBuildExtensions();
        if (extensions != null) {
            for (Extension ext : extensions) {
                String version = StringUtils.isEmpty(ext.getVersion()) ? "RELEASE" : ext.getVersion();
                Artifact artifact = this.repositorySystem.createArtifact(ext.getGroupId(), ext.getArtifactId(), version, null, "jar");
                if (artifact == null) continue;
                this.extensionArtifacts.add(artifact);
            }
        }
        this.extensionArtifactMap = null;
        return this.extensionArtifacts;
    }

    public Map<String, Artifact> getExtensionArtifactMap() {
        if (this.extensionArtifactMap == null) {
            this.extensionArtifactMap = ArtifactUtils.artifactMapByVersionlessId(this.getExtensionArtifacts());
        }
        return this.extensionArtifactMap;
    }

    public void setParentArtifact(Artifact parentArtifact) {
        this.parentArtifact = parentArtifact;
    }

    public Artifact getParentArtifact() {
        if (this.parentArtifact == null && this.model.getParent() != null) {
            Parent p = this.model.getParent();
            this.parentArtifact = this.repositorySystem.createProjectArtifact(p.getGroupId(), p.getArtifactId(), p.getVersion());
        }
        return this.parentArtifact;
    }

    public List<Repository> getRepositories() {
        return this.getModel().getRepositories();
    }

    @Deprecated
    public List<ReportPlugin> getReportPlugins() {
        if (this.getModel().getReporting() == null) {
            return Collections.emptyList();
        }
        return this.getModel().getReporting().getPlugins();
    }

    public List<Plugin> getBuildPlugins() {
        if (this.getModel().getBuild() == null) {
            return Collections.emptyList();
        }
        return this.getModel().getBuild().getPlugins();
    }

    public List<String> getModules() {
        return this.getModel().getModules();
    }

    public PluginManagement getPluginManagement() {
        PluginManagement pluginMgmt = null;
        Build build = this.getModel().getBuild();
        if (build != null) {
            pluginMgmt = build.getPluginManagement();
        }
        return pluginMgmt;
    }

    private Build getModelBuild() {
        Build build = this.getModel().getBuild();
        if (build == null) {
            build = new Build();
            this.getModel().setBuild(build);
        }
        return build;
    }

    public void setRemoteArtifactRepositories(List<ArtifactRepository> remoteArtifactRepositories) {
        this.remoteArtifactRepositories = remoteArtifactRepositories;
        this.remoteProjectRepositories = RepositoryUtils.toRepos(this.getRemoteArtifactRepositories());
    }

    public List<ArtifactRepository> getRemoteArtifactRepositories() {
        if (this.remoteArtifactRepositories == null) {
            this.remoteArtifactRepositories = new ArrayList<ArtifactRepository>();
        }
        return this.remoteArtifactRepositories;
    }

    public void setPluginArtifactRepositories(List<ArtifactRepository> pluginArtifactRepositories) {
        this.pluginArtifactRepositories = pluginArtifactRepositories;
        this.remotePluginRepositories = RepositoryUtils.toRepos(this.getPluginArtifactRepositories());
    }

    public List<ArtifactRepository> getPluginArtifactRepositories() {
        if (this.pluginArtifactRepositories == null) {
            this.pluginArtifactRepositories = new ArrayList<ArtifactRepository>();
        }
        return this.pluginArtifactRepositories;
    }

    public ArtifactRepository getDistributionManagementArtifactRepository() {
        return this.getArtifact().isSnapshot() && this.getSnapshotArtifactRepository() != null ? this.getSnapshotArtifactRepository() : this.getReleaseArtifactRepository();
    }

    public List<Repository> getPluginRepositories() {
        return this.getModel().getPluginRepositories();
    }

    public List<RemoteRepository> getRemoteProjectRepositories() {
        return this.remoteProjectRepositories;
    }

    public List<RemoteRepository> getRemotePluginRepositories() {
        return this.remotePluginRepositories;
    }

    public void setActiveProfiles(List<Profile> activeProfiles) {
        this.activeProfiles = activeProfiles;
    }

    public List<Profile> getActiveProfiles() {
        return this.activeProfiles;
    }

    public void setInjectedProfileIds(String source, List<String> injectedProfileIds) {
        if (injectedProfileIds != null) {
            this.injectedProfileIds.put(source, new ArrayList<String>(injectedProfileIds));
        } else {
            this.injectedProfileIds.remove(source);
        }
    }

    public Map<String, List<String>> getInjectedProfileIds() {
        return this.injectedProfileIds;
    }

    public void addAttachedArtifact(Artifact artifact) throws DuplicateArtifactAttachmentException {
        List<Artifact> attachedArtifacts = this.getAttachedArtifacts();
        if (attachedArtifacts.contains(artifact)) {
            if (this.logger != null) {
                this.logger.warn("Artifact " + artifact + " already attached to project, ignoring duplicate");
            }
            return;
        }
        this.getAttachedArtifacts().add(artifact);
    }

    public List<Artifact> getAttachedArtifacts() {
        if (this.attachedArtifacts == null) {
            this.attachedArtifacts = new ArrayList<Artifact>();
        }
        return this.attachedArtifacts;
    }

    public Xpp3Dom getGoalConfiguration(String pluginGroupId, String pluginArtifactId, String executionId, String goalId) {
        Xpp3Dom dom = null;
        if (this.getBuildPlugins() != null) {
            for (Plugin plugin : this.getBuildPlugins()) {
                PluginExecution execution;
                if (!pluginGroupId.equals(plugin.getGroupId()) || !pluginArtifactId.equals(plugin.getArtifactId())) continue;
                dom = (Xpp3Dom)plugin.getConfiguration();
                if (executionId == null || (execution = plugin.getExecutionsAsMap().get(executionId)) == null) break;
                dom = (Xpp3Dom)execution.getConfiguration();
                break;
            }
        }
        if (dom != null) {
            dom = new Xpp3Dom(dom);
        }
        return dom;
    }

    @Deprecated
    public Xpp3Dom getReportConfiguration(String pluginGroupId, String pluginArtifactId, String reportSetId) {
        Xpp3Dom dom = null;
        if (this.getReportPlugins() != null) {
            for (ReportPlugin plugin : this.getReportPlugins()) {
                Xpp3Dom executionConfiguration;
                ReportSet reportSet;
                if (!pluginGroupId.equals(plugin.getGroupId()) || !pluginArtifactId.equals(plugin.getArtifactId())) continue;
                dom = (Xpp3Dom)plugin.getConfiguration();
                if (reportSetId == null || (reportSet = plugin.getReportSetsAsMap().get(reportSetId)) == null || (executionConfiguration = (Xpp3Dom)reportSet.getConfiguration()) == null) break;
                Xpp3Dom newDom = new Xpp3Dom(executionConfiguration);
                dom = Xpp3Dom.mergeXpp3Dom(newDom, dom);
                break;
            }
        }
        if (dom != null) {
            dom = new Xpp3Dom(dom);
        }
        return dom;
    }

    public MavenProject getExecutionProject() {
        return this.executionProject == null ? this : this.executionProject;
    }

    public void setExecutionProject(MavenProject executionProject) {
        this.executionProject = executionProject;
    }

    public List<MavenProject> getCollectedProjects() {
        return this.collectedProjects;
    }

    public void setCollectedProjects(List<MavenProject> collectedProjects) {
        this.collectedProjects = collectedProjects;
    }

    public Set<Artifact> getDependencyArtifacts() {
        return this.dependencyArtifacts;
    }

    public void setDependencyArtifacts(Set<Artifact> dependencyArtifacts) {
        this.dependencyArtifacts = dependencyArtifacts;
    }

    public void setReleaseArtifactRepository(ArtifactRepository releaseArtifactRepository) {
        this.releaseArtifactRepository = releaseArtifactRepository;
    }

    public void setSnapshotArtifactRepository(ArtifactRepository snapshotArtifactRepository) {
        this.snapshotArtifactRepository = snapshotArtifactRepository;
    }

    public void setOriginalModel(Model originalModel) {
        this.originalModel = originalModel;
    }

    public Model getOriginalModel() {
        return this.originalModel;
    }

    public void setManagedVersionMap(Map<String, Artifact> map) {
        this.managedVersionMap = map;
    }

    public Map<String, Artifact> getManagedVersionMap() {
        if (this.managedVersionMap != null) {
            return this.managedVersionMap;
        }
        Map<String, Artifact> map = null;
        if (this.repositorySystem != null) {
            List<Dependency> deps;
            DependencyManagement dependencyManagement = this.getDependencyManagement();
            if (dependencyManagement != null && (deps = dependencyManagement.getDependencies()) != null && deps.size() > 0) {
                map = new HashMap();
                for (Dependency d : dependencyManagement.getDependencies()) {
                    Artifact artifact = this.repositorySystem.createDependencyArtifact(d);
                    if (artifact == null) {
                        map = Collections.emptyMap();
                    }
                    map.put(d.getManagementKey(), artifact);
                }
            } else {
                map = Collections.emptyMap();
            }
        }
        this.managedVersionMap = map;
        return this.managedVersionMap;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof MavenProject)) {
            return false;
        }
        MavenProject that = (MavenProject)other;
        return MavenProject.eq(this.getArtifactId(), that.getArtifactId()) && MavenProject.eq(this.getGroupId(), that.getGroupId()) && MavenProject.eq(this.getVersion(), that.getVersion());
    }

    private static <T> boolean eq(T s1, T s2) {
        return s1 != null ? s1.equals(s2) : s2 == null;
    }

    public int hashCode() {
        int hash = 17;
        hash = 31 * hash + this.getGroupId().hashCode();
        hash = 31 * hash + this.getArtifactId().hashCode();
        hash = 31 * hash + this.getVersion().hashCode();
        return hash;
    }

    public List<Extension> getBuildExtensions() {
        Build build = this.getBuild();
        if (build == null || build.getExtensions() == null) {
            return Collections.emptyList();
        }
        return build.getExtensions();
    }

    public void addProjectReference(MavenProject project) {
        this.projectReferences.put(MavenProject.getProjectReferenceId(project.getGroupId(), project.getArtifactId(), project.getVersion()), project);
    }

    @Deprecated
    public void attachArtifact(String type, String classifier, File file) {
    }

    public Properties getProperties() {
        return this.getModel().getProperties();
    }

    public List<String> getFilters() {
        return this.getBuild().getFilters();
    }

    public Map<String, MavenProject> getProjectReferences() {
        return this.projectReferences;
    }

    public boolean isExecutionRoot() {
        return this.executionRoot;
    }

    public void setExecutionRoot(boolean executionRoot) {
        this.executionRoot = executionRoot;
    }

    public String getDefaultGoal() {
        return this.getBuild() != null ? this.getBuild().getDefaultGoal() : null;
    }

    public Plugin getPlugin(String pluginKey) {
        return this.getBuild().getPluginsAsMap().get(pluginKey);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(128);
        sb.append("MavenProject: ");
        sb.append(this.getGroupId());
        sb.append(":");
        sb.append(this.getArtifactId());
        sb.append(":");
        sb.append(this.getVersion());
        sb.append(" @ ");
        try {
            sb.append(this.getFile().getPath());
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return sb.toString();
    }

    @Deprecated
    public void writeModel(Writer writer) throws IOException {
        MavenXpp3Writer pomWriter = new MavenXpp3Writer();
        pomWriter.write(writer, this.getModel());
    }

    @Deprecated
    public void writeOriginalModel(Writer writer) throws IOException {
        MavenXpp3Writer pomWriter = new MavenXpp3Writer();
        pomWriter.write(writer, this.getOriginalModel());
    }

    public MavenProject clone() {
        MavenProject clone;
        try {
            clone = (MavenProject)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new UnsupportedOperationException(e);
        }
        clone.deepCopy(this);
        return clone;
    }

    protected void setModel(Model model) {
        this.model = model;
    }

    protected void setAttachedArtifacts(List<Artifact> attachedArtifacts) {
        this.attachedArtifacts = attachedArtifacts;
    }

    protected void setCompileSourceRoots(List<String> compileSourceRoots) {
        this.compileSourceRoots = compileSourceRoots;
    }

    protected void setTestCompileSourceRoots(List<String> testCompileSourceRoots) {
        this.testCompileSourceRoots = testCompileSourceRoots;
    }

    protected void setScriptSourceRoots(List<String> scriptSourceRoots) {
        this.scriptSourceRoots = scriptSourceRoots;
    }

    protected ArtifactRepository getReleaseArtifactRepository() {
        if (this.releaseArtifactRepository == null && this.getDistributionManagement() != null && this.getDistributionManagement().getRepository() != null) {
            this.checkProjectBuildingRequest();
            try {
                ArtifactRepository repo = this.repositorySystem.buildArtifactRepository(this.getDistributionManagement().getRepository());
                this.repositorySystem.injectProxy(this.projectBuilderConfiguration.getRepositorySession(), Arrays.asList(repo));
                this.repositorySystem.injectAuthentication(this.projectBuilderConfiguration.getRepositorySession(), Arrays.asList(repo));
                this.setReleaseArtifactRepository(repo);
            }
            catch (InvalidRepositoryException e) {
                throw new IllegalStateException("Failed to create release distribution repository for " + this.getId(), e);
            }
        }
        return this.releaseArtifactRepository;
    }

    protected ArtifactRepository getSnapshotArtifactRepository() {
        if (this.snapshotArtifactRepository == null && this.getDistributionManagement() != null && this.getDistributionManagement().getSnapshotRepository() != null) {
            this.checkProjectBuildingRequest();
            try {
                ArtifactRepository repo = this.repositorySystem.buildArtifactRepository(this.getDistributionManagement().getSnapshotRepository());
                this.repositorySystem.injectProxy(this.projectBuilderConfiguration.getRepositorySession(), Arrays.asList(repo));
                this.repositorySystem.injectAuthentication(this.projectBuilderConfiguration.getRepositorySession(), Arrays.asList(repo));
                this.setSnapshotArtifactRepository(repo);
            }
            catch (InvalidRepositoryException e) {
                throw new IllegalStateException("Failed to create snapshot distribution repository for " + this.getId(), e);
            }
        }
        return this.snapshotArtifactRepository;
    }

    @Deprecated
    public Artifact replaceWithActiveArtifact(Artifact pluginArtifact) {
        return pluginArtifact;
    }

    private void deepCopy(MavenProject project) {
        this.setFile(project.getFile());
        if (project.getDependencyArtifacts() != null) {
            this.setDependencyArtifacts(Collections.unmodifiableSet(project.getDependencyArtifacts()));
        }
        if (project.getArtifacts() != null) {
            this.setArtifacts(Collections.unmodifiableSet(project.getArtifacts()));
        }
        if (project.getParentFile() != null) {
            this.parentFile = new File(project.getParentFile().getAbsolutePath());
        }
        if (project.getPluginArtifacts() != null) {
            this.setPluginArtifacts(Collections.unmodifiableSet(project.getPluginArtifacts()));
        }
        if (project.getReportArtifacts() != null) {
            this.setReportArtifacts(Collections.unmodifiableSet(project.getReportArtifacts()));
        }
        if (project.getExtensionArtifacts() != null) {
            this.setExtensionArtifacts(Collections.unmodifiableSet(project.getExtensionArtifacts()));
        }
        this.setParentArtifact(project.getParentArtifact());
        if (project.getRemoteArtifactRepositories() != null) {
            this.setRemoteArtifactRepositories(Collections.unmodifiableList(project.getRemoteArtifactRepositories()));
        }
        if (project.getPluginArtifactRepositories() != null) {
            this.setPluginArtifactRepositories(Collections.unmodifiableList(project.getPluginArtifactRepositories()));
        }
        if (project.getActiveProfiles() != null) {
            this.setActiveProfiles(Collections.unmodifiableList(project.getActiveProfiles()));
        }
        if (project.getAttachedArtifacts() != null) {
            this.setAttachedArtifacts(new ArrayList<Artifact>(project.getAttachedArtifacts()));
        }
        if (project.getCompileSourceRoots() != null) {
            this.setCompileSourceRoots(new ArrayList<String>(project.getCompileSourceRoots()));
        }
        if (project.getTestCompileSourceRoots() != null) {
            this.setTestCompileSourceRoots(new ArrayList<String>(project.getTestCompileSourceRoots()));
        }
        if (project.getScriptSourceRoots() != null) {
            this.setScriptSourceRoots(new ArrayList<String>(project.getScriptSourceRoots()));
        }
        if (project.getModel() != null) {
            this.setModel(project.getModel().clone());
        }
        if (project.getOriginalModel() != null) {
            this.setOriginalModel(project.getOriginalModel());
        }
        this.setExecutionRoot(project.isExecutionRoot());
        if (project.getArtifact() != null) {
            this.setArtifact(ArtifactUtils.copyArtifact(project.getArtifact()));
        }
        if (project.getManagedVersionMap() != null) {
            this.setManagedVersionMap(new HashMap<String, Artifact>(project.getManagedVersionMap()));
        }
        this.lifecyclePhases.addAll(project.lifecyclePhases);
    }

    private void addArtifactPath(Artifact artifact, List<String> classpath) {
        File file = artifact.getFile();
        if (file != null) {
            classpath.add(file.getPath());
        }
    }

    private static String getProjectReferenceId(String groupId, String artifactId, String version) {
        StringBuilder buffer = new StringBuilder(128);
        buffer.append(groupId).append(':').append(artifactId).append(':').append(version);
        return buffer.toString();
    }

    public void setContextValue(String key, Object value) {
        if (this.context == null) {
            this.context = new HashMap<String, Object>();
        }
        if (value != null) {
            this.context.put(key, value);
        } else {
            this.context.remove(key);
        }
    }

    public Object getContextValue(String key) {
        if (this.context == null) {
            return null;
        }
        return this.context.get(key);
    }

    public void setClassRealm(ClassRealm classRealm) {
        this.classRealm = classRealm;
    }

    public ClassRealm getClassRealm() {
        return this.classRealm;
    }

    public void setExtensionDependencyFilter(DependencyFilter extensionDependencyFilter) {
        this.extensionDependencyFilter = extensionDependencyFilter;
    }

    public DependencyFilter getExtensionDependencyFilter() {
        return this.extensionDependencyFilter;
    }

    public void setResolvedArtifacts(Set<Artifact> artifacts2) {
        this.resolvedArtifacts = artifacts2 != null ? artifacts2 : Collections.emptySet();
        this.artifacts = null;
        this.artifactMap = null;
    }

    public void setArtifactFilter(ArtifactFilter artifactFilter) {
        this.artifactFilter = artifactFilter;
        this.artifacts = null;
        this.artifactMap = null;
    }

    public boolean hasLifecyclePhase(String phase) {
        return this.lifecyclePhases.contains(phase);
    }

    public void addLifecyclePhase(String lifecyclePhase) {
        this.lifecyclePhases.add(lifecyclePhase);
    }

    public ProjectBuildingRequest getProjectBuildingRequest() {
        return this.projectBuilderConfiguration;
    }

    public void setProjectBuildingRequest(ProjectBuildingRequest projectBuildingRequest) {
        this.projectBuilderConfiguration = projectBuildingRequest;
    }

    private void checkProjectBuildingRequest() {
        if (this.projectBuilderConfiguration == null) {
            throw new IllegalStateException("project building request missing");
        }
    }
}

