/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.org.bouncycastle.jcajce.provider.asymmetric.edec;

import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.security.spec.X509EncodedKeySpec;
import org.gradle.internal.impldep.org.bouncycastle.asn1.ASN1InputStream;
import org.gradle.internal.impldep.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.gradle.internal.impldep.org.bouncycastle.asn1.ASN1OctetString;
import org.gradle.internal.impldep.org.bouncycastle.asn1.ASN1Sequence;
import org.gradle.internal.impldep.org.bouncycastle.asn1.DEROctetString;
import org.gradle.internal.impldep.org.bouncycastle.asn1.edec.EdECObjectIdentifiers;
import org.gradle.internal.impldep.org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.gradle.internal.impldep.org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.gradle.internal.impldep.org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.gradle.internal.impldep.org.bouncycastle.crypto.params.Ed25519PrivateKeyParameters;
import org.gradle.internal.impldep.org.bouncycastle.crypto.params.Ed25519PublicKeyParameters;
import org.gradle.internal.impldep.org.bouncycastle.crypto.util.OpenSSHPrivateKeyUtil;
import org.gradle.internal.impldep.org.bouncycastle.crypto.util.OpenSSHPublicKeyUtil;
import org.gradle.internal.impldep.org.bouncycastle.jcajce.provider.asymmetric.edec.BCEdDSAPrivateKey;
import org.gradle.internal.impldep.org.bouncycastle.jcajce.provider.asymmetric.edec.BCEdDSAPublicKey;
import org.gradle.internal.impldep.org.bouncycastle.jcajce.provider.asymmetric.edec.BCXDHPrivateKey;
import org.gradle.internal.impldep.org.bouncycastle.jcajce.provider.asymmetric.edec.BCXDHPublicKey;
import org.gradle.internal.impldep.org.bouncycastle.jcajce.provider.asymmetric.util.BaseKeyFactorySpi;
import org.gradle.internal.impldep.org.bouncycastle.jcajce.provider.util.AsymmetricKeyInfoConverter;
import org.gradle.internal.impldep.org.bouncycastle.jcajce.spec.OpenSSHPrivateKeySpec;
import org.gradle.internal.impldep.org.bouncycastle.jcajce.spec.OpenSSHPublicKeySpec;
import org.gradle.internal.impldep.org.bouncycastle.util.encoders.Hex;

public class KeyFactorySpi
extends BaseKeyFactorySpi
implements AsymmetricKeyInfoConverter {
    static final byte[] x448Prefix = Hex.decode("3042300506032b656f033900");
    static final byte[] x25519Prefix = Hex.decode("302a300506032b656e032100");
    static final byte[] Ed448Prefix = Hex.decode("3043300506032b6571033a00");
    static final byte[] Ed25519Prefix = Hex.decode("302a300506032b6570032100");
    private static final byte x448_type = 111;
    private static final byte x25519_type = 110;
    private static final byte Ed448_type = 113;
    private static final byte Ed25519_type = 112;
    String algorithm;
    private final boolean isXdh;
    private final int specificBase;

    public KeyFactorySpi(String string2, boolean bl, int n) {
        this.algorithm = string2;
        this.isXdh = bl;
        this.specificBase = n;
    }

    protected Key engineTranslateKey(Key key) throws InvalidKeyException {
        throw new InvalidKeyException("key type unknown");
    }

    protected KeySpec engineGetKeySpec(Key key, Class clazz) throws InvalidKeySpecException {
        if (clazz.isAssignableFrom(OpenSSHPrivateKeySpec.class) && key instanceof BCEdDSAPrivateKey) {
            try {
                ASN1Sequence aSN1Sequence = ASN1Sequence.getInstance(key.getEncoded());
                DEROctetString dEROctetString = (DEROctetString)aSN1Sequence.getObjectAt(2);
                ASN1InputStream aSN1InputStream = new ASN1InputStream(dEROctetString.getOctets());
                return new OpenSSHPrivateKeySpec(OpenSSHPrivateKeyUtil.encodePrivateKey(new Ed25519PrivateKeyParameters(ASN1OctetString.getInstance(aSN1InputStream.readObject()).getOctets(), 0)));
            }
            catch (IOException iOException) {
                throw new InvalidKeySpecException(iOException.getMessage(), iOException.getCause());
            }
        }
        if (clazz.isAssignableFrom(OpenSSHPublicKeySpec.class) && key instanceof BCEdDSAPublicKey) {
            try {
                return new OpenSSHPublicKeySpec(OpenSSHPublicKeyUtil.encodePublicKey(new Ed25519PublicKeyParameters(key.getEncoded(), Ed25519Prefix.length)));
            }
            catch (IOException iOException) {
                throw new InvalidKeySpecException(iOException.getMessage(), iOException.getCause());
            }
        }
        if (clazz.isAssignableFrom(org.gradle.internal.impldep.org.bouncycastle.jce.spec.OpenSSHPrivateKeySpec.class) && key instanceof BCEdDSAPrivateKey) {
            try {
                ASN1Sequence aSN1Sequence = ASN1Sequence.getInstance(key.getEncoded());
                DEROctetString dEROctetString = (DEROctetString)aSN1Sequence.getObjectAt(2);
                ASN1InputStream aSN1InputStream = new ASN1InputStream(dEROctetString.getOctets());
                return new org.gradle.internal.impldep.org.bouncycastle.jce.spec.OpenSSHPrivateKeySpec(OpenSSHPrivateKeyUtil.encodePrivateKey(new Ed25519PrivateKeyParameters(ASN1OctetString.getInstance(aSN1InputStream.readObject()).getOctets(), 0)));
            }
            catch (IOException iOException) {
                throw new InvalidKeySpecException(iOException.getMessage(), iOException.getCause());
            }
        }
        if (clazz.isAssignableFrom(org.gradle.internal.impldep.org.bouncycastle.jce.spec.OpenSSHPublicKeySpec.class) && key instanceof BCEdDSAPublicKey) {
            try {
                return new org.gradle.internal.impldep.org.bouncycastle.jce.spec.OpenSSHPublicKeySpec(OpenSSHPublicKeyUtil.encodePublicKey(new Ed25519PublicKeyParameters(key.getEncoded(), Ed25519Prefix.length)));
            }
            catch (IOException iOException) {
                throw new InvalidKeySpecException(iOException.getMessage(), iOException.getCause());
            }
        }
        return super.engineGetKeySpec(key, clazz);
    }

    protected PrivateKey engineGeneratePrivate(KeySpec keySpec) throws InvalidKeySpecException {
        if (keySpec instanceof OpenSSHPrivateKeySpec) {
            AsymmetricKeyParameter asymmetricKeyParameter = OpenSSHPrivateKeyUtil.parsePrivateKeyBlob(((OpenSSHPrivateKeySpec)keySpec).getEncoded());
            if (asymmetricKeyParameter instanceof Ed25519PrivateKeyParameters) {
                return new BCEdDSAPrivateKey((Ed25519PrivateKeyParameters)asymmetricKeyParameter);
            }
            throw new IllegalStateException("openssh private key not Ed25519 private key");
        }
        return super.engineGeneratePrivate(keySpec);
    }

    protected PublicKey engineGeneratePublic(KeySpec keySpec) throws InvalidKeySpecException {
        if (keySpec instanceof X509EncodedKeySpec) {
            byte[] byArray = ((X509EncodedKeySpec)keySpec).getEncoded();
            if (this.specificBase == 0 || this.specificBase == byArray[8]) {
                switch (byArray[8]) {
                    case 111: {
                        return new BCXDHPublicKey(x448Prefix, byArray);
                    }
                    case 110: {
                        return new BCXDHPublicKey(x25519Prefix, byArray);
                    }
                    case 113: {
                        return new BCEdDSAPublicKey(Ed448Prefix, byArray);
                    }
                    case 112: {
                        return new BCEdDSAPublicKey(Ed25519Prefix, byArray);
                    }
                }
                return super.engineGeneratePublic(keySpec);
            }
        } else if (keySpec instanceof OpenSSHPublicKeySpec) {
            AsymmetricKeyParameter asymmetricKeyParameter = OpenSSHPublicKeyUtil.parsePublicKey(((OpenSSHPublicKeySpec)keySpec).getEncoded());
            if (asymmetricKeyParameter instanceof Ed25519PublicKeyParameters) {
                return new BCEdDSAPublicKey(new byte[0], ((Ed25519PublicKeyParameters)asymmetricKeyParameter).getEncoded());
            }
            throw new IllegalStateException("openssh public key not Ed25519 public key");
        }
        return super.engineGeneratePublic(keySpec);
    }

    public PrivateKey generatePrivate(PrivateKeyInfo privateKeyInfo) throws IOException {
        ASN1ObjectIdentifier aSN1ObjectIdentifier = privateKeyInfo.getPrivateKeyAlgorithm().getAlgorithm();
        if (this.isXdh) {
            if ((this.specificBase == 0 || this.specificBase == 111) && aSN1ObjectIdentifier.equals(EdECObjectIdentifiers.id_X448)) {
                return new BCXDHPrivateKey(privateKeyInfo);
            }
            if ((this.specificBase == 0 || this.specificBase == 110) && aSN1ObjectIdentifier.equals(EdECObjectIdentifiers.id_X25519)) {
                return new BCXDHPrivateKey(privateKeyInfo);
            }
        } else if (aSN1ObjectIdentifier.equals(EdECObjectIdentifiers.id_Ed448) || aSN1ObjectIdentifier.equals(EdECObjectIdentifiers.id_Ed25519)) {
            if ((this.specificBase == 0 || this.specificBase == 113) && aSN1ObjectIdentifier.equals(EdECObjectIdentifiers.id_Ed448)) {
                return new BCEdDSAPrivateKey(privateKeyInfo);
            }
            if ((this.specificBase == 0 || this.specificBase == 112) && aSN1ObjectIdentifier.equals(EdECObjectIdentifiers.id_Ed25519)) {
                return new BCEdDSAPrivateKey(privateKeyInfo);
            }
        }
        throw new IOException("algorithm identifier " + aSN1ObjectIdentifier + " in key not recognized");
    }

    public PublicKey generatePublic(SubjectPublicKeyInfo subjectPublicKeyInfo) throws IOException {
        ASN1ObjectIdentifier aSN1ObjectIdentifier = subjectPublicKeyInfo.getAlgorithm().getAlgorithm();
        if (this.isXdh) {
            if ((this.specificBase == 0 || this.specificBase == 111) && aSN1ObjectIdentifier.equals(EdECObjectIdentifiers.id_X448)) {
                return new BCXDHPublicKey(subjectPublicKeyInfo);
            }
            if ((this.specificBase == 0 || this.specificBase == 110) && aSN1ObjectIdentifier.equals(EdECObjectIdentifiers.id_X25519)) {
                return new BCXDHPublicKey(subjectPublicKeyInfo);
            }
        } else if (aSN1ObjectIdentifier.equals(EdECObjectIdentifiers.id_Ed448) || aSN1ObjectIdentifier.equals(EdECObjectIdentifiers.id_Ed25519)) {
            if ((this.specificBase == 0 || this.specificBase == 113) && aSN1ObjectIdentifier.equals(EdECObjectIdentifiers.id_Ed448)) {
                return new BCEdDSAPublicKey(subjectPublicKeyInfo);
            }
            if ((this.specificBase == 0 || this.specificBase == 112) && aSN1ObjectIdentifier.equals(EdECObjectIdentifiers.id_Ed25519)) {
                return new BCEdDSAPublicKey(subjectPublicKeyInfo);
            }
        }
        throw new IOException("algorithm identifier " + aSN1ObjectIdentifier + " in key not recognized");
    }

    public static class ED25519
    extends KeyFactorySpi {
        public ED25519() {
            super("Ed25519", false, 112);
        }
    }

    public static class ED448
    extends KeyFactorySpi {
        public ED448() {
            super("Ed448", false, 113);
        }
    }

    public static class EDDSA
    extends KeyFactorySpi {
        public EDDSA() {
            super("EdDSA", false, 0);
        }
    }

    public static class X25519
    extends KeyFactorySpi {
        public X25519() {
            super("X25519", true, 110);
        }
    }

    public static class X448
    extends KeyFactorySpi {
        public X448() {
            super("X448", true, 111);
        }
    }

    public static class XDH
    extends KeyFactorySpi {
        public XDH() {
            super("XDH", true, 0);
        }
    }
}

