/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.org.bouncycastle.openpgp.operator.jcajce;

import java.io.IOException;
import java.math.BigInteger;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.gradle.internal.impldep.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.gradle.internal.impldep.org.bouncycastle.asn1.x9.ECNamedCurveTable;
import org.gradle.internal.impldep.org.bouncycastle.asn1.x9.X9ECParameters;
import org.gradle.internal.impldep.org.bouncycastle.crypto.ec.CustomNamedCurves;
import org.gradle.internal.impldep.org.bouncycastle.math.ec.ECCurve;
import org.gradle.internal.impldep.org.bouncycastle.math.ec.ECPoint;
import org.gradle.internal.impldep.org.bouncycastle.openpgp.PGPException;
import org.gradle.internal.impldep.org.bouncycastle.openpgp.PGPUtil;
import org.gradle.internal.impldep.org.bouncycastle.util.BigIntegers;

class JcaJcePGPUtil {
    JcaJcePGPUtil() {
    }

    public static SecretKey makeSymmetricKey(int n, byte[] byArray) throws PGPException {
        String string2 = PGPUtil.getSymmetricCipherName(n);
        if (string2 == null) {
            throw new PGPException("unknown symmetric algorithm: " + n);
        }
        return new SecretKeySpec(byArray, string2);
    }

    static ECPoint decodePoint(BigInteger bigInteger, ECCurve eCCurve) throws IOException {
        return eCCurve.decodePoint(BigIntegers.asUnsignedByteArray(bigInteger));
    }

    static X9ECParameters getX9Parameters(ASN1ObjectIdentifier aSN1ObjectIdentifier) {
        X9ECParameters x9ECParameters = CustomNamedCurves.getByOID(aSN1ObjectIdentifier);
        if (x9ECParameters == null) {
            return ECNamedCurveTable.getByOID(aSN1ObjectIdentifier);
        }
        return x9ECParameters;
    }
}

