/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.org.bouncycastle.openpgp.operator.jcajce;

import java.io.IOException;
import java.math.BigInteger;
import java.security.AlgorithmParameters;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.KeyAgreement;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.gradle.internal.impldep.org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.gradle.internal.impldep.org.bouncycastle.asn1.x9.X962Parameters;
import org.gradle.internal.impldep.org.bouncycastle.asn1.x9.X9ECParameters;
import org.gradle.internal.impldep.org.bouncycastle.asn1.x9.X9ECPoint;
import org.gradle.internal.impldep.org.bouncycastle.bcpg.ECDHPublicBCPGKey;
import org.gradle.internal.impldep.org.bouncycastle.bcpg.MPInteger;
import org.gradle.internal.impldep.org.bouncycastle.jcajce.spec.UserKeyingMaterialSpec;
import org.gradle.internal.impldep.org.bouncycastle.jcajce.util.DefaultJcaJceHelper;
import org.gradle.internal.impldep.org.bouncycastle.jcajce.util.NamedJcaJceHelper;
import org.gradle.internal.impldep.org.bouncycastle.jcajce.util.ProviderJcaJceHelper;
import org.gradle.internal.impldep.org.bouncycastle.math.ec.ECPoint;
import org.gradle.internal.impldep.org.bouncycastle.openpgp.PGPException;
import org.gradle.internal.impldep.org.bouncycastle.openpgp.PGPPublicKey;
import org.gradle.internal.impldep.org.bouncycastle.openpgp.PGPUtil;
import org.gradle.internal.impldep.org.bouncycastle.openpgp.operator.PGPPad;
import org.gradle.internal.impldep.org.bouncycastle.openpgp.operator.PublicKeyKeyEncryptionMethodGenerator;
import org.gradle.internal.impldep.org.bouncycastle.openpgp.operator.RFC6637Utils;
import org.gradle.internal.impldep.org.bouncycastle.openpgp.operator.jcajce.JcaJcePGPUtil;
import org.gradle.internal.impldep.org.bouncycastle.openpgp.operator.jcajce.JcaKeyFingerprintCalculator;
import org.gradle.internal.impldep.org.bouncycastle.openpgp.operator.jcajce.JcaPGPKeyConverter;
import org.gradle.internal.impldep.org.bouncycastle.openpgp.operator.jcajce.OperatorHelper;

public class JcePublicKeyKeyEncryptionMethodGenerator
extends PublicKeyKeyEncryptionMethodGenerator {
    private OperatorHelper helper = new OperatorHelper(new DefaultJcaJceHelper());
    private SecureRandom random;
    private JcaPGPKeyConverter keyConverter = new JcaPGPKeyConverter();

    public JcePublicKeyKeyEncryptionMethodGenerator(PGPPublicKey pGPPublicKey) {
        super(pGPPublicKey);
    }

    public JcePublicKeyKeyEncryptionMethodGenerator setProvider(Provider provider) {
        this.helper = new OperatorHelper(new ProviderJcaJceHelper(provider));
        this.keyConverter.setProvider(provider);
        return this;
    }

    public JcePublicKeyKeyEncryptionMethodGenerator setProvider(String string2) {
        this.helper = new OperatorHelper(new NamedJcaJceHelper(string2));
        this.keyConverter.setProvider(string2);
        return this;
    }

    public JcePublicKeyKeyEncryptionMethodGenerator setSecureRandom(SecureRandom secureRandom) {
        this.random = secureRandom;
        return this;
    }

    protected byte[] encryptSessionInfo(PGPPublicKey pGPPublicKey, byte[] byArray) throws PGPException {
        try {
            if (pGPPublicKey.getAlgorithm() == 18) {
                ECDHPublicBCPGKey eCDHPublicBCPGKey = (ECDHPublicBCPGKey)pGPPublicKey.getPublicKeyPacket().getKey();
                X9ECParameters x9ECParameters = JcaJcePGPUtil.getX9Parameters(eCDHPublicBCPGKey.getCurveOID());
                AlgorithmParameters algorithmParameters = this.helper.createAlgorithmParameters("EC");
                algorithmParameters.init(new X962Parameters(eCDHPublicBCPGKey.getCurveOID()).getEncoded());
                KeyPairGenerator keyPairGenerator = this.helper.createKeyPairGenerator("EC");
                keyPairGenerator.initialize(algorithmParameters.getParameterSpec(AlgorithmParameterSpec.class));
                KeyPair keyPair = keyPairGenerator.generateKeyPair();
                KeyAgreement keyAgreement = this.helper.createKeyAgreement(RFC6637Utils.getAgreementAlgorithm(pGPPublicKey.getPublicKeyPacket()));
                keyAgreement.init((Key)keyPair.getPrivate(), new UserKeyingMaterialSpec(RFC6637Utils.createUserKeyingMaterial(pGPPublicKey.getPublicKeyPacket(), new JcaKeyFingerprintCalculator())));
                keyAgreement.doPhase(this.keyConverter.getPublicKey(pGPPublicKey), true);
                SecretKey secretKey = keyAgreement.generateSecret(RFC6637Utils.getKeyEncryptionOID(eCDHPublicBCPGKey.getSymmetricKeyAlgorithm()).getId());
                Cipher cipher = this.helper.createKeyWrapper(eCDHPublicBCPGKey.getSymmetricKeyAlgorithm());
                cipher.init(3, (Key)secretKey, this.random);
                byte[] byArray2 = PGPPad.padSessionData(byArray);
                byte[] byArray3 = cipher.wrap(new SecretKeySpec(byArray2, PGPUtil.getSymmetricCipherName(byArray[0])));
                SubjectPublicKeyInfo subjectPublicKeyInfo = SubjectPublicKeyInfo.getInstance(keyPair.getPublic().getEncoded());
                X9ECPoint x9ECPoint = new X9ECPoint(x9ECParameters.getCurve(), subjectPublicKeyInfo.getPublicKeyData().getBytes());
                ECPoint eCPoint = x9ECPoint.getPoint();
                byte[] byArray4 = new MPInteger(new BigInteger(1, eCPoint.getEncoded(false))).getEncoded();
                byte[] byArray5 = new byte[byArray4.length + 1 + byArray3.length];
                System.arraycopy(byArray4, 0, byArray5, 0, byArray4.length);
                byArray5[byArray4.length] = (byte)byArray3.length;
                System.arraycopy(byArray3, 0, byArray5, byArray4.length + 1, byArray3.length);
                return byArray5;
            }
            Cipher cipher = this.helper.createPublicKeyCipher(pGPPublicKey.getAlgorithm());
            PublicKey publicKey = this.keyConverter.getPublicKey(pGPPublicKey);
            cipher.init(1, (Key)publicKey, this.random);
            return cipher.doFinal(byArray);
        }
        catch (IllegalBlockSizeException illegalBlockSizeException) {
            throw new PGPException("illegal block size: " + illegalBlockSizeException.getMessage(), illegalBlockSizeException);
        }
        catch (BadPaddingException badPaddingException) {
            throw new PGPException("bad padding: " + badPaddingException.getMessage(), badPaddingException);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new PGPException("key invalid: " + invalidKeyException.getMessage(), invalidKeyException);
        }
        catch (IOException iOException) {
            throw new PGPException("unable to encode MPI: " + iOException.getMessage(), iOException);
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new PGPException("unable to set up ephemeral keys: " + generalSecurityException.getMessage(), generalSecurityException);
        }
    }
}

